/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.ReadOnlyIterator;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.CollectionAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionAspectAdapterTests
extends TestCase {
    private TestSubject subject1;
    private WritablePropertyValueModel<TestSubject> subjectHolder1;
    private LocalCollectionAspectAdapter aa1;
    private CollectionEvent event1;
    private CollectionChangeListener listener1;
    private String event1Type;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String CHANGE = "change";
    private static final String CLEAR = "clear";
    private TestSubject subject2;

    public CollectionAspectAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.subject1 = new TestSubject();
        this.subject1.addNames(this.subject1Names());
        this.subject1.addDescriptions(this.subject1Descriptions());
        this.subjectHolder1 = new SimplePropertyValueModel((Object)this.subject1);
        this.aa1 = this.buildAspectAdapter((PropertyValueModel<TestSubject>)this.subjectHolder1);
        this.listener1 = this.buildValueChangeListener1();
        this.aa1.addCollectionChangeListener("values", this.listener1);
        this.event1 = null;
        this.event1Type = null;
        this.subject2 = new TestSubject();
        this.subject2.addNames(this.subject2Names());
        this.subject2.addDescriptions(this.subject2Descriptions());
    }

    private Collection<String> subject1Names() {
        HashBag result = new HashBag();
        result.add("foo");
        result.add("bar");
        return result;
    }

    private Collection<String> subject1Descriptions() {
        HashBag result = new HashBag();
        result.add("this.subject1 description1");
        result.add("this.subject1 description2");
        return result;
    }

    private Collection<String> subject2Names() {
        HashBag result = new HashBag();
        result.add("baz");
        result.add("bam");
        return result;
    }

    private Collection<String> subject2Descriptions() {
        HashBag result = new HashBag();
        result.add("this.subject2 description1");
        result.add("this.subject2 description2");
        return result;
    }

    private LocalCollectionAspectAdapter buildAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
        return new LocalCollectionAspectAdapter(subjectHolder);
    }

    private CollectionChangeListener buildValueChangeListener1() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent e) {
                CollectionAspectAdapterTests.this.value1Changed((CollectionEvent)e, CollectionAspectAdapterTests.ADD);
            }

            public void itemsRemoved(CollectionRemoveEvent e) {
                CollectionAspectAdapterTests.this.value1Changed((CollectionEvent)e, CollectionAspectAdapterTests.REMOVE);
            }

            public void collectionCleared(CollectionClearEvent e) {
                CollectionAspectAdapterTests.this.value1Changed((CollectionEvent)e, CollectionAspectAdapterTests.CLEAR);
            }

            public void collectionChanged(CollectionChangeEvent e) {
                CollectionAspectAdapterTests.this.value1Changed((CollectionEvent)e, CollectionAspectAdapterTests.CHANGE);
            }
        };
    }

    void value1Changed(CollectionEvent e, String eventType) {
        this.event1 = e;
        this.event1Type = eventType;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSubjectHolder() {
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        CollectionAspectAdapterTests.assertNull((Object)this.event1);
        this.subjectHolder1.setValue((Object)this.subject2);
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)CHANGE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals(this.subject2Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        this.event1 = null;
        this.event1Type = null;
        this.subjectHolder1.setValue(null);
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)CHANGE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertFalse((boolean)this.aa1.iterator().hasNext());
        this.event1 = null;
        this.event1Type = null;
        this.subjectHolder1.setValue((Object)this.subject1);
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)CHANGE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
    }

    public void testAdd() {
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        CollectionAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addName("jam");
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)ADD);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals((Object)"jam", ((CollectionAddEvent)this.event1).getItems().iterator().next());
        Collection<String> namesPlus = this.subject1Names();
        namesPlus.add("jam");
        CollectionAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        this.event1 = null;
        this.event1Type = null;
        this.aa1.addAll(Collections.singleton("jaz"));
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)ADD);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals((Object)"jaz", ((CollectionAddEvent)this.event1).getItems().iterator().next());
        namesPlus.add("jaz");
        CollectionAspectAdapterTests.assertEquals(namesPlus, (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
    }

    public void testRemove() {
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        CollectionAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.removeName("foo");
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)REMOVE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals((Object)"foo", ((CollectionRemoveEvent)this.event1).getItems().iterator().next());
        Collection<String> namesMinus = this.subject1Names();
        namesMinus.remove("foo");
        CollectionAspectAdapterTests.assertEquals(namesMinus, (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        this.event1 = null;
        this.event1Type = null;
        this.aa1.removeAll(Collections.singleton("bar"));
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)REMOVE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        CollectionAspectAdapterTests.assertEquals((Object)"bar", ((CollectionRemoveEvent)this.event1).getItems().iterator().next());
        namesMinus.remove("bar");
        CollectionAspectAdapterTests.assertEquals(namesMinus, (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
    }

    public void testCollectionChange() {
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
        CollectionAspectAdapterTests.assertNull((Object)this.event1);
        this.subject1.addTwoNames("jam", "jaz");
        CollectionAspectAdapterTests.assertNotNull((Object)this.event1);
        CollectionAspectAdapterTests.assertEquals((String)this.event1Type, (String)CHANGE);
        CollectionAspectAdapterTests.assertEquals((Object)((Object)this.aa1), (Object)this.event1.getSource());
        CollectionAspectAdapterTests.assertEquals((String)"values", (String)this.event1.getCollectionName());
        Collection<String> namesPlus2 = this.subject1Names();
        namesPlus2.add("jam");
        namesPlus2.add("jaz");
        CollectionAspectAdapterTests.assertEquals(namesPlus2, (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
    }

    public void testIterator() {
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag(this.subject1.names()));
        CollectionAspectAdapterTests.assertEquals(this.subject1Names(), (Object)CollectionTools.bag((Iterator)this.aa1.iterator()));
    }

    public void testSize() {
        CollectionAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size(this.subject1.names()));
        CollectionAspectAdapterTests.assertEquals((int)this.subject1Names().size(), (int)CollectionTools.size((Iterator)this.aa1.iterator()));
    }

    public void testHasListeners() {
        CollectionAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyCollectionChangeListeners("values"));
        CollectionAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyCollectionChangeListeners("names"));
        this.aa1.removeCollectionChangeListener("values", this.listener1);
        CollectionAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyCollectionChangeListeners("names"));
        CollectionAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyCollectionChangeListeners("values"));
        ChangeAdapter listener2 = new ChangeAdapter();
        this.aa1.addChangeListener((ChangeListener)listener2);
        CollectionAspectAdapterTests.assertTrue((boolean)this.aa1.hasAnyCollectionChangeListeners("values"));
        CollectionAspectAdapterTests.assertTrue((boolean)this.subject1.hasAnyCollectionChangeListeners("names"));
        this.aa1.removeChangeListener((ChangeListener)listener2);
        CollectionAspectAdapterTests.assertFalse((boolean)this.subject1.hasAnyCollectionChangeListeners("names"));
        CollectionAspectAdapterTests.assertFalse((boolean)this.aa1.hasAnyCollectionChangeListeners("values"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocalCollectionAspectAdapter
    extends CollectionAspectAdapter<TestSubject, String> {
        LocalCollectionAspectAdapter(PropertyValueModel<TestSubject> subjectHolder) {
            super(subjectHolder, new String[]{"names"});
        }

        protected Iterator<String> iterator_() {
            if (this.collectionNames[0] == "names") {
                return ((TestSubject)((Object)this.subject)).names();
            }
            if (this.collectionNames[0] == "descriptions") {
                return ((TestSubject)((Object)this.subject)).descriptions();
            }
            throw new IllegalStateException("invalid aspect name: " + this.collectionNames[0]);
        }

        public void add(String item) {
            if (this.collectionNames[0] == "names") {
                ((TestSubject)((Object)this.subject)).addName(item);
            } else if (this.collectionNames[0] == "descriptions") {
                ((TestSubject)((Object)this.subject)).addDescription(item);
            } else {
                throw new IllegalStateException("invalid aspect name: " + this.collectionNames[0]);
            }
        }

        public void addAll(Collection<String> items) {
            Iterator<String> stream = items.iterator();
            while (stream.hasNext()) {
                this.add(stream.next());
            }
        }

        public void remove(Object item) {
            if (this.collectionNames[0] == "names") {
                ((TestSubject)((Object)this.subject)).removeName((String)item);
            } else if (this.collectionNames[0] == "descriptions") {
                ((TestSubject)((Object)this.subject)).removeDescription((String)item);
            } else {
                throw new IllegalStateException("invalid aspect name: " + this.collectionNames[0]);
            }
        }

        public void removeAll(Collection<String> items) {
            Iterator<String> stream = items.iterator();
            while (stream.hasNext()) {
                this.remove(stream.next());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestSubject
    extends AbstractModel {
        private Collection<String> names = new HashBag();
        public static final String NAMES_COLLECTION = "names";
        private Collection<String> descriptions = new HashBag();
        public static final String DESCRIPTIONS_COLLECTION = "descriptions";

        public Iterator<String> names() {
            return new ReadOnlyIterator(this.names);
        }

        public void addName(String name) {
            if (this.names.add(name)) {
                this.fireItemAdded(NAMES_COLLECTION, name);
            }
        }

        public void addNames(Iterator<String> newNames) {
            while (newNames.hasNext()) {
                this.addName(newNames.next());
            }
        }

        public void addNames(Collection<String> newNames) {
            this.addNames(newNames.iterator());
        }

        public void addTwoNames(String name1, String name2) {
            if (this.names.add(name1) | this.names.add(name2)) {
                this.fireCollectionChanged(NAMES_COLLECTION, this.names);
            }
        }

        public void removeName(String name) {
            if (this.names.remove(name)) {
                this.fireItemRemoved(NAMES_COLLECTION, name);
            }
        }

        public Iterator<String> descriptions() {
            return new ReadOnlyIterator(this.descriptions);
        }

        public void addDescription(String description) {
            if (this.descriptions.add(description)) {
                this.fireItemAdded(DESCRIPTIONS_COLLECTION, description);
            }
        }

        public void addDescriptions(Iterator<String> newDescriptions) {
            while (newDescriptions.hasNext()) {
                this.addDescription(newDescriptions.next());
            }
        }

        public void addDescriptions(Collection<String> newDescriptions) {
            this.addDescriptions(newDescriptions.iterator());
        }

        public void removeDescription(String description) {
            if (this.descriptions.remove(description)) {
                this.fireItemRemoved(DESCRIPTIONS_COLLECTION, description);
            }
        }
    }
}

