/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;
import org.eclipse.jpt.utility.tests.internal.model.value.CoordinatedBag;
import org.eclipse.jpt.utility.tests.internal.model.value.CoordinatedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedListValueModelAdapterTests
extends TestCase {
    private SortedListValueModelAdapter<String> adapter;
    private SimpleCollectionValueModel<String> wrappedCollectionHolder;
    private Collection<String> wrappedCollection;

    public SortedListValueModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.wrappedCollection = new HashBag();
        this.wrappedCollectionHolder = new SimpleCollectionValueModel(this.wrappedCollection);
        this.adapter = new SortedListValueModelAdapter(this.wrappedCollectionHolder);
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private void verifyList(Collection<String> expected, ListValueModel<String> actual) {
        this.verifyList(expected, actual, null);
    }

    private void verifyList(Collection<String> expected, ListValueModel<String> actual, Comparator<String> comparator) {
        TreeSet<String> sortedSet = new TreeSet<String>(comparator);
        sortedSet.addAll(expected);
        ArrayList<String> expectedList = new ArrayList<String>(sortedSet);
        ArrayList actualList = CollectionTools.list((Iterator)actual.iterator());
        SortedListValueModelAdapterTests.assertEquals(expectedList, (Object)actualList);
    }

    public void testAdd() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
            }

            public void itemsReplaced(ListReplaceEvent e) {
            }
        });
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        SortedListValueModelAdapterTests.assertEquals((int)3, (int)this.adapter.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
    }

    public void testAddItem() {
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.adapter);
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>((CollectionValueModel<String>)this.wrappedCollectionHolder);
        this.wrappedCollectionHolder.add((Object)"foo");
        SortedListValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection.contains("foo"));
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        SortedListValueModelAdapterTests.assertEquals((int)6, (int)this.wrappedCollection.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.collection(synchList.iterator()));
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
    }

    public void testRemoveItem() {
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.adapter);
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>((CollectionValueModel<String>)this.wrappedCollectionHolder);
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        this.wrappedCollectionHolder.remove((Object)"jaz");
        SortedListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("jaz"));
        this.wrappedCollectionHolder.remove((Object)"foo");
        SortedListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("foo"));
        SortedListValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedCollection.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.collection(synchList.iterator()));
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
    }

    public void testListSynch() {
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
            }

            public void itemsRemoved(ListRemoveEvent e) {
            }

            public void itemsReplaced(ListReplaceEvent e) {
            }
        });
        this.wrappedCollectionHolder.add((Object)"foo");
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        this.wrappedCollectionHolder.remove((Object)"jaz");
        SortedListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("jaz"));
        this.wrappedCollectionHolder.remove((Object)"foo");
        SortedListValueModelAdapterTests.assertFalse((boolean)this.wrappedCollection.contains("foo"));
        SortedListValueModelAdapterTests.assertEquals((int)4, (int)this.wrappedCollection.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
    }

    public void testSetComparator() {
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.adapter);
        CoordinatedBag<String> synchCollection = new CoordinatedBag<String>((CollectionValueModel<String>)this.wrappedCollectionHolder);
        this.wrappedCollectionHolder.add((Object)"foo");
        SortedListValueModelAdapterTests.assertTrue((boolean)this.wrappedCollection.contains("foo"));
        this.wrappedCollectionHolder.add((Object)"bar");
        this.wrappedCollectionHolder.add((Object)"baz");
        this.wrappedCollectionHolder.add((Object)"joo");
        this.wrappedCollectionHolder.add((Object)"jar");
        this.wrappedCollectionHolder.add((Object)"jaz");
        SortedListValueModelAdapterTests.assertEquals((int)6, (int)this.wrappedCollection.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.collection(synchList.iterator()));
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
        this.adapter.setComparator((Comparator)new ReverseComparator());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter, (Comparator<String>)new ReverseComparator());
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, (Object)CollectionTools.collection(synchList.iterator()));
        SortedListValueModelAdapterTests.assertEquals(this.wrappedCollection, synchCollection);
    }

    public void testHasListeners() {
        SortedListValueModelAdapterTests.assertFalse((boolean)this.adapter.hasAnyListChangeListeners("list values"));
        CoordinatedList<String> synchList = new CoordinatedList<String>((ListValueModel<String>)this.adapter);
        SortedListValueModelAdapterTests.assertTrue((boolean)this.adapter.hasAnyListChangeListeners("list values"));
        this.adapter.removeListChangeListener("list values", synchList);
        SortedListValueModelAdapterTests.assertFalse((boolean)this.adapter.hasAnyListChangeListeners("list values"));
        ChangeAdapter cl = new ChangeAdapter();
        this.adapter.addChangeListener((ChangeListener)cl);
        SortedListValueModelAdapterTests.assertTrue((boolean)this.adapter.hasAnyListChangeListeners("list values"));
        this.adapter.removeChangeListener((ChangeListener)cl);
        SortedListValueModelAdapterTests.assertFalse((boolean)this.adapter.hasAnyListChangeListeners("list values"));
    }

    public void testCollectionChange() {
        this.wrappedCollectionHolder.add((Object)"fred");
        this.adapter.addListChangeListener("list values", (ListChangeListener)new TestListChangeListener(){

            public void listChanged(ListChangeEvent e) {
            }
        });
        this.wrappedCollectionHolder.setValues(Arrays.asList("foo", "bar", "baz"));
        SortedListValueModelAdapterTests.assertEquals((int)3, (int)this.adapter.size());
        this.verifyList(this.wrappedCollection, (ListValueModel<String>)this.adapter);
    }

    class TestListChangeListener
    implements ListChangeListener {
        TestListChangeListener() {
        }

        public void itemsAdded(ListAddEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsRemoved(ListRemoveEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsReplaced(ListReplaceEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void itemsMoved(ListMoveEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void listCleared(ListClearEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }

        public void listChanged(ListChangeEvent e) {
            SortedListValueModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

