/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value.swing;

import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.CheckBoxModelAdapter;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class CheckBoxModelAdapterTests
extends TestCase {
    private WritablePropertyValueModel<Boolean> booleanHolder;
    private ButtonModel buttonModelAdapter;
    boolean eventFired;

    public CheckBoxModelAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.booleanHolder = new SimplePropertyValueModel((Object)Boolean.TRUE);
        this.buttonModelAdapter = new CheckBoxModelAdapter(this.booleanHolder){

            protected PropertyChangeListener buildBooleanChangeListener() {
                return this.buildBooleanChangeListener_();
            }
        };
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testSetSelected() throws Exception {
        this.eventFired = false;
        this.buttonModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CheckBoxModelAdapterTests.this.eventFired = true;
            }
        });
        this.buttonModelAdapter.setSelected(false);
        CheckBoxModelAdapterTests.assertTrue((boolean)this.eventFired);
        CheckBoxModelAdapterTests.assertEquals((Object)Boolean.FALSE, (Object)this.booleanHolder.getValue());
    }

    public void testSetValue() throws Exception {
        this.eventFired = false;
        this.buttonModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CheckBoxModelAdapterTests.this.eventFired = true;
            }
        });
        CheckBoxModelAdapterTests.assertTrue((boolean)this.buttonModelAdapter.isSelected());
        this.booleanHolder.setValue((Object)Boolean.FALSE);
        CheckBoxModelAdapterTests.assertTrue((boolean)this.eventFired);
        CheckBoxModelAdapterTests.assertFalse((boolean)this.buttonModelAdapter.isSelected());
    }

    public void testDefaultValue() throws Exception {
        this.eventFired = false;
        this.buttonModelAdapter.addChangeListener(new TestChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CheckBoxModelAdapterTests.this.eventFired = true;
            }
        });
        CheckBoxModelAdapterTests.assertTrue((boolean)this.buttonModelAdapter.isSelected());
        this.booleanHolder.setValue(null);
        CheckBoxModelAdapterTests.assertTrue((boolean)this.eventFired);
        CheckBoxModelAdapterTests.assertFalse((boolean)this.buttonModelAdapter.isSelected());
        this.eventFired = false;
        this.booleanHolder.setValue((Object)Boolean.FALSE);
        CheckBoxModelAdapterTests.assertFalse((boolean)this.eventFired);
        CheckBoxModelAdapterTests.assertFalse((boolean)this.buttonModelAdapter.isSelected());
    }

    public void testHasListeners() throws Exception {
        SimplePropertyValueModel localBooleanHolder = (SimplePropertyValueModel)this.booleanHolder;
        CheckBoxModelAdapterTests.assertFalse((boolean)localBooleanHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.buttonModelAdapter);
        TestChangeListener listener = new TestChangeListener();
        this.buttonModelAdapter.addChangeListener(listener);
        CheckBoxModelAdapterTests.assertTrue((boolean)localBooleanHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasListeners(this.buttonModelAdapter);
        this.buttonModelAdapter.removeChangeListener(listener);
        CheckBoxModelAdapterTests.assertFalse((boolean)localBooleanHolder.hasAnyPropertyChangeListeners("value"));
        this.verifyHasNoListeners(this.buttonModelAdapter);
    }

    private void verifyHasNoListeners(Object model) throws Exception {
        EventListenerList listenerList = (EventListenerList)ReflectionTools.getFieldValue((Object)model, (String)"listenerList");
        CheckBoxModelAdapterTests.assertEquals((int)0, (int)listenerList.getListenerList().length);
    }

    private void verifyHasListeners(Object model) throws Exception {
        EventListenerList listenerList = (EventListenerList)ReflectionTools.getFieldValue((Object)model, (String)"listenerList");
        CheckBoxModelAdapterTests.assertFalse((listenerList.getListenerList().length == 0 ? 1 : 0) != 0);
    }

    private class TestChangeListener
    implements ChangeListener {
        TestChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            CheckBoxModelAdapterTests.fail((String)"unexpected event");
        }
    }
}

