/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;

public class FlowAnalysisTest
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public FlowAnalysisTest(String name) {
        super(name);
    }

    public static Test suite() {
        return FlowAnalysisTest.buildAllCompliancesTestSuite(FlowAnalysisTest.testClass());
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic String foo(int i) {\n\t\tif (true) {\n\t\t\treturn null;\n\t\t}\n\t\tif (i > 0) {\n\t\t\treturn null;\n\t\t}\n\t}\t\n}\n"}, "----------\n1. ERROR in X.java (at line 2)\n\tpublic String foo(int i) {\n\t              ^^^^^^^^^^\nThis method must return a result of type String\n----------\n");
    }

    public void test002() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        while ((char) (c1 = 0) == 1) {}\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test003() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        while ((char) (c1 = 0) == 1) ;\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test004() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        for (;(char) (c1 = 0) == 1;) ;\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test005() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.parameterAssignment", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test() {\n        int c1, c2;\n        do ; while ((char) (c1 = 0) == 1);\n        if (c1 == 0) {} // silent\n        if (c2 == 0) {} // complain\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n", null, true, options);
    }

    public void test006() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // complain: possible fall-through\n            break;\n        case 2:\n            System.out.println(3); // silent because of break\n            return;\n        case 3:                            // silent because of return\n        case 4:                            // silent because grouped cases\n        default:\n            System.out.println(\"default\"); //$NON-NLS-1$\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test007() {
        if ("1.5".equals(this.complianceLevel)) {
            Map options = this.getCompilerOptions();
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "warning");
            this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings(\"fallthrough\")\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because of SuppressWarnings\n        }\n    }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
        }
    }

    public void test008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            if (true) {\n              return;\n            }\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 9)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test009() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            if (b) {\n              return;\n            }\n            else {\n              return;\n            }\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test010() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            System.exit(0);\n        case 1:\n            System.out.println(1);\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test011() {
        if ("1.5".equals(this.complianceLevel)) {
            Map options = this.getCompilerOptions();
            options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "warning");
            this.runNegativeTest(new String[]{"X.java", "public class X {\n    @SuppressWarnings(\"all\")\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because of SuppressWarnings\n        }\n    }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 11)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n", null, true, options);
        }
    }

    public void _test012() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void _test013() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n        default:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test014() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        default:\n            System.out.println(1); // complain: possible fall-through\n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tdefault:\n\t^^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test015() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test016() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n            // on purpose fall-through\n            /* other comment */\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void _test017() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n// on purpose fall-through\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void _test018() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runConformTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0);\n            //\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "", null, true, null, options, null);
    }

    public void test019() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p, boolean b) {\n        switch (p) {\n        case 0:\n            if (b) {\n              break;\n            }\n        case 1:\n            System.out.println(1); // silent because of comment alone on its line above \n        }\n    }\n}"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test020() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n    public void test(int p) {\n        switch (p) {\n        case 0:\n            System.out.println(0); // silent because first case\n        case 1:\n            System.out.println(1); // silent because default level is ignore\n        }\n    }\n\tZork z;\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tZork z;\n\t^^^^\nZork cannot be resolved to a type\n----------\n");
    }

    public void test021() {
        if (ProblemReporter.getProblemCategory((int)0, (int)0x200000C2) != 90) {
            FlowAnalysisTest.fail((String)"bad category for fall-through case problem");
        }
    }

    public void test022() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tif (true)\n            ;\n        else\n            ;\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 4)\n\t;\n\t^\nEmpty control-flow statement\n----------\n2. ERROR in X.java (at line 6)\n\t;\n\t^\nEmpty control-flow statement\n----------\n", null, true, options);
    }

    public void test023() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tfinal X x;\n\t\twhile (true) {\n\t\t\tif (true) {\n\t\t\t\tbreak;\n\t\t\t}\n\t\t\tx = new X();\n\t\t}\n\t\tx.foo();\n\t}\n\tpublic void foo() {\n\t}\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tx.foo();\n\t^\nThe local variable x may not have been initialized\n----------\n");
    }

    public void test024() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  public void foo(boolean b) {\n    final Object l;\n    do {\n      if (b) {\n        l = new Object();\n        break;\n      }\n    } while (false);\n    l.toString();\n  }\n}"}, "----------\n1. ERROR in X.java (at line 10)\n\tl.toString();\n\t^\nThe local variable l may not have been initialized\n----------\n");
    }

    public void test025() {
        this.runConformTest(new String[]{"X.java", "public class X {\n\tpublic static void main(String[] args) {\n\t\tSystem.out.print(\"[starting]\");\n\t\tX l = new X();\n\t\tl.testLoop();\n\t\tSystem.out.println(\"[finished]\");\n\t}\n\n\tpublic void testLoop() {\n\t\tint loops = 0;\n\n\t\tdo {\n\t\t\tSystem.out.print(\"[Loop \" + loops + \"]\");\n\t\t\tif (loops > 2) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tif (loops < 4) {\n\t\t\t\t++loops;\n\t\t\t\tcontinue; \n\t\t\t}\n\t\t} while (false);\n\t}\n\n}\n"}, "[starting][Loop 0][finished]");
    }

    public void test026() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo(Object o1) {\n    int a00, a01, a02, a03, a04, a05, a06, a07, a08, a09;\n    int a10, a11, a12, a13, a14, a15, a16, a17, a18, a19;\n    int a20, a21, a22, a23, a24, a25, a26, a27, a28, a29;\n    int a30, a31, a32, a33, a34, a35, a36, a37, a38, a39;\n    int a40, a41, a42, a43, a44, a45, a46, a47, a48, a49;\n    int a50, a51, a52, a53, a54, a55, a56, a57, a58, a59;\n    int a60, a61, a62, a63, a64, a65, a66, a67, a68, a69;\n    String s;\n    Object o2 = o1;\n    if (o2 == null) {\n      s = \"\";\n    }\n    System.out.println(s);\n  }\n}"}, "----------\n1. ERROR in X.java (at line 15)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test027() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  public static void main(String args[]) {\n    String s;\n    if (args.length == 0) {\n      s = \"s\";\n    } else {\n      s = args[0];\n    }\n    System.out.println(s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\" +\n                       s + \"-\" + s + \"-\" + s + \"-\");\n  }\n}"}, "s-s-s-s-s-s-s-s-s-s-s-s-s-s-s-");
    }

    public void test028() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   {\n      if (true) throw new NullPointerException();\n   }\n}\n"}, "");
    }

    public void test029() {
        this.runConformTest(new String[]{"X.java", "public class X {\n   {\n      if (true) throw new NullPointerException();\n   }\n   X() {\n      System.out.println();\n   }\n}\n"}, "");
    }

    public void test030() {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tY(Object o) {\n\t\tSystem.out.print(o);\n\t}\n}\n\npublic class X extends Y {\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(new Object() {\n\t\t\tpublic String toString() {\n\t\t\t\treturn \"SUCCESS:\";\n\t\t\t}\n\t\t});\n\t\tSystem.out.println();\n\t}\n\tpublic static void main(String[] args) {\n\t\ttry {\n\t\t\tnew X();\n\t\t} catch(NullPointerException e) {\n\t\t\tSystem.out.println(\"caught:NPE\");\n\t\t}\n\t}\n}\n"}, "SUCCESS:caught:NPE");
    }

    public void test031() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tY(Object o) {\n\t}\n}\n\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(new Object() {});\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 13)\n\tX() {\n\t^^^\nThe blank final field blank may not have been initialized\n----------\n");
    }

    public void test032() {
        this.runNegativeTest(new String[]{"X.java", "class Y {\n\tY(int i) {\n\t}\n}\n\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\n\tX() {\n\t\tsuper(blank = 0);\n\t}\n}\n"}, "----------\n1. ERROR in X.java (at line 14)\n\tsuper(blank = 0);\n\t      ^^^^^\nCannot refer to an instance field blank while explicitly invoking a constructor\n----------\n");
    }

    public void test033() {
        this.runConformTest(new String[]{"X.java", "class Y {\n\tY(int i) {\n\t}\n}\npublic class X extends Y {\n\tfinal int blank;\n\t{\n\t\tif (true)\n\t\t\tthrow new NullPointerException();\n\t}\n\tX() {\n\t\tsuper(0);\n\t\tblank = 0;\n\t}\n}\n"}, "");
    }

    public void test034() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo1() {\n    switch (1) {\n    case 0:\n      final int i = 1;\n    case i: // should complain: i not initialized\n      System.out.println(i); // should complain: i not initialized\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tcase i: // should complain: i not initialized\n\t     ^\nThe local variable i may not have been initialized\n----------\n2. ERROR in X.java (at line 7)\n\tSystem.out.println(i); // should complain: i not initialized\n\t                   ^\nThe local variable i may not have been initialized\n----------\n");
    }

    public void test035() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo2() {\n    switch (1) {\n    case 0:\n      int j = 0;\n    case 1:\n      System.out.println(j); // should complain: j not initialized\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\tSystem.out.println(j); // should complain: j not initialized\n\t                   ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test036() {
        String src = "public class X {\n  void foo3() {\n    switch (1) {\n    case 0:\n      class Local {\n      }\n      ;\n    case 1:\n      new Local();\n    }\n  }\n}";
        if (this.complianceLevel.compareTo("1.3") <= 0) {
            this.runConformTest(new String[]{"X.java", src}, "");
        } else {
            this.runNegativeTest(new String[]{"X.java", src}, "----------\n1. ERROR in X.java (at line 9)\n\tnew Local();\n\t    ^^^^^\nLocal cannot be resolved to a type\n----------\n");
        }
    }

    public void test037() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    if (false) {\n      String s;\n      System.out.println(s);\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test038() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    String s;\n    if (false) {\n      System.out.println(s);\n    }\n  }\n}"}, "");
    }

    public void test039() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    if (false) {\n      String s;\n      if (System.out != null) {\n        System.out.println(s);\n      }\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 6)\n\tSystem.out.println(s);\n\t                   ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test040() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s = \"\";\n    if (false) {\n      s = \"\";\n    }\n  }\n}"}, "----------\n1. ERROR in X.java (at line 5)\n\ts = \"\";\n\t^\nThe final local variable s cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void test041() {
        this.runConformTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s;\n    s = \"\";\n    if (false) {\n      s = \"\";\n    }\n  }\n}"}, "");
    }

    public void test042() {
        this.runNegativeTest(new String[]{"X.java", "public class X {\n  void foo() {\n    final String s;\n    if (false) {\n      s = \"\";\n    }\n    s = \"\";\n  }\n}"}, "----------\n1. ERROR in X.java (at line 7)\n\ts = \"\";\n\t^\nThe final local variable s may already have been assigned\n----------\n");
    }

    public void test043() {
        this.runConformTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    for (int i = 0; i < 3; i++) {\n      System.out.print(i);\n      switch (i) {\n        case 1:\n          final int j;\n          j = 1;\n          System.out.println(j);\n          break;\n        case 2:\n          j = 2;\n          System.out.println(j);\n      }\n    }\n  }\n}\n"}, "011\n22");
    }

    public void test044() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    for (int i = 0; i < 3; i++) {\n      System.out.print(i);\n      switch (i) {\n        case 1:\n          final int j = 1;\n          System.out.println(j);\n          break;\n        case 2:\n          j = 2;\n          System.out.println(j);\n      }\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 11)\n\tj = 2;\n\t^\nThe final local variable j cannot be assigned. It must be blank and not using a compound assignment\n----------\n");
    }

    public void test045() {
        this.runNegativeTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String[] args) {\n    switch (args.length) {\n      case 1:\n        final int j = 1;\n      case 2:\n        switch (5) {\n          case j:\n        }\n    }\n  }\n}\n"}, "----------\n1. ERROR in X.java (at line 8)\n\tcase j:\n\t     ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test046() {
        this.runConformTest(new String[]{"X.java", "public abstract class X {\n  public static void main(String args[]) {\n    for (final int i; 0 < (i = 1); i = i + 1) {\n      System.out.println(i);\n      break;\n    }\n  }\n}\n"}, "1");
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.FlowAnalysisTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

