/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.Map;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class SerialVersionUIDTests
extends AbstractRegressionTest {
    static /* synthetic */ Class class$0;

    public SerialVersionUIDTests(String name) {
        super(name);
    }

    public static Test suite() {
        return SerialVersionUIDTests.buildAllCompliancesTestSuite(SerialVersionUIDTests.testClass());
    }

    public static Class testClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.compiler.regression.SerialVersionUIDTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected Map getCompilerOptions() {
        Map options = super.getCompilerOptions();
        return options;
    }

    public void test001() {
        this.runConformTest(new String[]{"X.java", "import java.io.Serializable;\n\npublic class X implements Serializable {\n\tprivate void readObject(java.io.ObjectInputStream stream) throws java.io.IOException {}\n\tprivate void writeObject(java.io.ObjectOutputStream stream) throws java.io.IOException {}\n}"}, "");
    }

    public void test002() {
        this.runConformTest(new String[]{"X.java", "public class X implements java.io.Externalizable {\n\tpublic void writeExternal(java.io.ObjectOutput out) throws java.io.IOException {}\n\tpublic void readExternal(java.io.ObjectInput in) throws java.io.IOException, ClassNotFoundException {}\n}"}, "");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tprivate void writeObject(java.io.ObjectOutputStream stream) throws java.io.IOException {}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tprivate void readObject(java.io.ObjectInputStream stream) throws java.io.IOException {}\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n}"}, "----------\n1. ERROR in X.java (at line 1)\n\tpublic class X implements java.io.Serializable {\n\t             ^\nThe serializable class X does not declare a static final serialVersionUID field of type long\n----------\n");
    }

    public void test006() {
        this.runConformTest(new String[]{"X.java", "public class X implements java.io.Serializable {\n\tObject writeReplace() throws java.io.ObjectStreamException { return null;}\n}"}, "");
    }
}

