/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaPersistentTypeTests
extends ContextModelTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityAnnotatedFieldAndMethod() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubType() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithFieldAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeWithMethodAnnotation() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubTypeNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", new AnnotationTestCase.DefaultAnnotationWriter(){

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }
        });
    }

    private ICompilationUnit createTestSubTypePersistentExtendsNonPersistent() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild2.java", "AnnotationTestTypeChild2", new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestTypeChild ");
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendGetIdMethodAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public GenericJavaPersistentTypeTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestType", (String)this.getJavaPersistentType().getName());
    }

    public void testGetAccessNothingAnnotated() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessField() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessProperty() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessFieldAndMethodAnnotated() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)this.getJavaPersistentType().getAccess());
    }

    public void testAccessInheritance() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance3() throws Exception {
        this.createTestEntityAnnotatedField();
        this.createTestSubTypeWithMethodAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritance4() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessInheritancePersistenceUnitDefaultAccess() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        classRefs.next();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType javaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.AnnotationTestTypeChild", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlNoAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        entityPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        entityPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessNoAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntity();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.FIELD);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityPropertyAccessAndFieldAnnotations() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        ormPersistentType.setSpecifiedAccess(AccessType.PROPERTY);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityFieldAccessAndPropertyAnnotations() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = ormPersistentType.getJavaPersistentType();
        ormPersistentType.setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlPersistenceUnitDefaultsAccessFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessXmlEntityMappingsAccessWithInheritance() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childEntityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        this.createTestEntityAnnotatedMethod();
        this.createTestSubType();
        JavaPersistentType childJavaPersistentType = childEntityPersistentType.getJavaPersistentType();
        this.getEntityMappings().setSpecifiedAccess(AccessType.FIELD);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)entityPersistentType.getJavaPersistentType().getAccess());
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)childJavaPersistentType.getAccess());
    }

    public void testAccessXmlMetadataCompleteFieldAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedField();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitDefaults().setAccess(AccessType.PROPERTY);
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.FIELD, (Object)javaPersistentType.getAccess());
    }

    public void testAccessNoXmlAccessXmlMetdataCompletePropertyAnnotations() throws Exception {
        OrmPersistentType entityPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.createTestEntityAnnotatedMethod();
        JavaPersistentType javaPersistentType = entityPersistentType.getJavaPersistentType();
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        GenericJavaPersistentTypeTests.assertEquals((Object)AccessType.PROPERTY, (Object)javaPersistentType.getAccess());
    }

    public void testSuperPersistentType() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getSuperPersistentType());
        GenericJavaPersistentTypeTests.assertNull((Object)rootJavaPersistentType.getSuperPersistentType());
    }

    public void testSuperPersistentType2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeWithFieldAnnotation();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType javaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertNotNull((Object)javaPersistentType.getSuperPersistentType());
    }

    public void testSuperPersistentType3() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        ClassRef classRef = (ClassRef)classRefs.next();
        JavaPersistentType rootJavaPersistentType = classRef.getJavaPersistentType();
        classRef = (ClassRef)classRefs.next();
        JavaPersistentType childJavaPersistentType = classRef.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, (Object)childJavaPersistentType.getSuperPersistentType());
        GenericJavaPersistentTypeTests.assertNull((Object)rootJavaPersistentType.getSuperPersistentType());
    }

    public void testInheritanceHierarchy() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.inheritanceHierarchy();
        GenericJavaPersistentTypeTests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        GenericJavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testInheritanceHierarchy2() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.createTestSubTypeNonPersistent();
        this.createTestSubTypePersistentExtendsNonPersistent();
        this.addXmlClassRef("test.AnnotationTestTypeChild2");
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaPersistentType childJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        JavaPersistentType rootJavaPersistentType = ((ClassRef)classRefs.next()).getJavaPersistentType();
        Iterator inheritanceHierarchy = childJavaPersistentType.inheritanceHierarchy();
        GenericJavaPersistentTypeTests.assertEquals((Object)childJavaPersistentType, inheritanceHierarchy.next());
        GenericJavaPersistentTypeTests.assertEquals((Object)rootJavaPersistentType, inheritanceHierarchy.next());
    }

    public void testGetMapping() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMapping().getKey());
    }

    public void testGetMappingNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMapping().getKey());
    }

    public void testMappingKey() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testMappingKeyNull() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKey() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey("entity");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.Entity"));
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKey2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey("embeddable");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.Embeddable"));
        GenericJavaPersistentTypeTests.assertEquals((String)"embeddable", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testSetMappingKeyNull() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.Entity"));
        GenericJavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.setPrimaryAnnotation("javax.persistence.Embeddable", EmptyIterable.instance());
        GenericJavaPersistentTypeTests.assertEquals((String)"embeddable", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testGetMappingKeyMappingChangeInResourceModel2() throws Exception {
        this.createTestType();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((String)MappingKeys.NULL_TYPE_MAPPING_KEY, (String)this.getJavaPersistentType().getMappingKey());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        typeResource.setPrimaryAnnotation("javax.persistence.Entity", EmptyIterable.instance());
        GenericJavaPersistentTypeTests.assertEquals((String)"entity", (String)this.getJavaPersistentType().getMappingKey());
    }

    public void testIsMapped() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertTrue((boolean)this.getJavaPersistentType().isMapped());
        this.getJavaPersistentType().setMappingKey(MappingKeys.NULL_TYPE_MAPPING_KEY);
        GenericJavaPersistentTypeTests.assertFalse((boolean)this.getJavaPersistentType().isMapped());
    }

    public void testAttributes() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        GenericJavaPersistentTypeTests.assertEquals((String)"id", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributes2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        GenericJavaPersistentTypeTests.assertEquals((String)"id", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentTypeTests.assertEquals((String)"name", (String)((JavaPersistentAttribute)attributes.next()).getName());
        GenericJavaPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
    }

    public void testAttributesSize() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((int)1, (int)this.getJavaPersistentType().attributesSize());
    }

    public void testAttributesSize2() throws Exception {
        this.createTestEntityAnnotatedFieldAndMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        GenericJavaPersistentTypeTests.assertEquals((int)2, (int)this.getJavaPersistentType().attributesSize());
    }

    public void testAttributeNamed() throws Exception {
        this.createTestEntityAnnotatedMethod();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("id");
        GenericJavaPersistentTypeTests.assertEquals((String)"id", (String)attribute.getName());
        GenericJavaPersistentTypeTests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("name"));
        GenericJavaPersistentTypeTests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("foo"));
    }

    public void testAttributeNamed2() throws Exception {
        this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaPersistentAttribute attribute = this.getJavaPersistentType().getAttributeNamed("name");
        GenericJavaPersistentTypeTests.assertEquals((String)"name", (String)attribute.getName());
        GenericJavaPersistentTypeTests.assertNull((Object)this.getJavaPersistentType().getAttributeNamed("foo"));
    }

    public void testRenameAttribute() throws Exception {
        ICompilationUnit testType = this.createTestEntityAnnotatedField();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute idAttribute = (JavaPersistentAttribute)attributes.next();
        JavaPersistentAttribute nameAttribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentTypeTests.assertEquals((String)"id", (String)idAttribute.getName());
        GenericJavaPersistentTypeTests.assertEquals((String)"name", (String)nameAttribute.getName());
        IField idField = testType.findPrimaryType().getField("id");
        idField.rename("id2", false, null);
        attributes = this.getJavaPersistentType().attributes();
        JavaPersistentAttribute nameAttribute2 = (JavaPersistentAttribute)attributes.next();
        JavaPersistentAttribute id2Attribute = (JavaPersistentAttribute)attributes.next();
        GenericJavaPersistentTypeTests.assertNotSame((Object)idAttribute, (Object)id2Attribute);
        GenericJavaPersistentTypeTests.assertEquals((String)"id2", (String)id2Attribute.getName());
        GenericJavaPersistentTypeTests.assertEquals((Object)nameAttribute, (Object)nameAttribute2);
        GenericJavaPersistentTypeTests.assertEquals((String)"name", (String)nameAttribute2.getName());
        GenericJavaPersistentTypeTests.assertFalse((boolean)attributes.hasNext());
    }

    public void testSuperPersistentTypeGeneric() throws Exception {
        this.createTestGenericEntity();
        this.createTestGenericMappedSuperclass();
        this.addXmlClassRef("test.Entity1");
        this.addXmlClassRef("test.Entity2");
        JavaPersistentType javaPersistentType = this.getJavaPersistentType();
        GenericJavaPersistentTypeTests.assertEquals((String)"test.Entity1", (String)javaPersistentType.getName());
        GenericJavaPersistentTypeTests.assertNotNull((Object)javaPersistentType.getSuperPersistentType());
        GenericJavaPersistentTypeTests.assertEquals((String)"test.Entity2", (String)javaPersistentType.getSuperPersistentType().getName());
    }

    private void createTestGenericEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Entity1 ");
                sb.append("extends Entity2<Integer> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity1.java", sourceWriter);
    }

    private void createTestGenericMappedSuperclass() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.MappedSuperclass");
                sb.append(";");
                sb.append(CR);
                sb.append("@MappedSuperclass");
                sb.append(CR);
                sb.append("public class Entity2<K> {}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Entity2.java", sourceWriter);
    }
}

