/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.DiscriminatorColumn;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.core.resource.java.DiscriminatorType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JavaDiscriminatorColumnTests
extends ContextModelTestCase {
    private static final String DISCRIMINATOR_COLUMN_NAME = "MY_DISCRIMINATOR_COLUMN";
    private static final String COLUMN_DEFINITION = "MY_COLUMN_DEFINITION";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithDiscriminatorColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.DiscriminatorColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@DiscriminatorColumn(name=\"MY_DISCRIMINATOR_COLUMN\")");
            }
        });
    }

    private void createTestAbstractEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public abstract class ").append("AnnotationTestType").append(" ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestType.java", sourceWriter);
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public JavaDiscriminatorColumnTests(String name) {
        super(name);
    }

    public void testGetSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)DISCRIMINATOR_COLUMN_NAME, (String)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
    }

    public void testGetDefaultNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals(null, (String)this.getJavaEntity().getDiscriminatorColumn().getDefaultName());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.getJavaEntity().getDiscriminatorColumn().getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals(null, (String)this.getJavaEntity().getDiscriminatorColumn().getDefaultName());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.getJavaEntity().getDiscriminatorColumn().getDefaultName());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedName("foo");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.getJavaEntity().getDiscriminatorColumn().getDefaultName());
    }

    public void testGetNameSpecifiedNameNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals(null, (String)this.getJavaEntity().getDiscriminatorColumn().getName());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)this.getJavaEntity().getDiscriminatorColumn().getName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((String)DISCRIMINATOR_COLUMN_NAME, (String)this.getJavaEntity().getDiscriminatorColumn().getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedName("foo");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)discriminatorColumn.getName());
    }

    public void testSetSpecifiedNameNull() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedName());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertNull((Object)discriminatorColumn);
    }

    public void testGetDefaultDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)this.getJavaEntity().getDiscriminatorColumn().getDefaultDiscriminatorType());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)this.getJavaEntity().getDiscriminatorColumn().getDefaultDiscriminatorType());
    }

    public void testGetDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.STRING, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.CHAR);
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
    }

    public void testGetSpecifiedDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        discriminatorColumn.setDiscriminatorType(DiscriminatorType.CHAR);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
    }

    public void testSetSpecifiedDiscriminatorType() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.CHAR);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorType.CHAR, (Object)discriminatorColumn.getDiscriminatorType());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedDiscriminatorType(null);
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
    }

    public void testGetDiscriminatorTypeUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addAnnotation("javax.persistence.DiscriminatorColumn");
        column.setDiscriminatorType(DiscriminatorType.INTEGER);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.INTEGER, (Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.INTEGER, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
        column.setDiscriminatorType(null);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)this.getJavaEntity().getDiscriminatorColumn().getDiscriminatorType());
    }

    public void testGetLength() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((int)0, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaDiscriminatorColumnTests.assertEquals((int)55, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
    }

    public void testGetDefaultLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((int)0, (int)this.getJavaEntity().getDiscriminatorColumn().getDefaultLength());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)this.getJavaEntity().getDiscriminatorColumn().getDefaultLength());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(55));
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)this.getJavaEntity().getDiscriminatorColumn().getDefaultLength());
    }

    public void testGetSpecifiedLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        discriminatorColumn.setLength(Integer.valueOf(66));
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertEquals((Object)66, (Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((int)66, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
        discriminatorColumn.setName(null);
        discriminatorColumn.setLength(null);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
    }

    public void testSetSpecifiedLength() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(100));
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation discriminatorColumn = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((Object)100, (Object)discriminatorColumn.getLength());
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedName(null);
        this.getJavaEntity().getDiscriminatorColumn().setSpecifiedLength(null);
        JavaDiscriminatorColumnTests.assertNull((Object)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn"));
    }

    public void testGetLengthUpdatesFromResourceChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.addAnnotation("javax.persistence.DiscriminatorColumn");
        column.setLength(Integer.valueOf(78));
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertEquals((Object)78, (Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((int)78, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
        column.setLength(null);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((int)0, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)this.getJavaEntity().getDiscriminatorColumn().getLength());
    }

    public void testGetColumnDefinition() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getColumnDefinition());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        column.setColumnDefinition(COLUMN_DEFINITION);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertEquals((String)COLUMN_DEFINITION, (String)this.getJavaEntity().getDiscriminatorColumn().getColumnDefinition());
        column.setColumnDefinition(null);
        this.getJpaProject().synchronizeContextModel();
        JavaDiscriminatorColumnTests.assertNull((Object)this.getJavaEntity().getDiscriminatorColumn().getColumnDefinition());
        typeResource.removeAnnotation("javax.persistence.DiscriminatorColumn");
    }

    public void testSetColumnDefinition() throws Exception {
        this.createTestEntityWithDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaEntity().getDiscriminatorColumn().setColumnDefinition("foo");
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        DiscriminatorColumnAnnotation column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertEquals((String)"foo", (String)column.getColumnDefinition());
        this.getJavaEntity().getDiscriminatorColumn().setColumnDefinition(null);
        column = (DiscriminatorColumnAnnotation)typeResource.getAnnotation("javax.persistence.DiscriminatorColumn");
        JavaDiscriminatorColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testDefaults() throws Exception {
        this.createTestAbstractEntity();
        this.createTestSubType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        ListIterator classRefs = this.getPersistenceUnit().specifiedClassRefs();
        JavaEntity abstractEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaEntity childEntity = (JavaEntity)((ClassRef)classRefs.next()).getJavaPersistentType().getMapping();
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        abstractEntity.getDiscriminatorColumn().setSpecifiedName("DTYPE2");
        abstractEntity.getDiscriminatorColumn().setSpecifiedLength(Integer.valueOf(5));
        abstractEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(org.eclipse.jpt.core.context.DiscriminatorType.CHAR);
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)abstractEntity.getDefaultInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE", (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)31, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)DiscriminatorColumn.DEFAULT_DISCRIMINATOR_TYPE, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE2", (String)abstractEntity.getDiscriminatorColumn().getSpecifiedName());
        JavaDiscriminatorColumnTests.assertEquals((Object)5, (Object)abstractEntity.getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)abstractEntity.getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.SINGLE_TABLE, (Object)childEntity.getDefaultInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals((String)"DTYPE2", (String)childEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)5, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals((Object)org.eclipse.jpt.core.context.DiscriminatorType.CHAR, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals(null, (String)childEntity.getDiscriminatorColumn().getSpecifiedName());
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getSpecifiedLength());
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getSpecifiedDiscriminatorType());
        abstractEntity.getDiscriminatorColumn().setSpecifiedName(null);
        abstractEntity.getDiscriminatorColumn().setSpecifiedLength(null);
        abstractEntity.getDiscriminatorColumn().setSpecifiedDiscriminatorType(null);
        abstractEntity.setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)abstractEntity.getInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals(null, (String)abstractEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)0, (int)abstractEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)abstractEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
        JavaDiscriminatorColumnTests.assertEquals((Object)InheritanceType.TABLE_PER_CLASS, (Object)childEntity.getDefaultInheritanceStrategy());
        JavaDiscriminatorColumnTests.assertEquals(null, (String)childEntity.getDiscriminatorColumn().getDefaultName());
        JavaDiscriminatorColumnTests.assertEquals((int)0, (int)childEntity.getDiscriminatorColumn().getDefaultLength());
        JavaDiscriminatorColumnTests.assertEquals(null, (Object)childEntity.getDiscriminatorColumn().getDefaultDiscriminatorType());
    }
}

