/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmEmbeddedMappingTests
extends ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";

    public OrmEmbeddedMappingTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityEmbeddedMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress2() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        OrmEmbeddedMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        OrmEmbeddedMappingTests.assertNull((Object)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)embeddedResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmEmbeddedMappingTests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(0);
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embedded", "foo");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((String)"foo", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
        OrmEmbeddedMappingTests.assertFalse((boolean)attributeOverrideContainer.virtualAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("address");
        OrmEmbeddedMapping embeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaEmbeddedMapping javaEmbeddedMapping = (JavaEmbeddedMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaEmbeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType2.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        OrmEmbeddedMappingTests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        OrmEmbeddedMappingTests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEmbeddedMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        OrmEmbeddedMappingTests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        OrmEmbeddedMappingTests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        OrmEmbeddedMappingTests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("address").makeSpecified();
        embeddedMapping = (OrmEmbeddedMapping)persistentType.getAttributeNamed("address").getMapping();
        attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getColumn().getName());
        OrmEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getTable());
        OrmEmbeddedMappingTests.assertEquals(null, (String)attributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isInsertable());
        OrmEmbeddedMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUpdatable());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUnique());
        OrmEmbeddedMappingTests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isNullable());
        OrmEmbeddedMappingTests.assertEquals((int)255, (int)attributeOverride.getColumn().getLength());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getPrecision());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getDefaultName());
        OrmEmbeddedMappingTests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
        ((OrmAttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)((OrmAttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)attributeOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator ormAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormAttributeOverride.getName());
        OrmColumn ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"id", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"A_STATE", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)ormColumn.getSpecifiedName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embedded", "address");
        OrmEmbeddedMappingTests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        OrmEmbeddedMappingTests.assertEquals((int)0, (int)ormEmbeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverridesSize());
    }

    public void testEmbeddedMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (AttributeOverride)((EmbeddedIdMapping)ormPersistentAttribute.getMapping()).getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        OrmEmbeddedMappingTests.assertEquals((String)"override", (String)attributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmEmbeddedMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmEmbeddedMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        OrmEmbeddedMappingTests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        OrmEmbeddedMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        OrmEmbeddedMappingTests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress2();
        this.createTestEmbeddableZipCode();
        OrmPersistentType customerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Customer");
        OrmPersistentType addressPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType zipCodePersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        customerPersistentType.getAttributeNamed("address").makeSpecified();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverrides.hasNext());
        addressPersistentType.getAttributeNamed("zipCode").makeSpecified();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        OrmEmbeddedMappingTests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        OrmEmbeddedMappingTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        zipCodePersistentType.getAttributeNamed("plusfour").makeSpecified();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("plusfour");
        OrmEmbeddedMappingTests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        OrmEmbeddedMappingTests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        OrmEmbeddedMappingTests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        OrmEmbeddedMappingTests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        OrmEmbeddedMappingTests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        OrmEmbeddedMappingTests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        OrmEmbeddedMappingTests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        OrmEmbeddedMappingTests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("zipCode.plusfour");
    }
}

