/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.FetchType;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.core.context.orm.OrmManyToManyRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmManyToManyMappingTests
extends ContextModelTestCase {
    public OrmManyToManyMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithManyToManyMapping() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    private String abbr;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)manyToMany.getName());
        manyToMany.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        manyToMany.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"manyToManyMapping", (String)manyToMany.getName());
        ormManyToManyMapping.setName("newName");
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertEquals((String)"newName", (String)manyToMany.getName());
        ormManyToManyMapping.setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getName());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getName());
    }

    public void testUpdateTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        manyToMany.setTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testModifyTargetEntity() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity("newTargetEntity");
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"newTargetEntity", (String)manyToMany.getTargetEntity());
        ormManyToManyMapping.setSpecifiedTargetEntity(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getTargetEntity());
    }

    public void testUpdateSpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(org.eclipse.jpt.core.resource.orm.FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        manyToManyResource.setFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
    }

    public void testModifySpecifiedFetch() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToManyResource = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.EAGER, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(FetchType.LAZY);
        OrmManyToManyMappingTests.assertEquals((Object)org.eclipse.jpt.core.resource.orm.FetchType.LAZY, (Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getSpecifiedFetch());
        ormManyToManyMapping.setSpecifiedFetch(null);
        OrmManyToManyMappingTests.assertNull((Object)manyToManyResource.getFetch());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedFetch());
    }

    public void testUpdateMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormManyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        manyToMany.setMappedBy("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        manyToMany.setMappedBy(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyMappedBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmMappedByJoiningStrategy strategy = ormManyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
        strategy.setMappedByAttribute("newMappedBy");
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertEquals((String)"newMappedBy", (String)manyToMany.getMappedBy());
        strategy.setMappedByAttribute(null);
        OrmManyToManyMappingTests.assertNull((Object)strategy.getMappedByAttribute());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMappedBy());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToManyMapping contextMapping = (OrmManyToManyMapping)contextAttribute.getMapping();
        OrmManyToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToMany resourceMapping = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithManyToManyMapping();
        OrmPersistentType contextType = this.getEntityMappings().getPersistentType("test.AnnotationTestType");
        OrmPersistentAttribute contextAttribute = contextType.getAttributeNamed("id");
        OrmManyToManyMapping contextMapping = (OrmManyToManyMapping)contextAttribute.getMapping();
        OrmManyToManyRelationshipReference relationshipReference = contextMapping.getRelationshipReference();
        XmlEntity resourceEntity = (XmlEntity)contextType.getMapping().getResourceTypeMapping();
        XmlManyToMany resourceMapping = (XmlManyToMany)resourceEntity.getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNotNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        resourceMapping.setJoinTable(null);
        this.getJpaProject().synchronizeContextModel();
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getJoinTable());
        OrmManyToManyMappingTests.assertNull((Object)resourceMapping.getMappedBy());
        OrmManyToManyMappingTests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        OrmManyToManyMappingTests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
    }

    public void testUpdateMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        manyToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNotNull((Object)manyToMany.getMapKey());
        manyToMany.getMapKey().setName("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName("myMapKey");
        manyToMany.setMapKey(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testModifyMapKey() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
        ormManyToManyMapping.setSpecifiedMapKey("myMapKey");
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        ormManyToManyMapping.setSpecifiedMapKey(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidManyToManyMapMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setPkMapKey(true);
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setCustomMapKey(true);
        javaManyToManyMapping.setSpecifiedMapKey("city");
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)ormManyToManyMapping.getSpecifiedMapKey());
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)ormManyToManyMapping.getMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isPkMapKey());
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.isCustomMapKey());
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.isNoMapKey());
    }

    public void testUpdateOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        manyToMany.setOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        manyToMany.setOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testModifyOrderBy() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("newOrderBy");
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertEquals((String)"newOrderBy", (String)manyToMany.getOrderBy());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
        OrmManyToManyMappingTests.assertNull((Object)manyToMany.getOrderBy());
    }

    public void testIsNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
    }

    public void testSetNoOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        ormManyToManyMapping.getOrderable().setNoOrdering(true);
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        OrmManyToManyMappingTests.assertNull((Object)ormManyToManyMapping.getOrderable().getSpecifiedOrderBy());
    }

    public void testIsCustomOrdering() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToManyMapping");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy("foo");
        OrmManyToManyMappingTests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
        ormManyToManyMapping.getOrderable().setSpecifiedOrderBy(null);
        OrmManyToManyMappingTests.assertFalse((boolean)ormManyToManyMapping.getOrderable().isCustomOrdering());
    }

    public void testManyToManyMorphToIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToVersionMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToTransientMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embedded");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToEmbeddedIdMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testManyToManyMorphToOneToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().setMappedByAttribute("mappedBy");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertEquals((String)"mappedBy", (String)((OneToOneMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getMappedByJoiningStrategy().getMappedByAttribute());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToOneToManyMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("name");
        joinColumn.setSpecifiedReferencedColumnName("referenceName");
        JoinColumn inverseJoinColumn = manyToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("inverseName");
        inverseJoinColumn.setSpecifiedReferencedColumnName("inverseReferenceName");
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((OneToManyMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((OneToManyMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
        JoinTable joinTable = ((OneToManyMapping)ormPersistentAttribute.getMapping()).getRelationshipReference().getJoinTableJoiningStrategy().getJoinTable();
        OrmManyToManyMappingTests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        OrmManyToManyMappingTests.assertEquals((String)"name", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"referenceName", (String)((JoinColumn)joinTable.joinColumns().next()).getSpecifiedReferencedColumnName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedName());
        OrmManyToManyMappingTests.assertEquals((String)"inverseReferenceName", (String)((JoinColumn)joinTable.inverseJoinColumns().next()).getSpecifiedReferencedColumnName());
    }

    public void testManyToManyMorphToManyToOneMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
        OrmManyToManyMappingTests.assertEquals((Object)FetchType.EAGER, (Object)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedFetch());
        OrmManyToManyMappingTests.assertEquals((String)"TargetEntity", (String)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getSpecifiedTargetEntity());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isAll());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isMerge());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isPersist());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRefresh());
        OrmManyToManyMappingTests.assertTrue((boolean)((ManyToOneMapping)ormPersistentAttribute.getMapping()).getCascade().isRemove());
    }

    public void testManyToManyMorphToBasicMapping() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("manyToMany", "manyToMany");
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        manyToManyMapping.setSpecifiedFetch(FetchType.EAGER);
        manyToManyMapping.setSpecifiedTargetEntity("TargetEntity");
        manyToManyMapping.getOrderable().setSpecifiedOrderBy("customOrder");
        manyToManyMapping.setSpecifiedMapKey("mapKey");
        manyToManyMapping.getCascade().setAll(true);
        manyToManyMapping.getCascade().setMerge(true);
        manyToManyMapping.getCascade().setPersist(true);
        manyToManyMapping.getCascade().setRefresh(true);
        manyToManyMapping.getCascade().setRemove(true);
        OrmManyToManyMappingTests.assertFalse((boolean)manyToManyMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        OrmManyToManyMappingTests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        OrmManyToManyMappingTests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        OrmManyToManyMappingTests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        OrmManyToManyMappingTests.assertEquals((String)"manyToMany", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addSpecifiedAttribute("manyToMany", "addresses");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.attributes().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        OrmManyToManyMappingTests.assertNull((Object)stateFooMapping);
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormManyToManyMapping.getPersistentAttribute().makeSpecified();
        ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        ormManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        OrmManyToManyMappingTests.assertFalse((boolean)mapKeyNames.hasNext());
        ormManyToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = ormManyToManyMapping.candidateMapKeyNames();
        OrmManyToManyMappingTests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }
}

