/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.InheritanceType;
import org.eclipse.jpt.core.context.java.JavaEntity;
import org.eclipse.jpt.core.context.java.JavaSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmSecondaryTableTests
extends ContextModelTestCase {
    public OrmSecondaryTableTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private void createTestSubType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("AnnotationTestTypeChild").append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setName("FOO");
        OrmSecondaryTable secondaryTable = (OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.getSpecifiedName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setName(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedName());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        entityResource.getSecondaryTables().remove(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmSecondaryTable secondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        secondaryTable.setSpecifiedName("foo");
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)secondaryTable.getSpecifiedName());
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        secondaryTable.setSpecifiedName(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedName());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getName());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        ormEntity.getJavaEntity().addSpecifiedSecondaryTable(0).setSpecifiedName("FOO");
        OrmSecondaryTable ormSecondaryTable = (OrmSecondaryTable)ormEntity.virtualSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)ormSecondaryTable.getSpecifiedName());
        ((JavaSecondaryTable)ormEntity.getJavaEntity().specifiedSecondaryTables().next()).setSpecifiedName("BAZ");
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)ormSecondaryTable.getSpecifiedName());
        ormEntity.setSecondaryTablesDefinedInXml(true);
        OrmSecondaryTableTests.assertNull((Object)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getDefaultName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getSpecifiedName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setSchema("FOO");
        OrmSecondaryTable secondaryTable = (OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.getSpecifiedSchema());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getSchema());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setSchema(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedSchema());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getSchema());
        entityResource.getSecondaryTables().remove(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmSecondaryTable secondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        secondaryTable.setSpecifiedSchema("foo");
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)secondaryTable.getSpecifiedSchema());
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getSchema());
        secondaryTable.setSpecifiedSchema(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedSchema());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getSchema());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testUpdateDefaultSchemaFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSecondaryTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        JavaSecondaryTable javaSecondaryTable = ormEntity.getJavaEntity().addSpecifiedSecondaryTable(0);
        javaSecondaryTable.setSpecifiedName("FOO");
        javaSecondaryTable.setSpecifiedSchema("BAR");
        OrmSecondaryTable ormSecondaryTable = (OrmSecondaryTable)ormEntity.virtualSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getSpecifiedSchema());
        javaSecondaryTable.setSpecifiedSchema("BAZ");
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)ormSecondaryTable.getSpecifiedSchema());
        ormEntity.setSecondaryTablesDefinedInXml(true);
        OrmSecondaryTableTests.assertNull((Object)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getDefaultSchema());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromParent() throws Exception {
        this.createTestEntity();
        this.createTestSubType();
        OrmPersistentType parentOrmPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType childOrmPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestTypeChild");
        OrmEntity parentOrmEntity = (OrmEntity)parentOrmPersistentType.getMapping();
        OrmEntity childOrmEntity = (OrmEntity)childOrmPersistentType.getMapping();
        OrmSecondaryTableTests.assertNull((Object)parentOrmEntity.getTable().getDefaultSchema());
        OrmSecondaryTableTests.assertNull((Object)childOrmEntity.getTable().getDefaultSchema());
        parentOrmEntity.getTable().setSpecifiedSchema("FOO");
        OrmSecondaryTableTests.assertNull((Object)parentOrmEntity.getTable().getDefaultSchema());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)childOrmEntity.getTable().getDefaultSchema());
        parentOrmEntity.setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        OrmSecondaryTableTests.assertNull((Object)parentOrmEntity.getTable().getDefaultSchema());
        OrmSecondaryTableTests.assertNull((Object)childOrmEntity.getTable().getDefaultSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        ormSecondaryTable.setSpecifiedName("FOO");
        OrmSecondaryTableTests.assertNull((Object)ormSecondaryTable.getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)ormSecondaryTable.getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getDefaultSchema());
        JavaSecondaryTable javaSecondaryTable = ormEntity.getJavaEntity().addSpecifiedSecondaryTable(0);
        javaSecondaryTable.setSpecifiedName("FOO");
        javaSecondaryTable.setSpecifiedSchema("JAVA_SCHEMA");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema(null);
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)ormSecondaryTable.getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedSchema(null);
        OrmSecondaryTableTests.assertNull((Object)ormSecondaryTable.getDefaultSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        entityResource.getSecondaryTables().add((Object)OrmFactory.eINSTANCE.createXmlSecondaryTable());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setCatalog("FOO");
        OrmSecondaryTable secondaryTable = (OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)secondaryTable.getSpecifiedCatalog());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getCatalog());
        ((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).setCatalog(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedCatalog());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getCatalog());
        entityResource.getSecondaryTables().remove(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.foo");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        OrmSecondaryTable secondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        secondaryTable.setSpecifiedCatalog("foo");
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)secondaryTable.getSpecifiedCatalog());
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getCatalog());
        secondaryTable.setSpecifiedCatalog(null);
        OrmSecondaryTableTests.assertNull((Object)secondaryTable.getSpecifiedCatalog());
        OrmSecondaryTableTests.assertNull((Object)((XmlSecondaryTable)entityResource.getSecondaryTables().get(0)).getCatalog());
        ormEntity.removeSpecifiedSecondaryTable(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormEntity.specifiedSecondaryTables().hasNext());
        OrmSecondaryTableTests.assertEquals((int)0, (int)entityResource.getSecondaryTables().size());
    }

    public void testUpdateDefaultCatalogFromJavaTable() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSecondaryTableTests.assertEquals((String)"AnnotationTestType", (String)ormEntity.getTable().getDefaultName());
        JavaSecondaryTable javaSecondaryTable = ormEntity.getJavaEntity().addSpecifiedSecondaryTable(0);
        javaSecondaryTable.setSpecifiedName("FOO");
        javaSecondaryTable.setSpecifiedCatalog("BAR");
        OrmSecondaryTable ormSecondaryTable = (OrmSecondaryTable)ormEntity.virtualSecondaryTables().next();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getSpecifiedCatalog());
        javaSecondaryTable.setSpecifiedCatalog("BAZ");
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)ormSecondaryTable.getSpecifiedCatalog());
        ormEntity.setSecondaryTablesDefinedInXml(true);
        OrmSecondaryTableTests.assertNull((Object)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getDefaultCatalog());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmSecondaryTable)ormEntity.specifiedSecondaryTables().next()).getSpecifiedCatalog());
    }

    public void testUpdateDefaultCatalogFromPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        ormSecondaryTable.setSpecifiedName("FOO");
        OrmSecondaryTableTests.assertNull((Object)ormSecondaryTable.getDefaultCatalog());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedCatalog("FOO");
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)ormSecondaryTable.getDefaultCatalog());
        this.getEntityMappings().setSpecifiedCatalog("BAR");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getDefaultCatalog());
        JavaSecondaryTable javaSecondaryTable = ormEntity.getJavaEntity().addSpecifiedSecondaryTable(0);
        javaSecondaryTable.setSpecifiedName("FOO");
        javaSecondaryTable.setSpecifiedCatalog("JAVA_CATALOG");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)ormSecondaryTable.getDefaultCatalog());
        this.getEntityMappings().setSpecifiedCatalog(null);
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)ormSecondaryTable.getDefaultCatalog());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedCatalog(null);
        OrmSecondaryTableTests.assertNull((Object)ormSecondaryTable.getDefaultCatalog());
    }

    public void testAddSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn = ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
        primaryKeyJoinColumn.setSpecifiedName("FOO");
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn2 = ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0);
        primaryKeyJoinColumn2.setSpecifiedName("BAR");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmPrimaryKeyJoinColumn primaryKeyJoinColumn3 = ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(1);
        primaryKeyJoinColumn3.setSpecifiedName("BAZ");
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ListIterator primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((Object)primaryKeyJoinColumn2, primaryKeyJoinColumns.next());
        OrmSecondaryTableTests.assertEquals((Object)primaryKeyJoinColumn3, primaryKeyJoinColumns.next());
        OrmSecondaryTableTests.assertEquals((Object)primaryKeyJoinColumn, primaryKeyJoinColumns.next());
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
    }

    public void testRemoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmSecondaryTableTests.assertEquals((int)3, (int)secondaryTableResource.getPrimaryKeyJoinColumns().size());
        ormSecondaryTable.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmSecondaryTableTests.assertEquals((int)2, (int)secondaryTableResource.getPrimaryKeyJoinColumns().size());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).getName());
        ormSecondaryTable.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmSecondaryTableTests.assertEquals((int)1, (int)secondaryTableResource.getPrimaryKeyJoinColumns().size());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        ormSecondaryTable.removeSpecifiedPrimaryKeyJoinColumn(0);
        OrmSecondaryTableTests.assertEquals((int)0, (int)secondaryTableResource.getPrimaryKeyJoinColumns().size());
    }

    public void testMoveSpecifiedPrimaryKeyJoinColumn() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(0).setSpecifiedName("FOO");
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(1).setSpecifiedName("BAR");
        ormSecondaryTable.addSpecifiedPrimaryKeyJoinColumn(2).setSpecifiedName("BAZ");
        OrmSecondaryTableTests.assertEquals((int)3, (int)secondaryTableResource.getPrimaryKeyJoinColumns().size());
        ormSecondaryTable.moveSpecifiedPrimaryKeyJoinColumn(2, 0);
        ListIterator primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(2)).getName());
        ormSecondaryTable.moveSpecifiedPrimaryKeyJoinColumn(0, 1);
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(2)).getName());
    }

    public void testUpdatePrimaryKeyJoinColumns() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        secondaryTableResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        secondaryTableResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        secondaryTableResource.getPrimaryKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumn());
        ((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(0)).setName("FOO");
        ((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(1)).setName("BAR");
        ((XmlPrimaryKeyJoinColumn)secondaryTableResource.getPrimaryKeyJoinColumns().get(2)).setName("BAZ");
        ListIterator primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        secondaryTableResource.getPrimaryKeyJoinColumns().move(2, 0);
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        secondaryTableResource.getPrimaryKeyJoinColumns().move(0, 1);
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        secondaryTableResource.getPrimaryKeyJoinColumns().remove(1);
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        secondaryTableResource.getPrimaryKeyJoinColumns().remove(1);
        primaryKeyJoinColumns = ormSecondaryTable.specifiedPrimaryKeyJoinColumns();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((OrmPrimaryKeyJoinColumn)primaryKeyJoinColumns.next()).getName());
        OrmSecondaryTableTests.assertFalse((boolean)primaryKeyJoinColumns.hasNext());
        secondaryTableResource.getPrimaryKeyJoinColumns().remove(0);
        OrmSecondaryTableTests.assertFalse((boolean)ormSecondaryTable.specifiedPrimaryKeyJoinColumns().hasNext());
    }

    public void testUniqueConstraints() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ListIterator uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmSecondaryTableTests.assertEquals((String)"bar", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"foo", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        OrmSecondaryTableTests.assertEquals((int)0, (int)ormSecondaryTable.uniqueConstraintsSize());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmSecondaryTableTests.assertEquals((int)2, (int)ormSecondaryTable.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormSecondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormSecondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormSecondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmSecondaryTableTests.assertEquals((int)3, (int)secondaryTableResource.getUniqueConstraints().size());
        ormSecondaryTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormSecondaryTable.removeUniqueConstraint(1);
        uniqueConstraintResources = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormSecondaryTable.removeUniqueConstraint(0);
        uniqueConstraintResources = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        ormSecondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormSecondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormSecondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmSecondaryTableTests.assertEquals((int)3, (int)secondaryTableResource.getUniqueConstraints().size());
        ormSecondaryTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintResources = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        ormSecondaryTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintResources = secondaryTableResource.getUniqueConstraints().listIterator();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)persistentType.getMapping();
        OrmSecondaryTable ormSecondaryTable = ormEntity.addSpecifiedSecondaryTable(0);
        XmlEntity entityResource = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        XmlSecondaryTable secondaryTableResource = (XmlSecondaryTable)entityResource.getSecondaryTables().get(0);
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        secondaryTableResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        secondaryTableResource.getUniqueConstraints().remove(0);
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmEntity ormEntity = (OrmEntity)ormPersistentType.getMapping();
        JavaEntity javaEntity = (JavaEntity)ormPersistentType.getJavaPersistentType().getMapping();
        JavaSecondaryTable javaSecondaryTable = javaEntity.addSpecifiedSecondaryTable(0);
        javaSecondaryTable.setSpecifiedName("SECONDARY");
        OrmSecondaryTable ormSecondaryTable = (OrmSecondaryTable)ormEntity.secondaryTables().next();
        OrmSecondaryTableTests.assertTrue((boolean)ormSecondaryTable.isVirtual());
        ListIterator uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        javaSecondaryTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        javaSecondaryTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        javaSecondaryTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        uniqueConstraints = ormSecondaryTable.uniqueConstraints();
        OrmSecondaryTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmSecondaryTableTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmSecondaryTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormEntity.setSecondaryTablesDefinedInXml(true);
        OrmSecondaryTable ormSecondaryTable2 = (OrmSecondaryTable)ormEntity.secondaryTables().next();
        ormSecondaryTable2.setSpecifiedName("SECONDARY");
        OrmSecondaryTableTests.assertEquals((String)"SECONDARY", (String)ormSecondaryTable.getSpecifiedName());
        OrmSecondaryTableTests.assertFalse((boolean)ormSecondaryTable2.isVirtual());
        OrmSecondaryTableTests.assertEquals((int)0, (int)ormSecondaryTable2.uniqueConstraintsSize());
    }
}

