/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.UniqueConstraint;
import org.eclipse.jpt.core.context.java.JavaIdMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmIdMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class OrmTableGeneratorTests
extends ContextModelTestCase {
    public OrmTableGeneratorTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public void testUpdateSpecifiedName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getName());
        tableGeneratorResource.setName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getName());
    }

    public void testModifySpecifiedName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getName());
        tableGenerator.setName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getName());
    }

    public void testUpdateSpecifiedInitialValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setInitialValue(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getInitialValue());
        tableGeneratorResource.setInitialValue(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getInitialValue());
        tableGeneratorResource.setInitialValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedInitialValue());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getInitialValue());
    }

    public void testModifySpecifiedInitialValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedInitialValue(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedInitialValue());
        tableGenerator.setSpecifiedInitialValue(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedInitialValue());
        tableGenerator.setSpecifiedInitialValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getInitialValue());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedInitialValue());
    }

    public void testUpdateSpecifiedAllocationSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setAllocationSize(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getAllocationSize());
        tableGeneratorResource.setAllocationSize(Integer.valueOf(1));
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)1, (Object)tableGeneratorResource.getAllocationSize());
        tableGeneratorResource.setAllocationSize(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedAllocationSize());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getAllocationSize());
    }

    public void testModifySpecifiedAllocationSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedAllocationSize(Integer.valueOf(10));
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)10, (Object)tableGenerator.getSpecifiedAllocationSize());
        tableGenerator.setSpecifiedAllocationSize(Integer.valueOf(50));
        OrmTableGeneratorTests.assertEquals((Object)50, (Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertEquals((Object)50, (Object)tableGenerator.getSpecifiedAllocationSize());
        tableGenerator.setSpecifiedAllocationSize(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getAllocationSize());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedAllocationSize());
    }

    public void testUpdateSpecifiedTable() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setTable("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedTable());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getTable());
        tableGeneratorResource.setTable(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedTable());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getTable());
    }

    public void testModifySpecifiedTable() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedTable("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getTable());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedTable());
        tableGenerator.setSpecifiedTable(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getTable());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedTable());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedSchema());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getSchema());
        tableGeneratorResource.setSchema(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedSchema());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getSchema());
    }

    public void testModifySpecifiedSchema() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getSchema());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedSchema());
        tableGenerator.setSpecifiedSchema(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getSchema());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedSchema());
    }

    public void testUpdateDefaultSchemaFromPersistenceUnitDefaults() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getDefaultSchema());
        this.getEntityMappings().getPersistenceUnitDefaults().setSpecifiedSchema("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getDefaultSchema());
        this.getEntityMappings().setSpecifiedSchema("BAR");
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)tableGenerator.getDefaultSchema());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setCatalog("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedCatalog());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getCatalog());
        tableGeneratorResource.setCatalog(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedCatalog());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getCatalog());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedCatalog("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getCatalog());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedCatalog());
        tableGenerator.setSpecifiedCatalog(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getCatalog());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedCatalog());
    }

    public void testUpdateSpecifiedPkColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setPkColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnName());
        tableGeneratorResource.setPkColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnName());
    }

    public void testModifySpecifiedPkColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedPkColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnName());
        tableGenerator.setSpecifiedPkColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnName());
    }

    public void testUpdateSpecifiedValueColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setValueColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedValueColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getValueColumnName());
        tableGeneratorResource.setValueColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedValueColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getValueColumnName());
    }

    public void testModifySpecifiedValueColumnName() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedValueColumnName("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getValueColumnName());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedValueColumnName());
        tableGenerator.setSpecifiedValueColumnName(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getValueColumnName());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedValueColumnName());
    }

    public void testUpdateSpecifiedPkColumnValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGeneratorResource.setPkColumnValue("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnValue());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnValue());
        tableGeneratorResource.setPkColumnValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnValue());
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnValue());
    }

    public void testModifySpecifiedPkColumnValue() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.setSpecifiedPkColumnValue("FOO");
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGeneratorResource.getPkColumnValue());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)tableGenerator.getSpecifiedPkColumnValue());
        tableGenerator.setSpecifiedPkColumnValue(null);
        OrmTableGeneratorTests.assertNull((Object)tableGeneratorResource.getPkColumnValue());
        OrmTableGeneratorTests.assertNull((Object)tableGenerator.getSpecifiedPkColumnValue());
    }

    public void testUniqueConstraints() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmTableGeneratorTests.assertEquals((String)"bar", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"foo", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        OrmTableGeneratorTests.assertEquals((int)0, (int)tableGenerator.uniqueConstraintsSize());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmTableGeneratorTests.assertEquals((int)2, (int)tableGenerator.uniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorResource.getUniqueConstraints().size());
        tableGenerator.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(1);
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGenerator.removeUniqueConstraint(0);
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        tableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        tableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        tableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmTableGeneratorTests.assertEquals((int)3, (int)tableGeneratorResource.getUniqueConstraints().size());
        tableGenerator.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        ListIterator uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        tableGenerator.moveUniqueConstraint(0, 1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        uniqueConstraintResources = tableGeneratorResource.getUniqueConstraints().listIterator();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        OrmTableGenerator tableGenerator = this.getEntityMappings().addTableGenerator(0);
        XmlTableGenerator tableGeneratorResource = (XmlTableGenerator)this.getXmlEntityMappings().getTableGenerators().get(0);
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        tableGeneratorResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(1);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((UniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        tableGeneratorResource.getUniqueConstraints().remove(0);
        uniqueConstraints = tableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntity();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmIdMapping ormIdMapping = (OrmIdMapping)((OrmPersistentAttribute)ormPersistentType.attributes().next()).getMapping();
        JavaIdMapping javaIdMapping = (JavaIdMapping)((JavaPersistentAttribute)ormPersistentType.getJavaPersistentType().attributes().next()).getMapping();
        JavaTableGenerator javaTableGenerator = javaIdMapping.getGeneratorContainer().addTableGenerator();
        javaTableGenerator.setName("TABLE_GENERATOR");
        OrmTableGenerator ormTableGenerator = ormIdMapping.getGeneratorContainer().getTableGenerator();
        OrmTableGeneratorTests.assertTrue((boolean)ormTableGenerator.isVirtual());
        ListIterator uniqueConstraints = ormTableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        javaTableGenerator.addUniqueConstraint(0).addColumnName(0, "FOO");
        javaTableGenerator.addUniqueConstraint(1).addColumnName(0, "BAR");
        javaTableGenerator.addUniqueConstraint(2).addColumnName(0, "BAZ");
        uniqueConstraints = ormTableGenerator.uniqueConstraints();
        OrmTableGeneratorTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmTableGeneratorTests.assertEquals((String)"FOO", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAR", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertEquals((String)"BAZ", (String)((String)((OrmUniqueConstraint)uniqueConstraints.next()).columnNames().next()));
        OrmTableGeneratorTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormIdMapping.getPersistentAttribute().makeSpecified();
        ormIdMapping = (OrmIdMapping)((OrmPersistentAttribute)ormPersistentType.attributes().next()).getMapping();
        OrmTableGenerator ormTableGenerator2 = ormIdMapping.getGeneratorContainer().addTableGenerator();
        ormTableGenerator2.setName("TABLE_GENERATOR");
        OrmTableGeneratorTests.assertFalse((boolean)ormTableGenerator2.isVirtual());
        OrmTableGeneratorTests.assertEquals((int)0, (int)ormTableGenerator2.uniqueConstraintsSize());
    }
}

