/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.jpa2.context.OneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.OneToOneRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaDerivedIdentity2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaManyToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOneToOneMapping2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOrphanRemovable2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaOrphanRemovalHolder2_0;
import org.eclipse.jpt.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.jpt.core.jpa2.resource.java.OneToOne2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.OneToOneAnnotation;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericJavaOneToOneMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericJavaOneToOneMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestEntity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithIdDerivedIdentity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @Id").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createTestEntityWithMapsIdDerivedIdentity() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.MapsId"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne @MapsId").append(CR);
                sb.append("    private AnnotationTestType oneToOne;").append(CR);
                sb.append(CR);
            }
        });
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        for (OrmPersistentAttribute each : CollectionTools.iterable((Iterator)ormPersistentType.attributes())) {
            each.makeSpecified();
        }
    }

    private ICompilationUnit createTestEntityWithValidOneToOneMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified() throws Exception {
        this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.OneToOne"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @OneToOne(orphanRemoval=false)");
                sb.append(CR);
                sb.append("    private Address address;");
                sb.append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createTestTargetEntityAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableState() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "State.java", sourceWriter);
    }

    public void testUpdateId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        resourceAttribute.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testSetId() throws Exception {
        this.createTestEntityWithIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(false);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().setValue(true);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)contextMapping.getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
    }

    public void testUpdateMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        annotation.setValue("bar");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        resourceAttribute.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testSetMapsId() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("foo");
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId");
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue("bar");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)annotation.getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"bar", (String)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().setSpecifiedValue(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)contextMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testUpdatePredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.addAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.MapsId");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.Id");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testSetPredominantDerivedIdentityStrategy() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        JavaOneToOneMapping2_0 contextMapping = (JavaOneToOneMapping2_0)contextAttribute.getMapping();
        JavaDerivedIdentity2_0 derivedIdentity = contextMapping.getDerivedIdentity();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setIdDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setNullDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
        derivedIdentity.setMapsIdDerivedIdentityStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)derivedIdentity.usesMapsIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesIdDerivedIdentityStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)derivedIdentity.usesNullDerivedIdentityStrategy());
    }

    public void testMorphMapping() throws Exception {
        this.createTestEntityWithMapsIdDerivedIdentity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentType resourceType = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)resourceType.persistableAttributes().next();
        JavaPersistentType contextType = this.getJavaPersistentType();
        JavaPersistentAttribute contextAttribute = contextType.getAttributeNamed("oneToOne");
        ((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).setValue("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.Id"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("manyToOne");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((JavaManyToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
        contextAttribute.setSpecifiedMappingKey("oneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getIdDerivedIdentityStrategy().getValue());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.MapsId"));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((MapsId2_0Annotation)resourceAttribute.getAnnotation("javax.persistence.MapsId")).getValue());
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)((JavaOneToOneMapping2_0)contextAttribute.getMapping()).getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getSpecifiedValue());
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)persistentAttribute.getMapping();
        Iterator attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity("foo");
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        oneToOneMapping.setSpecifiedTargetEntity(null);
        attributeNames = oneToOneMapping.getRelationshipReference().getMappedByJoiningStrategy().candidateMappedByAttributeNames();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = oneToOneMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    private JavaOrphanRemovable2_0 getOrphanRemovalOf(OneToOneMapping2_0 oneToOneMapping) {
        return ((JavaOrphanRemovalHolder2_0)oneToOneMapping).getOrphanRemoval();
    }

    public void testDefaultOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testSpecifiedOneToOneGetDefaultOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getSpecifiedMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)this.getOrphanRemovalOf(oneToOneMapping).isDefaultOrphanRemoval());
    }

    public void testGetOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)false, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((boolean)true, (boolean)mappingsOrphanRemoval.isOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation oneToOne = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
    }

    public void testGetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntityWithValidOneToOneMappingOrphanRemovalSpecified();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getSpecifiedMapping();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)this.getOrphanRemovalOf(oneToOneMapping).getSpecifiedOrphanRemoval());
    }

    public void testSetSpecifiedOrphanRemoval() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation oneToOne = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testSetSpecifiedOrphanRemoval2() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(Boolean.TRUE);
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation oneToOne = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)oneToOne.getOrphanRemoval());
        oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getMapping();
        mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        mappingsOrphanRemoval.setSpecifiedOrphanRemoval(null);
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)attributeResource.getAnnotation("javax.persistence.OneToOne"));
    }

    public void testGetSpecifiedOrphanRemovalUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        PersistentAttribute persistentAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 oneToOneMapping = (OneToOneMapping2_0)persistentAttribute.getSpecifiedMapping();
        JavaOrphanRemovable2_0 mappingsOrphanRemoval = this.getOrphanRemovalOf(oneToOneMapping);
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        JavaResourcePersistentType typeResource = this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType");
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.persistableAttributes().next();
        OneToOne2_0Annotation oneToOne = (OneToOne2_0Annotation)attributeResource.getAnnotation("javax.persistence.OneToOne");
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        oneToOne.setOrphanRemoval(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)mappingsOrphanRemoval.getSpecifiedOrphanRemoval());
        GenericJavaOneToOneMapping2_0Tests.assertSame((Object)oneToOneMapping, (Object)persistentAttribute.getSpecifiedMapping());
        oneToOne.setOrphanRemoval(Boolean.FALSE);
        attributeResource.setPrimaryAnnotation(null, EmptyIterable.instance());
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)persistentAttribute.getSpecifiedMapping());
    }

    public void testModifyPredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationshipReference2_0 relationshipReference = mapping.getRelationshipReference();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setPrimaryKeyJoinColumnJoiningStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setMappedByJoiningStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinTableJoiningStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        relationshipReference.setJoinColumnJoiningStrategy();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }

    public void testUpdatePredominantJoiningStrategy() throws Exception {
        this.createTestEntityWithValidOneToOneMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaResourcePersistentAttribute resourceAttribute = (JavaResourcePersistentAttribute)this.getJpaProject().getJavaResourcePersistentType("test.AnnotationTestType").persistableAttributes().next();
        OneToOneAnnotation annotation = (OneToOneAnnotation)resourceAttribute.getAnnotation("javax.persistence.OneToOne");
        PersistentAttribute contextAttribute = (PersistentAttribute)this.getJavaPersistentType().attributes().next();
        OneToOneMapping2_0 mapping = (OneToOneMapping2_0)contextAttribute.getMapping();
        OneToOneRelationshipReference2_0 relationshipReference = mapping.getRelationshipReference();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        annotation.setMappedBy("foo");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.addAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        annotation.setMappedBy(null);
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinColumn");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNotNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinTableJoiningStrategy());
        resourceAttribute.removeAnnotation("javax.persistence.JoinTable");
        this.getJpaProject().synchronizeContextModel();
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.PrimaryKeyJoinColumn"));
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)annotation.getMappedBy());
        GenericJavaOneToOneMapping2_0Tests.assertNull((Object)resourceAttribute.getAnnotation("javax.persistence.JoinTable"));
        GenericJavaOneToOneMapping2_0Tests.assertTrue((boolean)relationshipReference.usesJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesPrimaryKeyJoinColumnJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesMappedByJoiningStrategy());
        GenericJavaOneToOneMapping2_0Tests.assertFalse((boolean)relationshipReference.usesJoinTableJoiningStrategy());
    }
}

