/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BasicMapping;
import org.eclipse.jpt.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.core.context.EmbeddedMapping;
import org.eclipse.jpt.core.context.IdMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.JoinTable;
import org.eclipse.jpt.core.context.JoinTableJoiningStrategy;
import org.eclipse.jpt.core.context.ManyToManyMapping;
import org.eclipse.jpt.core.context.ManyToOneMapping;
import org.eclipse.jpt.core.context.OneToManyMapping;
import org.eclipse.jpt.core.context.OneToOneMapping;
import org.eclipse.jpt.core.context.TransientMapping;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.core.context.java.JavaAssociationOverride;
import org.eclipse.jpt.core.context.java.JavaAttributeOverride;
import org.eclipse.jpt.core.context.java.JavaBasicMapping;
import org.eclipse.jpt.core.context.java.JavaColumn;
import org.eclipse.jpt.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.core.context.java.JavaJoinTable;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverride;
import org.eclipse.jpt.core.context.orm.OrmAssociationOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverride;
import org.eclipse.jpt.core.context.orm.OrmAttributeOverrideContainer;
import org.eclipse.jpt.core.context.orm.OrmColumn;
import org.eclipse.jpt.core.context.orm.OrmEmbeddedMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.persistence.ClassRef;
import org.eclipse.jpt.core.jpa2.context.AssociationOverrideRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaAssociationOverrideRelationshipReference2_0;
import org.eclipse.jpt.core.jpa2.context.java.JavaEmbeddedMapping2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmEmbeddedMapping2_0;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlAssociationOverride;
import org.eclipse.jpt.core.resource.orm.XmlAttributeOverride;
import org.eclipse.jpt.core.resource.orm.XmlEmbedded;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.jpt.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class GenericOrmEmbeddedMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    private static final String ATTRIBUTE_OVERRIDE_NAME = "city";
    private static final String ATTRIBUTE_OVERRIDE_COLUMN_NAME = "E_CITY";
    private static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    private static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    public GenericOrmEmbeddedMapping2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityEmbeddedMappingAttributeOverrides() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.AttributeOverride", "javax.persistence.Column"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @Embedded");
                sb.append(CR);
                sb.append("    @AttributeOverride(name=\"city\", column=@Column(name=\"E_CITY\"))");
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithEmbeddedMapping() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Embedded", "javax.persistence.Id"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Embedded").append(CR);
                sb.append("    private MyEmbeddable myEmbedded;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToOne");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.OneToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericOrmEmbeddedMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @OneToOne").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("    @OneToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    private void createAddressEntity() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Address {");
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableAddress() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Column");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @Column(name=\"A_STATE\")").append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEntityCustomer() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Customer").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String id;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Customer.java", sourceWriter);
    }

    private void createTestEmbeddableAddress2() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String street;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private ZipCode zipCode;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestEmbeddableZipCode() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("ZipCode").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String zip;").append(CR);
                sb.append(CR);
                sb.append("    private String plusfour;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "ZipCode.java", sourceWriter);
    }

    private void createSelfReferentialEmbedded() throws Exception {
        TestJavaProject.SourceWriter sourceWriter = new TestJavaProject.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embedded");
                sb.append(";");
                sb.append(CR).append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("Foo").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Embedded").append(CR);
                sb.append("    private Foo embedded;").append(CR);
                sb.append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProject.createCompilationUnit("test", "Foo.java", sourceWriter);
    }

    public void testUpdateName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        embeddedResource.setName("newName");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)embeddedResource.getName());
        embeddedResource.setName(null);
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)embeddedResource.getName());
    }

    public void testModifyName() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embeddedMapping", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embeddedMapping", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName("newName");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"newName", (String)embeddedResource.getName());
        ormEmbeddedMapping.setName(null);
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertNull((Object)embeddedResource.getName());
    }

    public void testMoveSpecifiedAttributeOverride() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)embeddedResource.getAttributeOverrides().size());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(2, 0);
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
        attributeOverrideContainer.moveSpecifiedAttributeOverride(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).getName());
    }

    public void testUpdateAttributeOverrides() throws Exception {
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "model.Foo");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embeddedMapping");
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(0)).setName("FOO");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(1)).setName("BAR");
        ((XmlAttributeOverride)embeddedResource.getAttributeOverrides().get(2)).setName("BAZ");
        ListIterator attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(2, 0);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().move(0, 1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(1);
        attributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAttributeOverride)attributeOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrides.hasNext());
        embeddedResource.getAttributeOverrides().remove(0);
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
    }

    public void testEmbeddedMappingNoUnderylingJavaAttribute() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embedded", "foo");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"foo", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.specifiedAttributeOverrides().hasNext());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)attributeOverrideContainer.virtualAttributeOverrides().hasNext());
    }

    public void testVirtualAttributeOverrides() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentType persistentType2 = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentAttribute ormPersistentAttribute = persistentType.getAttributeNamed("address");
        OrmEmbeddedMapping embeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        JavaEmbeddedMapping javaEmbeddedMapping = (JavaEmbeddedMapping)ormPersistentAttribute.getJavaPersistentAttribute().getMapping();
        JavaColumn javaAttributeOverrideColumn = ((JavaAttributeOverride)javaEmbeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next()).getColumn();
        javaAttributeOverrideColumn.setSpecifiedName("FOO_COLUMN");
        javaAttributeOverrideColumn.setSpecifiedTable("FOO_TABLE");
        javaAttributeOverrideColumn.setColumnDefinition("COLUMN_DEF");
        javaAttributeOverrideColumn.setSpecifiedInsertable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUpdatable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedUnique(Boolean.TRUE);
        javaAttributeOverrideColumn.setSpecifiedNullable(Boolean.FALSE);
        javaAttributeOverrideColumn.setSpecifiedLength(Integer.valueOf(5));
        javaAttributeOverrideColumn.setSpecifiedPrecision(Integer.valueOf(6));
        javaAttributeOverrideColumn.setSpecifiedScale(Integer.valueOf(7));
        JavaBasicMapping javaBasicMapping = (JavaBasicMapping)persistentType2.getJavaPersistentType().getAttributeNamed("state").getMapping();
        javaBasicMapping.getColumn().setSpecifiedName("MY_STATE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        specifiedAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)attributeOverride.getColumn().getSpecifiedTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)attributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)attributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
        attributeOverride = (OrmAttributeOverride)specifiedAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        persistentType.getAttributeNamed("address").makeSpecified();
        embeddedMapping = (OrmEmbeddedMapping)persistentType.getAttributeNamed("address").getMapping();
        attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)attributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)attributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)attributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)attributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverride.getColumn().getScale());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_STATE_COLUMN", (String)attributeOverride.getColumn().getDefaultName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)attributeOverride.getColumn().getDefaultTable());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
        ((OrmAttributeOverride)attributeOverrideContainer.virtualAttributeOverrides().next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.attributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)((OrmAttributeOverride)attributeOverrideContainer.specifiedAttributeOverrides().next()).getName());
        virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)attributeOverride.getName());
        attributeOverride = (OrmAttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)attributeOverride.getName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        OrmAttributeOverrideContainer attributeOverrideContainer = ormEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)4, (int)attributeOverrideContainer.specifiedAttributeOverridesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator ormAttributeOverrides = attributeOverrideContainer.specifiedAttributeOverrides();
        OrmAttributeOverride ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)ormAttributeOverride.getName());
        OrmColumn ormColumn = ormAttributeOverride.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_COLUMN_NAME, (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"A_STATE", (String)ormColumn.getSpecifiedName());
        ormAttributeOverride = (OrmAttributeOverride)ormAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)ormAttributeOverride.getName());
        ormColumn = ormAttributeOverride.getColumn();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)ormColumn.getSpecifiedName());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.virtualAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
    }

    public void testSpecifiedMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        this.createTestEmbeddableAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        ormPersistentType.addSpecifiedAttribute("embedded", "address");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)ormPersistentType.virtualAttributesSize());
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.specifiedAttributes().next();
        OrmEmbeddedMapping ormEmbeddedMapping = (OrmEmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)ormEmbeddedMapping.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)ormEmbeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverridesSize());
    }

    public void testEmbeddedMorphToIdMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("id");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof IdMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToVersionMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("version");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof VersionMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToTransientMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("transient");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof TransientMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToBasicMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("basic");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof BasicMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToEmbeddedIdMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("embeddedId");
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof EmbeddedIdMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
        attributeOverride = (AttributeOverride)((EmbeddedIdMapping)ormPersistentAttribute.getMapping()).getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"override", (String)attributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"OVERRIDE_COLUMN", (String)attributeOverride.getColumn().getSpecifiedName());
    }

    public void testEmbeddedMorphToOneToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToOne");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToOneToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("oneToMany");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToOneMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToOne");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)ormPersistentType.specifiedAttributesSize());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((Object)ormPersistentAttribute, ormPersistentType.specifiedAttributes().next());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testEmbeddedMorphToManyToManyMapping() throws Exception {
        this.createTestEntityEmbeddedMappingAttributeOverrides();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "embedded");
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)ormPersistentAttribute.getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        embeddedResource.getAttributeOverrides().add((Object)OrmFactory.eINSTANCE.createXmlAttributeOverride());
        AttributeOverride attributeOverride = (AttributeOverride)embeddedMapping.getAttributeOverrideContainer().specifiedAttributeOverrides().next();
        attributeOverride.setName("override");
        attributeOverride.getColumn().setSpecifiedName("OVERRIDE_COLUMN");
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.isDefault());
        ormPersistentAttribute.setSpecifiedMappingKey("manyToMany");
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)(ormPersistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"embedded", (String)ormPersistentAttribute.getMapping().getName());
    }

    public void testSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("FOO");
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(1, (Object)associationOverride);
        associationOverride.setName("BAR");
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("BAZ");
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(1, 0);
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((OrmAssociationOverride)specifiedAssociationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        specifiedAssociationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        JoinColumnJoiningStrategy joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address_id", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        JavaPersistentType javaEmbeddable = ((ClassRef)this.getPersistenceUnit().specifiedClassRefs().next()).getJavaPersistentType();
        OneToOneMapping oneToOneMapping = (OneToOneMapping)javaEmbeddable.getAttributeNamed("address").getMapping();
        JoinColumn joinColumn = oneToOneMapping.getRelationshipReference().getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTable("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        joiningStrategy = virtualAssociationOverride.getRelationshipReference().getJoinColumnJoiningStrategy();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joiningStrategy.joinColumnsSize());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        virtualJoinColumn = (JoinColumn)joiningStrategy.joinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)((JoinColumn)joiningStrategy.joinColumns().next()).getName());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testSpecifiedAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.specifiedAssociationOverridesSize());
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("FOO");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("BAR");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.specifiedAssociationOverridesSize());
    }

    public void testVirtualAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)overrideContainer.virtualAssociationOverridesSize());
    }

    public void testAssociationOverridesSize() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.associationOverridesSize());
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add((Object)associationOverride);
        associationOverride.setName("bar");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)3, (int)overrideContainer.associationOverridesSize());
    }

    public void testAssociationOverrideSetVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtual2() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverrides.next();
        ((OrmAssociationOverride)virtualAssociationOverrides.next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
    }

    public void testAssociationOverrideSetVirtualTrue() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)embeddedResource.getAssociationOverrides().size());
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((OrmAssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.specifiedAssociationOverrides().next()).setVirtual(true);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)embeddedResource.getAssociationOverrides().size());
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testMoveSpecifiedAssociationOverride() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)embeddedResource.getAssociationOverrides().size());
        overrideContainer.moveSpecifiedAssociationOverride(1, 0);
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
        overrideContainer.moveSpecifiedAssociationOverride(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(0)).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)((XmlAssociationOverride)embeddedResource.getAssociationOverrides().get(1)).getName());
    }

    public void testUpdateSpecifiedAssociationOverrides() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        XmlEmbedded embeddedResource = (XmlEmbedded)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getEmbeddeds().get(0);
        XmlAssociationOverride associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(0, (Object)associationOverride);
        associationOverride.setName("FOO");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(1, (Object)associationOverride);
        associationOverride.setName("BAR");
        associationOverride = OrmFactory.eINSTANCE.createXmlAssociationOverride();
        embeddedResource.getAssociationOverrides().add(2, (Object)associationOverride);
        associationOverride.setName("BAZ");
        ListIterator associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(2, 0);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().move(0, 1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(1);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverride)associationOverrides.next()).getName());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
        embeddedResource.getAssociationOverrides().remove(0);
        associationOverrides = overrideContainer.specifiedAssociationOverrides();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)associationOverrides.hasNext());
    }

    public void testAssociationOverrideIsVirtual() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        ListIterator virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        AssociationOverride virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
        ((AssociationOverride)overrideContainer.virtualAssociationOverrides().next()).setVirtual(false);
        AssociationOverride specifiedAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)specifiedAssociationOverride.isVirtual());
        virtualAssociationOverrides = overrideContainer.virtualAssociationOverrides();
        virtualAssociationOverride = (AssociationOverride)virtualAssociationOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertTrue((boolean)virtualAssociationOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)virtualAssociationOverrides.hasNext());
    }

    public void testVirtualAssociationOverrideJoinTableDefaults() throws Exception {
        this.createTestEntityWithEmbeddedMapping();
        this.createEmbeddableType();
        this.createAddressEntity();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        this.addXmlClassRef("test.Address");
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.addSpecifiedAttribute("embedded", "myEmbedded");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentAttribute.getMapping();
        OrmAssociationOverrideContainer overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        AssociationOverride virtualAssociationOverride = (AssociationOverride)CollectionTools.get((Iterator)overrideContainer.virtualAssociationOverrides(), (int)1);
        JoinTableJoiningStrategy joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        JoinTable joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        JoinColumn virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_id", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        JoinColumn virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses_id", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"id", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)virtualInverseJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isNullable());
        JavaPersistentType javaEmbeddable = ((ClassRef)this.getPersistenceUnit().specifiedClassRefs().next()).getJavaPersistentType();
        OneToManyMapping oneToManyMapping = (OneToManyMapping)javaEmbeddable.getAttributeNamed("addresses").getMapping();
        JoinTableJoiningStrategy joinTableStrategy = oneToManyMapping.getRelationshipReference().getJoinTableJoiningStrategy();
        joinTableStrategy.getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        JoinColumn joinColumn = joinTableStrategy.getJoinTable().addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("MY_JOIN_COLUMN");
        joinColumn.setSpecifiedReferencedColumnName("MY_REFERENCE_COLUMN");
        joinColumn.setSpecifiedTable("BAR");
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setSpecifiedInsertable(Boolean.FALSE);
        joinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        joinColumn.setSpecifiedUnique(Boolean.TRUE);
        joinColumn.setSpecifiedNullable(Boolean.FALSE);
        JoinColumn inverseJoinColumn = joinTableStrategy.getJoinTable().addSpecifiedInverseJoinColumn(0);
        inverseJoinColumn.setSpecifiedName("MY_INVERSE_JOIN_COLUMN");
        inverseJoinColumn.setSpecifiedReferencedColumnName("MY_INVERSE_REFERENCE_COLUMN");
        inverseJoinColumn.setSpecifiedTable("INVERSE_BAR");
        inverseJoinColumn.setColumnDefinition("INVERSE_COLUMN_DEF");
        inverseJoinColumn.setSpecifiedInsertable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUpdatable(Boolean.FALSE);
        inverseJoinColumn.setSpecifiedUnique(Boolean.TRUE);
        inverseJoinColumn.setSpecifiedNullable(Boolean.FALSE);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)CollectionTools.get((Iterator)overrideContainer.virtualAssociationOverrides(), (int)1);
        joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        JavaEmbeddedMapping2_0 javaEmbeddedMapping = (JavaEmbeddedMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("myEmbedded").getMapping();
        ListIterator javaAssociationOverrides = javaEmbeddedMapping.getAssociationOverrideContainer().associationOverrides();
        javaAssociationOverrides.next();
        JavaAssociationOverride javaAssociationOverride = ((JavaAssociationOverride)javaAssociationOverrides.next()).setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)javaAssociationOverride.getName());
        JavaJoinTable javaJoinTable = ((JavaAssociationOverrideRelationshipReference2_0)javaAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("JAVA_FOO");
        JavaJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("JAVA_JOIN_COLUMN_NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("JAVA_JOIN_COLUMN_REFERENCED_NAME");
        JavaJoinColumn javaInverseJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        javaInverseJoinColumn.setSpecifiedName("JAVA_INVERSE_JOIN_COLUMN_NAME");
        javaInverseJoinColumn.setSpecifiedReferencedColumnName("JAVA_INVERSE_JOIN_COLUMN_REFERENCED_NAME");
        this.getOrmXmlResource().save(null);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)overrideContainer.virtualAssociationOverridesSize());
        virtualAssociationOverride = (AssociationOverride)CollectionTools.get((Iterator)overrideContainer.virtualAssociationOverrides(), (int)1);
        joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        this.getOrmXmlResource().save(null);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_JOIN_COLUMN", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_REFERENCE_COLUMN", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BAR", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEF", (String)virtualJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualJoinColumn.isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_JOIN_COLUMN", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"MY_INVERSE_REFERENCE_COLUMN", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_BAR", (String)virtualInverseJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"INVERSE_COLUMN_DEF", (String)virtualInverseJoinColumn.getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualInverseJoinColumn.isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualInverseJoinColumn.isNullable());
        virtualAssociationOverride = (AssociationOverride)overrideContainer.virtualAssociationOverrides().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"address", (String)virtualAssociationOverride.getName());
        virtualAssociationOverride = virtualAssociationOverride.setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)overrideContainer.virtualAssociationOverridesSize());
        ormPersistentType.removeSpecifiedAttribute(ormPersistentAttribute);
        this.getOrmXmlResource().save(null);
        embeddedMapping = (OrmEmbeddedMapping2_0)ormPersistentType.getAttributeNamed("myEmbedded").getMapping();
        overrideContainer = embeddedMapping.getAssociationOverrideContainer();
        virtualAssociationOverride = (AssociationOverride)overrideContainer.specifiedAssociationOverrides().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"addresses", (String)virtualAssociationOverride.getName());
        joiningStrategy = ((AssociationOverrideRelationshipReference2_0)virtualAssociationOverride.getRelationshipReference()).getJoinTableJoiningStrategy();
        joinTable = joiningStrategy.getJoinTable();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)joinTable.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.joinColumnsSize());
        virtualJoinColumn = (JoinColumn)joinTable.joinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_JOIN_COLUMN_NAME", (String)virtualJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_JOIN_COLUMN_REFERENCED_NAME", (String)virtualJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)virtualJoinColumn.getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)1, (int)joinTable.inverseJoinColumnsSize());
        virtualInverseJoinColumn = (JoinColumn)joinTable.inverseJoinColumns().next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_INVERSE_JOIN_COLUMN_NAME", (String)virtualInverseJoinColumn.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_INVERSE_JOIN_COLUMN_REFERENCED_NAME", (String)virtualInverseJoinColumn.getReferencedColumnName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"JAVA_FOO", (String)virtualInverseJoinColumn.getTable());
    }

    public void testNestedVirtualAttributeOverrides() throws Exception {
        this.createTestEntityCustomer();
        this.createTestEmbeddableAddress2();
        this.createTestEmbeddableZipCode();
        OrmPersistentType customerPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Customer");
        OrmPersistentType addressPersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Address");
        OrmPersistentType zipCodePersistentType = this.getEntityMappings().addPersistentType("embeddable", "test.ZipCode");
        customerPersistentType.getAttributeNamed("address").makeSpecified();
        EmbeddedMapping embeddedMapping = (EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping();
        AttributeOverrideContainer attributeOverrideContainer = embeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)attributeOverrideContainer.virtualAttributeOverridesSize());
        ListIterator virtualAttributeOverrides = attributeOverrideContainer.virtualAttributeOverrides();
        AttributeOverride virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"street", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)ATTRIBUTE_OVERRIDE_NAME, (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"state", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.zip", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTable());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"Customer", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        addressPersistentType.getAttributeNamed("zipCode").makeSpecified();
        EmbeddedMapping nestedEmbeddedMapping = (EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping();
        AttributeOverrideContainer nestedAttributeOverrideContainer = nestedEmbeddedMapping.getAttributeOverrideContainer();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)2, (int)nestedAttributeOverrideContainer.virtualAttributeOverridesSize());
        virtualAttributeOverrides = nestedAttributeOverrideContainer.virtualAttributeOverrides();
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zip", (String)virtualAttributeOverride.getName());
        virtualAttributeOverride = (AttributeOverride)virtualAttributeOverrides.next();
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        zipCodePersistentType.getAttributeNamed("plusfour").makeSpecified();
        BasicMapping plusFourMapping = (BasicMapping)zipCodePersistentType.getAttributeNamed("plusfour").getMapping();
        plusFourMapping.getColumn().setSpecifiedName("BLAH");
        plusFourMapping.getColumn().setSpecifiedTable("BLAH_TABLE");
        plusFourMapping.getColumn().setColumnDefinition("COLUMN_DEFINITION");
        plusFourMapping.getColumn().setSpecifiedInsertable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUpdatable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedUnique(Boolean.TRUE);
        plusFourMapping.getColumn().setSpecifiedNullable(Boolean.FALSE);
        plusFourMapping.getColumn().setSpecifiedLength(Integer.valueOf(5));
        plusFourMapping.getColumn().setSpecifiedPrecision(Integer.valueOf(6));
        plusFourMapping.getColumn().setSpecifiedScale(Integer.valueOf(7));
        virtualAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("zipCode.plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)5, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)6, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)7, (int)virtualAttributeOverride.getColumn().getScale());
        AttributeOverride specifiedAttributeOverride = ((EmbeddedMapping)addressPersistentType.getAttributeNamed("zipCode").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("plusfour").setVirtual(false);
        specifiedAttributeOverride.getColumn().setSpecifiedName("BLAH_OVERRIDE");
        specifiedAttributeOverride.getColumn().setSpecifiedTable("BLAH_TABLE_OVERRIDE");
        specifiedAttributeOverride.getColumn().setColumnDefinition("COLUMN_DEFINITION_OVERRIDE");
        virtualAttributeOverride = ((EmbeddedMapping)customerPersistentType.getAttributeNamed("address").getMapping()).getAttributeOverrideContainer().getAttributeOverrideNamed("zipCode.plusfour");
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)virtualAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)virtualAttributeOverride.getColumn().getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_TABLE_OVERRIDE", (String)virtualAttributeOverride.getColumn().getTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION_OVERRIDE", (String)virtualAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)virtualAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)virtualAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)virtualAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)virtualAttributeOverride.getColumn().getScale());
        specifiedAttributeOverride = virtualAttributeOverride.setVirtual(false);
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.isVirtual());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"zipCode.plusfour", (String)specifiedAttributeOverride.getName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((String)"BLAH_OVERRIDE", (String)specifiedAttributeOverride.getColumn().getSpecifiedName());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)specifiedAttributeOverride.getColumn().getSpecifiedTable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals(null, (String)specifiedAttributeOverride.getColumn().getColumnDefinition());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isInsertable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isUpdatable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)false, (boolean)specifiedAttributeOverride.getColumn().isUnique());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((boolean)true, (boolean)specifiedAttributeOverride.getColumn().isNullable());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)255, (int)specifiedAttributeOverride.getColumn().getLength());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getPrecision());
        GenericOrmEmbeddedMapping2_0Tests.assertEquals((int)0, (int)specifiedAttributeOverride.getColumn().getScale());
    }

    public void testSelfReferentialEmbeddedMapping() throws Exception {
        this.createSelfReferentialEmbedded();
        OrmPersistentType persistentType = this.getEntityMappings().addPersistentType("embeddable", "test.Foo");
        OrmEmbeddedMapping2_0 embeddedMapping = (OrmEmbeddedMapping2_0)persistentType.getAttributeNamed("embedded").getMapping();
        GenericOrmEmbeddedMapping2_0Tests.assertFalse((boolean)embeddedMapping.allOverrideableAttributeMappingNames().hasNext());
    }
}

