/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.jpa2.resource.java.AssociationOverride2_0Annotation;
import org.eclipse.jpt.core.resource.java.AssociationOverrideAnnotation;
import org.eclipse.jpt.core.resource.java.AssociationOverridesAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class AssociationOverrides2_0Tests
extends JavaResourceModel2_0TestCase {
    private static final String ASSOCIATION_OVERRIDE_NAME = "MY_ASSOCIATION_OVERRIDE";
    private static final String JOIN_TABLE_NAME = "MY_JOIN_TABLE";
    private static final String CATALOG_NAME = "MY_CATALOG";
    private static final String SCHEMA_NAME = "MY_SCHEMA";

    public AssociationOverrides2_0Tests(String name) {
        super(name);
    }

    private ICompilationUnit createTestAssociationOverrideOnField() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn}))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverride() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.AssociationOverride", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
                sb.append(CR);
                sb.append("@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideOnType() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\"))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideWithJoinTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\")))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithCatalog() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(catalog = \"MY_CATALOG\")))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithSchema() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(schema = \"MY_SCHEMA\")))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithUniqueConstraints() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.UniqueConstraint"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})})))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})))");
            }
        });
    }

    private ICompilationUnit createTestAssociationOverrideJoinTableWithInverseJoinColumns() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.AssociationOverrides", "javax.persistence.AssociationOverride", "javax.persistence.JoinTable", "javax.persistence.JoinColumn"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn})))");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverrides2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverrides2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverrides2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverrides2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName("Foo");
        AssociationOverrides2_0Tests.assertEquals((String)"Foo", (String)associationOverride.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)attributeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)associationOverrides.getNestedAnnotations().iterator().next();
        AssociationOverrides2_0Tests.assertEquals((String)ASSOCIATION_OVERRIDE_NAME, (String)associationOverride.getName());
        associationOverride.setName(null);
        AssociationOverrides2_0Tests.assertNull((Object)associationOverride.getName());
        this.assertSourceDoesNotContain("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
        this.assertSourceContains("@AssociationOverride", cu);
        this.assertSourceContains("@AssociationOverrides", cu);
    }

    public void testAddAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        AssociationOverrides2_0Tests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverrides2_0Tests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
    }

    public void testAddAssociationOverrideToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(0, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAZ");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"BAZ\"),@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")), @AssociationOverride(name = \"BAR\")})", cu);
        Iterator associationOverrides = typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        AssociationOverrides2_0Tests.assertEquals((String)"BAZ", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((AssociationOverrideAnnotation)associationOverrides.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverride"));
        AssociationOverrides2_0Tests.assertNotNull((Object)typeResource.getAnnotation("javax.persistence.AssociationOverrides"));
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)CollectionTools.size((Iterator)typeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides")));
    }

    public void testRemoveAssociationOverrideCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverride();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)typeResource.addAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        associationOverride.setName("BAR");
        this.assertSourceContains("@AssociationOverrides({@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\")),@AssociationOverride(name = \"BAR\")})", cu);
        typeResource.removeAnnotation(1, "javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides");
        this.assertSourceContains("@AssociationOverride(name = \"FOO\", joinColumns = @JoinColumn(name = \"FOO\", columnDefinition = \"BAR\", referencedColumnName = \"BAZ\"))", cu);
    }

    public void testJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0);
        associationOverride.addJoinColumn(1);
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
    }

    public void testAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnField();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0).setName("FOO");
        associationOverride.addJoinColumn(1);
        associationOverride.addJoinColumn(0).setName("BAR");
        ListIterator joinColumns = associationOverride.joinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        associationOverride.addJoinColumn(0).setName("FOO");
        ListIterator joinColumns = associationOverride.joinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(1);
        joinColumns = associationOverride.joinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
        associationOverride.removeJoinColumn(0);
        joinColumns = associationOverride.joinColumns();
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)joinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((boolean)false, (boolean)joinColumns.hasNext());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = @JoinColumn))", cu);
        associationOverride.setName(null);
        associationOverride.removeJoinColumn(0);
        this.assertSourceDoesNotContain("@AssociationOverride", cu);
    }

    public void testMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(2, 0);
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertNull((Object)associationOverride.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        JoinColumnAnnotation joinColumn = associationOverride.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        associationOverride.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        associationOverride.moveJoinColumn(0, 2);
        AssociationOverrides2_0Tests.assertNull((Object)associationOverride.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)associationOverride.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)associationOverride.joinColumnAt(2).getName());
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)associationOverride.joinColumnsSize());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")}))", cu);
    }

    public void testSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        AssociationOverrideAnnotation associationOverride = (AssociationOverrideAnnotation)attributeResource.annotations("javax.persistence.AssociationOverride", "javax.persistence.AssociationOverrides").next();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)associationOverride.joinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)associationOverride.joinColumns().next();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverrides2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverrides(@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }

    public void testGetNullJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)associationOverride);
        AssociationOverrides2_0Tests.assertNull((Object)joinTable);
    }

    public void testJoinTableGetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((String)JOIN_TABLE_NAME, (String)joinTable.getName());
    }

    public void testJoinTableSetName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((String)JOIN_TABLE_NAME, (String)joinTable.getName());
        joinTable.setName("Foo");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"Foo\"))", cu);
        joinTable.setName(null);
        AssociationOverrides2_0Tests.assertNull((Object)associationOverride.getJoinTable());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\")", cu);
    }

    public void testAddJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNull((Object)joinTable);
        associationOverride.addJoinTable();
        joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)joinTable);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable)", cu);
    }

    public void testRemoveJoinTable() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideOnType();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation joinTable = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNull((Object)joinTable);
    }

    public void testJoinTableGetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)table);
        AssociationOverrides2_0Tests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
    }

    public void testJoinTableSetCatalog() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)table);
        AssociationOverrides2_0Tests.assertNull((Object)table.getCatalog());
        table.setCatalog("Foo");
        AssociationOverrides2_0Tests.assertEquals((String)"Foo", (String)table.getCatalog());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", catalog = \"Foo\"))", cu);
    }

    public void testJoinTableSetCatalogNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithCatalog();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((String)CATALOG_NAME, (String)table.getCatalog());
        table.setCatalog(null);
        AssociationOverrides2_0Tests.assertNull((Object)table.getCatalog());
        this.assertSourceDoesNotContain("@JoinTable", cu);
    }

    public void testJoinTableGetSchema() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)table);
        AssociationOverrides2_0Tests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
    }

    public void testJoinTableSetSchema() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertNotNull((Object)table);
        AssociationOverrides2_0Tests.assertNull((Object)table.getSchema());
        table.setSchema("Foo");
        AssociationOverrides2_0Tests.assertEquals((String)"Foo", (String)table.getSchema());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", schema = \"Foo\"))", cu);
    }

    public void testJoinTableSetSchemaNull() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithSchema();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((String)SCHEMA_NAME, (String)table.getSchema());
        table.setSchema(null);
        AssociationOverrides2_0Tests.assertNull((Object)table.getSchema());
        this.assertSourceDoesNotContain("@JoinTable", cu);
    }

    public void testJoinTableUniqueConstraints() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.uniqueConstraintsSize());
    }

    public void testJoinTableUniqueConstraints2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addUniqueConstraint(0);
        table.addUniqueConstraint(1);
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.uniqueConstraintsSize());
    }

    public void testJoinTableUniqueConstraints3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)table.uniqueConstraintsSize());
    }

    public void testJoinTableAddUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addUniqueConstraint(0).addColumnName("FOO");
        table.addUniqueConstraint(1);
        table.addUniqueConstraint(0).addColumnName("BAR");
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.uniqueConstraintAt(2).columnNamesSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", uniqueConstraints = {@UniqueConstraint(columnNames = \"BAR\"),@UniqueConstraint(columnNames = \"FOO\"), @UniqueConstraint}))", cu);
    }

    public void testJoinTableRemoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(2).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)table.uniqueConstraintsSize());
        table.removeUniqueConstraint(1);
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(1).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.uniqueConstraintsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.removeUniqueConstraint(0);
        AssociationOverrides2_0Tests.assertEquals((String)"BAZ", (String)((String)table.uniqueConstraintAt(0).columnNames().next()));
        AssociationOverrides2_0Tests.assertEquals((int)1, (int)table.uniqueConstraintsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = @UniqueConstraint(columnNames = {\"BAZ\"})))", cu);
        table.removeUniqueConstraint(0);
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.uniqueConstraintsSize());
        this.assertSourceDoesNotContain("@JoinTable", cu);
    }

    public void testJoinTableMoveUniqueConstraint() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.moveUniqueConstraint(2, 0);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"})}))", cu);
    }

    public void testJoinTableMoveUniqueConstraint2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithUniqueConstraints();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"}), @UniqueConstraint(columnNames = {\"BAZ\"})}))", cu);
        table.moveUniqueConstraint(0, 2);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(uniqueConstraints = {@UniqueConstraint(columnNames = {\"BAZ\"}), @UniqueConstraint(columnNames = {\"BAR\"}), @UniqueConstraint(columnNames = {\"FOO\"})}))", cu);
    }

    public void testJoinTableJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.joinColumnsSize());
    }

    public void testJoinTableJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0);
        table.addJoinColumn(1);
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.joinColumnsSize());
    }

    public void testJoinTableJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.joinColumnsSize());
    }

    public void testJoinTableAddJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0).setName("FOO");
        table.addJoinColumn(1);
        table.addJoinColumn(0).setName("BAR");
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", joinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testJoinTableRemoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addJoinColumn(0).setName("FOO");
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(2).getName());
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)table.joinColumnsSize());
        table.removeJoinColumn(1);
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
        table.removeJoinColumn(0);
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((int)1, (int)table.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = @JoinColumn))", cu);
        table.removeJoinColumn(0);
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.joinColumnsSize());
        this.assertSourceDoesNotContain("@JoinTable", cu);
    }

    public void testJoinTableMoveJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        table.moveJoinColumn(2, 0);
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(2).getName());
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)table.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableMoveJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        JoinColumnAnnotation joinColumn = table.joinColumnAt(0);
        joinColumn.setReferencedColumnName("REF_NAME");
        joinColumn.setUnique(Boolean.FALSE);
        joinColumn.setNullable(Boolean.FALSE);
        joinColumn.setInsertable(Boolean.FALSE);
        joinColumn.setUpdatable(Boolean.FALSE);
        joinColumn.setColumnDefinition("COLUMN_DEF");
        joinColumn.setTable("TABLE");
        table.addJoinColumn(0).setName("FOO");
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn}))", cu);
        table.moveJoinColumn(0, 2);
        AssociationOverrides2_0Tests.assertNull((Object)table.joinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.joinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)table.joinColumnAt(2).getName());
        AssociationOverrides2_0Tests.assertEquals((int)3, (int)table.joinColumnsSize());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn, @JoinColumn(name = \"FOO\"), @JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")}))", cu);
    }

    public void testJoinTableSetJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.joinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)table.joinColumns().next();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverrides2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(joinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }

    public void testJoinTableInverseJoinColumns() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)0, (int)table.inverseJoinColumnsSize());
    }

    public void testInverseJoinColumns2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0);
        table.addInverseJoinColumn(1);
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.inverseJoinColumnsSize());
    }

    public void testJoinTableInverseJoinColumns3() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.inverseJoinColumnsSize());
    }

    public void testAddInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideWithJoinTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0).setName("FOO");
        table.addInverseJoinColumn(1);
        table.addInverseJoinColumn(0).setName("BAR");
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)table.inverseJoinColumnAt(0).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)table.inverseJoinColumnAt(1).getName());
        AssociationOverrides2_0Tests.assertNull((Object)table.inverseJoinColumnAt(2).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(name = \"MY_JOIN_TABLE\", inverseJoinColumns = {@JoinColumn(name = \"BAR\"),@JoinColumn(name = \"FOO\"), @JoinColumn}))", cu);
    }

    public void testJoinTableRemoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(2).setName("FOO");
        ListIterator inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(1);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")}))", cu);
        inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = @JoinColumn(name = \"FOO\")))", cu);
        inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertFalse((boolean)inverseJoinColumns.hasNext());
        table.removeInverseJoinColumn(0);
        this.assertSourceDoesNotContain("@JoinTable", cu);
    }

    public void testJoinTableMoveInverseJoinColumn() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(0).setName("FOO");
        ListIterator inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(2, 0);
        inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"BAR\"), @JoinColumn, @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableMoveInverseJoinColumn2() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        table.addInverseJoinColumn(1).setName("FOO");
        ListIterator inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        table.moveInverseJoinColumn(0, 2);
        inverseJoinColumns = table.inverseJoinColumns();
        AssociationOverrides2_0Tests.assertNull((Object)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        AssociationOverrides2_0Tests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)inverseJoinColumns.next()).getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn, @JoinColumn(name = \"BAR\"), @JoinColumn(name = \"FOO\")}))", cu);
    }

    public void testJoinTableSetInverseJoinColumnName() throws Exception {
        ICompilationUnit cu = this.createTestAssociationOverrideJoinTableWithInverseJoinColumns();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        AssociationOverridesAnnotation associationOverrides = (AssociationOverridesAnnotation)typeResource.getAnnotation("javax.persistence.AssociationOverrides");
        AssociationOverride2_0Annotation associationOverride = (AssociationOverride2_0Annotation)associationOverrides.getNestedAnnotations().iterator().next();
        JoinTableAnnotation table = associationOverride.getJoinTable();
        AssociationOverrides2_0Tests.assertEquals((int)2, (int)table.inverseJoinColumnsSize());
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)table.inverseJoinColumns().next();
        AssociationOverrides2_0Tests.assertEquals((String)"BAR", (String)joinColumn.getName());
        joinColumn.setName("foo");
        AssociationOverrides2_0Tests.assertEquals((String)"foo", (String)joinColumn.getName());
        this.assertSourceContains("@AssociationOverride(name = \"MY_ASSOCIATION_OVERRIDE\", joinTable = @JoinTable(inverseJoinColumns = {@JoinColumn(name = \"foo\"), @JoinColumn}))", cu);
    }
}

