/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class MapsId2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public MapsId2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapsId() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapsId"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapsId");
            }
        });
    }

    private ICompilationUnit createTestMapsIdWithValue() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.MapsId"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapsId(\"foo\")");
            }
        });
    }

    public void testMapsId() throws Exception {
        ICompilationUnit cu = this.createTestMapsId();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapsId");
        MapsId2_0AnnotationTests.assertNotNull((Object)annotation);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapsIdWithValue();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapsId");
        MapsId2_0AnnotationTests.assertEquals((String)"foo", (String)annotation.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapsId();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        MapsId2_0Annotation annotation = (MapsId2_0Annotation)attributeResource.getAnnotation("javax.persistence.MapsId");
        annotation.setValue("foo");
        this.assertSourceContains("@MapsId(\"foo\")", cu);
        annotation.setValue(null);
        this.assertSourceContains("@MapsId", cu);
    }
}

