/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.platform;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.core.internal.facet.JpaFacetInstallDataModelProvider;
import org.eclipse.jpt.core.tests.extension.resource.ExtensionTestPlugin;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestAttributeMapping;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestAttributeMappingDefinition;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestTypeMapping;
import org.eclipse.jpt.core.tests.extension.resource.JavaTestTypeMappingDefinition;
import org.eclipse.jpt.core.tests.extension.resource.TestJavaBasicMapping;
import org.eclipse.jpt.core.tests.extension.resource.TestJavaEntity;
import org.eclipse.jpt.core.tests.extension.resource.TestJpaFactory;
import org.eclipse.jpt.core.tests.extension.resource.TestJpaPlatformProvider;
import org.eclipse.jpt.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.core.tests.internal.platform.JpaPlatformExtensionTests;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class JpaPlatformTests
extends ContextModelTestCase {
    protected TestJpaProject testProject;
    public static final String TEST_PLUGIN_CLASS = ExtensionTestPlugin.class.getName();
    public static final String TEST_PLUGIN_ID = "org.eclipse.jpt.core.tests.extension.resource";
    public static final String TEST_PLATFORM_CLASS_NAME = TestJpaPlatformProvider.class.getName();
    public static final String TEST_PLATFORM_LABEL = "Test Jpa Platform";
    public static final String TEST_JPA_FACTORY = TestJpaFactory.class.getName();
    public static final String TEST_TYPE_MAPPING_PROVIDER_CLASS = JavaTestTypeMappingDefinition.class.getName();
    public static final String TEST_ATTRIBUTE_MAPPING_PROVIDER_CLASS = JavaTestAttributeMappingDefinition.class.getName();

    public JpaPlatformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JpaPlatformExtensionTests.verifyExtensionTestProjectExists();
    }

    protected TestJavaProject buildJavaProject(boolean autoBuild) throws Exception {
        return super.buildJpaProject("AnnotationTestProject", autoBuild, this.buildConfig());
    }

    protected IDataModel buildConfig() throws Exception {
        JpaFacetInstallDataModelProvider configFactory = new JpaFacetInstallDataModelProvider();
        IDataModel config = (IDataModel)configFactory.create();
        config.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)"1.0");
        config.setProperty("JpaFacetDataModelProperties.PLATFORM_ID", (Object)"core.testJpaPlatform");
        return config;
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            @Override
            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    protected JpaPlatform jpaPlatform() {
        return this.getJpaProject().getJpaPlatform();
    }

    public void testJpaFactory() {
        JpaPlatformTests.assertTrue((boolean)this.jpaPlatform().getJpaFactory().getClass().getName().equals(TEST_JPA_FACTORY));
    }

    public void testBuildJavaTypeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaTypeMappingDefinition mappingDefinition = this.jpaPlatform().getJavaTypeMappingDefinition("test");
        JavaTypeMapping mapping = mappingDefinition.buildMapping(this.getJavaPersistentType(), this.jpaPlatform().getJpaFactory());
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof JavaTestTypeMapping));
        mappingDefinition = this.jpaPlatform().getJavaTypeMappingDefinition("entity");
        mapping = mappingDefinition.buildMapping(this.getJavaPersistentType(), this.jpaPlatform().getJpaFactory());
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof TestJavaEntity));
    }

    public void testBuildJavaAttributeMappingFromMappingKey() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaAttributeMappingDefinition mappingDefinition = this.jpaPlatform().getSpecifiedJavaAttributeMappingDefinition("testAttribute");
        JavaAttributeMapping mapping = mappingDefinition.buildMapping(this.getJavaPersistentType().getAttributeNamed("name"), this.jpaPlatform().getJpaFactory());
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof JavaTestAttributeMapping));
        mappingDefinition = this.jpaPlatform().getSpecifiedJavaAttributeMappingDefinition("basic");
        mapping = mappingDefinition.buildMapping(this.getJavaPersistentType().getAttributeNamed("name"), this.jpaPlatform().getJpaFactory());
        JpaPlatformTests.assertTrue((boolean)(mapping instanceof TestJavaBasicMapping));
    }
}

