/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.core.JpaAnnotationProvider;
import org.eclipse.jpt.core.internal.GenericJpaAnnotationDefinitionProvider;
import org.eclipse.jpt.core.internal.GenericJpaAnnotationProvider;
import org.eclipse.jpt.core.internal.resource.java.source.SourceCompilationUnit;
import org.eclipse.jpt.core.internal.utility.jdt.NullAnnotationEditFormatter;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.CommandExecutor;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.StringTools;

public class JavaResourceModelTestCase
extends AnnotationTestCase {
    public static final String JAVAX_PERSISTENCE_PACKAGE_NAME = "javax.persistence";
    private JavaElementChangeListener javaElementChangeListener;
    protected JavaResourceCompilationUnit javaResourceCompilationUnit;

    public JavaResourceModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaProject.addJar(TestJpaProject.jpaJarName());
        if (TestJpaProject.eclipseLinkJarName() != null) {
            this.javaProject.addJar(TestJpaProject.eclipseLinkJarName());
        }
        this.javaElementChangeListener = new JavaElementChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.javaElementChangeListener = null;
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.javaResourceCompilationUnit == null) {
            return;
        }
        this.syncWithJavaDelta(event.getDelta());
    }

    protected void syncWithJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.syncWithJavaDeltaChildren(delta);
                break;
            }
            case 5: {
                this.javaCompilationUnitChanged(delta);
                break;
            }
        }
    }

    protected void syncWithJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            this.syncWithJavaDelta(child);
            ++n2;
        }
    }

    protected void javaCompilationUnitChanged(IJavaElementDelta delta) {
        if (this.deltaIsRelevant(delta)) {
            this.javaResourceCompilationUnit.synchronizeWithJavaSource();
        }
    }

    protected boolean deltaIsRelevant(IJavaElementDelta delta) {
        if (BitTools.onlyFlagIsSet((int)delta.getFlags(), (int)65536)) {
            return false;
        }
        return delta.getKind() == 4;
    }

    protected ICompilationUnit createAnnotationAndMembers(String annotationName, String annotationBody) throws Exception {
        return this.createAnnotationAndMembers(JAVAX_PERSISTENCE_PACKAGE_NAME, annotationName, annotationBody);
    }

    protected ICompilationUnit createAnnotationAndMembers(String packageName, String annotationName, String annotationBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(annotationName) + ".java", "public @interface " + annotationName + " { " + annotationBody + " }");
    }

    protected ICompilationUnit createEnumAndMembers(String enumName, String enumBody) throws Exception {
        return this.createEnumAndMembers(JAVAX_PERSISTENCE_PACKAGE_NAME, enumName, enumBody);
    }

    protected ICompilationUnit createEnumAndMembers(String packageName, String enumName, String enumBody) throws Exception {
        return this.javaProject.createCompilationUnit(packageName, String.valueOf(enumName) + ".java", "public enum " + enumName + " { " + enumBody + " }");
    }

    protected JavaResourcePersistentType buildJavaTypeResource(ICompilationUnit cu) {
        this.javaResourceCompilationUnit = this.buildJavaResourceCompilationUnit(cu);
        this.javaResourceCompilationUnit.resolveTypes();
        return this.hackJavaResourcePersistentType();
    }

    protected JavaResourcePersistentType hackJavaResourcePersistentType() {
        return (JavaResourcePersistentType)ReflectionTools.getFieldValue((Object)this.javaResourceCompilationUnit, (String)"persistentType");
    }

    protected JavaResourceCompilationUnit buildJavaResourceCompilationUnit(ICompilationUnit cu) {
        if (this.javaResourceCompilationUnit != null) {
            throw new IllegalStateException();
        }
        return new SourceCompilationUnit(cu, this.buildAnnotationProvider(), NullAnnotationEditFormatter.instance(), CommandExecutor.Default.instance());
    }

    protected JpaAnnotationProvider buildAnnotationProvider() {
        return new GenericJpaAnnotationProvider(new JpaAnnotationDefinitionProvider[]{this.annotationDefinitionProvider()});
    }

    protected JpaAnnotationDefinitionProvider annotationDefinitionProvider() {
        return GenericJpaAnnotationDefinitionProvider.instance();
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JavaResourceModelTestCase.this.javaElementChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

