/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.tests.internal.resource.java.JavaResourceModelTestCase;
import org.eclipse.jpt.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;

public class JoinColumnTests
extends JavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public JoinColumnTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinColumn() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(name = \"MY_COLUMN\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithTable() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(table = \"MY_TABLE\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(columnDefinition = \"COLUMN_DEFINITION\")");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType(new AnnotationTestCase.DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return new ArrayIterator((Object[])new String[]{"javax.persistence.JoinColumn"});
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(" + booleanElement + " = true)");
            }
        });
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getName());
        JoinColumnTests.assertNull((Object)column.getNullable());
        JoinColumnTests.assertNull((Object)column.getInsertable());
        JoinColumnTests.assertNull((Object)column.getUnique());
        JoinColumnTests.assertNull((Object)column.getUpdatable());
        JoinColumnTests.assertNull((Object)column.getTable());
        JoinColumnTests.assertNull((Object)column.getReferencedColumnName());
        JoinColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getName());
        column.setName("Foo");
        JoinColumnTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@JoinColumn(name = \"Foo\")", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        JoinColumnTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithTable();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        JoinColumnTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@JoinColumn(table = \"Foo\")", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithReferencedColumnName();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        JoinColumnTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@JoinColumn(referencedColumnName = \"Foo\")", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithColumnDefinition();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        JoinColumnTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@JoinColumn(columnDefinition = \"Foo\")", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("unique");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        JoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUnique());
        this.assertSourceContains("@JoinColumn(unique = false)", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("nullable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        JoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getNullable());
        this.assertSourceContains("@JoinColumn(nullable = false)", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("insertable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        JoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getInsertable());
        this.assertSourceContains("@JoinColumn(insertable = false)", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("updatable");
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertEquals((Object)Boolean.TRUE, (Object)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourcePersistentType typeResource = this.buildJavaTypeResource(cu);
        JavaResourcePersistentAttribute attributeResource = (JavaResourcePersistentAttribute)typeResource.fields().next();
        JoinColumnAnnotation column = (JoinColumnAnnotation)attributeResource.getAnnotation("javax.persistence.JoinColumn");
        JoinColumnTests.assertNotNull((Object)column);
        JoinColumnTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        JoinColumnTests.assertEquals((Object)Boolean.FALSE, (Object)column.getUpdatable());
        this.assertSourceContains("@JoinColumn(updatable = false)", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@JoinColumn", cu);
    }
}

