/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.dom;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.EmptyStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.tests.dom.ConverterTestSetup;

public class ASTConverterRecoveryTest
extends ConverterTestSetup {
    static /* synthetic */ Class class$0;

    public ASTConverterRecoveryTest(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.dom.ASTConverterRecoveryTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTConverterRecoveryTest.buildModelTestSuite(clazz);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.ast = AST.newAST((int)3);
    }

    public void test0001() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar(0)\n\t    baz(1);\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar(0);\n    baz(1);\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)2, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar(0)", source);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar(0)", source);
        List list = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list.size() == 1 ? 1 : 0) != 0);
        Expression parameter = (Expression)list.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a number", (boolean)(parameter instanceof NumberLiteral));
        ITypeBinding typeBinding = parameter.resolveTypeBinding();
        ASTConverterRecoveryTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterRecoveryTest.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)parameter, "0", source);
        Statement statement2 = (Statement)statements.get(1);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement2.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement2 = (ExpressionStatement)statement2;
        this.checkSourceRange((ASTNode)expressionStatement2, "baz(1);", source);
        Expression expression2 = expressionStatement2.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression2.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)expression2;
        this.checkSourceRange((ASTNode)methodInvocation2, "baz(1)", source);
        List list2 = methodInvocation2.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list2.size() == 1 ? 1 : 0) != 0);
        Expression parameter2 = (Expression)list2.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a number", (boolean)(parameter2 instanceof NumberLiteral));
        ITypeBinding typeBinding2 = parameter2.resolveTypeBinding();
        ASTConverterRecoveryTest.assertNotNull((String)"No binding", (Object)typeBinding2);
        ASTConverterRecoveryTest.assertEquals((String)"Not int", (String)"int", (String)typeBinding2.getName());
        this.checkSourceRange((ASTNode)parameter2, "1", source);
    }

    public void test0002() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    baz(0);\n\t    bar(1,\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    baz(0);\n    bar(1);\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)2, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "baz(0);", source);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "baz(0)", source);
        List list = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list.size() == 1 ? 1 : 0) != 0);
        Expression parameter = (Expression)list.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a number", (boolean)(parameter instanceof NumberLiteral));
        ITypeBinding typeBinding = parameter.resolveTypeBinding();
        ASTConverterRecoveryTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterRecoveryTest.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)parameter, "0", source);
        Statement statement2 = (Statement)statements.get(1);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement2.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement2 = (ExpressionStatement)statement2;
        this.checkSourceRange((ASTNode)expressionStatement2, "bar(1", source);
        Expression expression2 = expressionStatement2.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression2.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)expression2;
        this.checkSourceRange((ASTNode)methodInvocation2, "bar(1", source);
        List list2 = methodInvocation2.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list2.size() == 1 ? 1 : 0) != 0);
        Expression parameter2 = (Expression)list2.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a number", (boolean)(parameter2 instanceof NumberLiteral));
        ITypeBinding typeBinding2 = parameter2.resolveTypeBinding();
        ASTConverterRecoveryTest.assertNotNull((String)"No binding", (Object)typeBinding2);
        ASTConverterRecoveryTest.assertEquals((String)"Not int", (String)"int", (String)typeBinding2.getName());
        this.checkSourceRange((ASTNode)parameter2, "1", source);
    }

    public void test0003() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    baz(0);\n\t    bar(1,\n\t    foo(3);\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    baz(0);\n    bar(1,foo(3));\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)2, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "baz(0);", source);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "baz(0)", source);
        List list = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list.size() == 1 ? 1 : 0) != 0);
        Expression parameter = (Expression)list.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a number", (boolean)(parameter instanceof NumberLiteral));
        ITypeBinding typeBinding = parameter.resolveTypeBinding();
        ASTConverterRecoveryTest.assertNotNull((String)"No binding", (Object)typeBinding);
        ASTConverterRecoveryTest.assertEquals((String)"Not int", (String)"int", (String)typeBinding.getName());
        this.checkSourceRange((ASTNode)parameter, "0", source);
        Statement statement2 = (Statement)statements.get(1);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement2.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement2 = (ExpressionStatement)statement2;
        this.checkSourceRange((ASTNode)expressionStatement2, "bar(1,\n\t    foo(3);", source);
        Expression expression2 = expressionStatement2.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression2.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)expression2;
        this.checkSourceRange((ASTNode)methodInvocation2, "bar(1,\n\t    foo(3)", source);
        List list2 = methodInvocation2.arguments();
        ASTConverterRecoveryTest.assertTrue((String)"Parameter list is empty", (list2.size() == 2 ? 1 : 0) != 0);
        Expression parameter2 = (Expression)list2.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a Number", (boolean)(parameter2 instanceof NumberLiteral));
        parameter2 = (Expression)list2.get(1);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (boolean)(parameter2 instanceof FunctionInvocation));
        FunctionInvocation methodInvocation3 = (FunctionInvocation)parameter2;
        this.checkSourceRange((ASTNode)methodInvocation3, "foo(3)", source);
    }

    public void test0004() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    int var= 123\n\t    System.out.println(var);\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    int var=123;\n    System.out.println(var);\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)2, (int)statements.size());
        Statement statement1 = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement1.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement1;
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "int var= 123", source);
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)variableDeclarationFragment, "var= 123", source);
    }

    public void test0005() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    String[] s =  {\"\",,,};\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    String[] s={\"\",$missing$};\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        Block block = methodDeclaration.getBody();
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement1 = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression variable declaration statement", (statement1.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement1;
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "String[] s =  {\"\",,,};", source);
        List fragments = variableDeclarationStatement.fragments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)variableDeclarationFragment, "s =  {\"\",,,}", source);
        Expression expression = variableDeclarationFragment.getInitializer();
        ASTConverterRecoveryTest.assertTrue((String)"Not an array initializer", (expression.getNodeType() == 4 ? 1 : 0) != 0);
        ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
        this.checkSourceRange((ASTNode)arrayInitializer, "{\"\",,,}", source);
        List expressions = arrayInitializer.expressions();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)2, (int)expressions.size());
        Expression expression1 = (Expression)expressions.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a string literal", (expression1.getNodeType() == 45 ? 1 : 0) != 0);
        StringLiteral stringLiteral = (StringLiteral)expression1;
        this.checkSourceRange((ASTNode)stringLiteral, "\"\"", source);
        Expression expression2 = (Expression)expressions.get(1);
        ASTConverterRecoveryTest.assertTrue((String)"Not a string literal", (expression2.getNodeType() == 42 ? 1 : 0) != 0);
        SimpleName simpleName = (SimpleName)expression2;
        this.checkSourceRange((ASTNode)simpleName, ",", source);
    }

    public void test0006() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar()\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar();\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((expressionStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0007() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar(baz()\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar(baz());\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar(baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((expressionStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar(baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((methodInvocation.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List arguments = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (argument.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)argument;
        this.checkSourceRange((ASTNode)methodInvocation2, "baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation2.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0008() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    for(int i\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    for (int i; ; )     ;\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((block.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a for statement", (statement.getNodeType() == 24 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)statement;
        this.checkSourceRange((ASTNode)forStatement, "for(int i", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((forStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List initializers = forStatement.initializers();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Expression expression = (Expression)initializers.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 58 ? 1 : 0) != 0);
        VariableDeclarationExpression variableDeclarationExpression = (VariableDeclarationExpression)expression;
        this.checkSourceRange((ASTNode)variableDeclarationExpression, "int i", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((variableDeclarationExpression.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List fragments = variableDeclarationExpression.fragments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)fragments.size());
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        this.checkSourceRange((ASTNode)fragment, "i", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((fragment.getFlags() & 8) != 0 ? 1 : 0) != 0);
        SimpleName name = fragment.getName();
        this.checkSourceRange((ASTNode)name, "i", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((name.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Statement statement2 = forStatement.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Not an empty statement", (statement2.getNodeType() == 20 ? 1 : 0) != 0);
        EmptyStatement emptyStatement = (EmptyStatement)statement2;
        this.checkSourceRange((ASTNode)emptyStatement, "i", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((emptyStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
    }

    public void test0009() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar(baz());#\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar(baz());\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((block.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar(baz());", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((expressionStatement.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar(baz())", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List arguments = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (argument.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)argument;
        this.checkSourceRange((ASTNode)methodInvocation2, "baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation2.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0010() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar(baz())#;\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar(baz());\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar(baz())#;", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((expressionStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar(baz())", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List arguments = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (argument.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)argument;
        this.checkSourceRange((ASTNode)methodInvocation2, "baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation2.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0011() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar(baz()#);\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar(baz());\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar(baz()#);", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((expressionStatement.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar(baz()#)", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((methodInvocation.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List arguments = methodInvocation.arguments();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)arguments.size());
        Expression argument = (Expression)arguments.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (argument.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation2 = (FunctionInvocation)argument;
        this.checkSourceRange((ASTNode)methodInvocation2, "baz()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation2.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0012() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    bar()#\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    bar();\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "bar()#", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((expressionStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not a method invocation", (expression.getNodeType() == 32 ? 1 : 0) != 0);
        FunctionInvocation methodInvocation = (FunctionInvocation)expression;
        this.checkSourceRange((ASTNode)methodInvocation, "bar()", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodInvocation.getFlags() & 8) == 0 ? 1 : 0) != 0);
    }

    public void test0013() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    a[0]\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    a[0]=$missing$;\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not an expression statement", (statement.getNodeType() == 21 ? 1 : 0) != 0);
        ExpressionStatement expressionStatement = (ExpressionStatement)statement;
        this.checkSourceRange((ASTNode)expressionStatement, "a[0]", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((expressionStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression expression = expressionStatement.getExpression();
        ASTConverterRecoveryTest.assertTrue((String)"Not an assigment", (expression.getNodeType() == 7 ? 1 : 0) != 0);
        Assignment assignment = (Assignment)expression;
        this.checkSourceRange((ASTNode)assignment, "a[0]", source);
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((assignment.getFlags() & 8) != 0 ? 1 : 0) != 0);
        Expression rhs = assignment.getRightHandSide();
        ASTConverterRecoveryTest.assertTrue((String)"Not a simple name", (rhs.getNodeType() == 42 ? 1 : 0) != 0);
        SimpleName simpleName = (SimpleName)rhs;
        ASTConverterRecoveryTest.assertEquals((String)"Not length isn't correct", (int)0, (int)simpleName.getLength());
    }

    public void test0014() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    int[] = a[0];\n\t}\n}\n");
        char[] source = this.workingCopies[0].getSource().toCharArray();
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    int[] $missing$=a[0];\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
        Statement statement = (Statement)statements.get(0);
        ASTConverterRecoveryTest.assertTrue((String)"Not a variable declaration statement", (statement.getNodeType() == 60 ? 1 : 0) != 0);
        VariableDeclarationStatement variableDeclarationStatement = (VariableDeclarationStatement)statement;
        this.checkSourceRange((ASTNode)variableDeclarationStatement, "int[] = a[0];", source);
        ASTConverterRecoveryTest.assertTrue((String)"Not flag as RECOVERED", ((variableDeclarationStatement.getFlags() & 8) != 0 ? 1 : 0) != 0);
        List fragments = variableDeclarationStatement.fragments();
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)fragments.get(0);
        SimpleName simpleName = fragment.getName();
        ASTConverterRecoveryTest.assertEquals((String)"Not length isn't correct", (int)0, (int)simpleName.getLength());
    }

    public void test0015() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    assert 0 == 0 : a[0;\n\t}\n}\n");
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    assert 0 == 0 : a[0];\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0016() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    assert 0 == 0 : foo(;\n\t}\n}\n");
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    assert 0 == 0 : foo();\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }

    public void test0017() throws JavaScriptModelException {
        this.workingCopies = new IJavaScriptUnit[1];
        this.workingCopies[0] = this.getWorkingCopy("/Converter/src/test/X.js", "package test;\n\npublic class X {\n\tvoid foo() {\n\t    assert 0 == 0 : (\"aa\";\n\t}\n}\n");
        ASTNode result = this.runConversion(3, this.workingCopies[0], true, true);
        this.assertASTNodeEquals("package test;\npublic class X {\n  void foo(){\n    assert 0 == 0 : (\"aa\");\n  }\n}\n", result);
        ASTNode node = this.getASTNode((JavaScriptUnit)result, 0, 0);
        ASTConverterRecoveryTest.assertNotNull((Object)node);
        ASTConverterRecoveryTest.assertTrue((String)"Not a method declaration", (node.getNodeType() == 31 ? 1 : 0) != 0);
        FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((methodDeclaration.getFlags() & 8) == 0 ? 1 : 0) != 0);
        Block block = methodDeclaration.getBody();
        ASTConverterRecoveryTest.assertTrue((String)"Flag as RECOVERED", ((block.getFlags() & 8) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTConverterRecoveryTest.assertEquals((String)"wrong size", (int)1, (int)statements.size());
    }
}

