/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CompilationUnitTests
extends ModifyingResourceTests {
    IJavaScriptUnit cu;
    IJavaScriptUnit workingCopy;
    IJavaScriptProject testProject;
    static /* synthetic */ Class class$0;

    public CompilationUnitTests(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
        this.testProject = this.createJavaProject("P", new String[]{"src"}, new String[]{this.getSystemJsPathString()}, "bin", "1.5");
        this.createFolder("/P/src/p");
        this.createFile("/P/src/p/X.js", "\n\n/* some comment */  var f1=1;\n  /** @deprecated\n */  var f2;\n  var f3;\n  var f4;\n  var f5, f6, f7;\n  // @Deprecated\n  var f8;\n  function foo( y) {\n  }\n  function bar() {\n  }\n  /** @deprecated\n */  function fred() {\n  }\n  // @Deprecated\n  function fred2() {\n  }\n");
        this.cu = this.getCompilationUnit("/P/src/p/X.js");
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.model.CompilationUnitTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return CompilationUnitTests.buildModelTestSuite(clazz);
    }

    protected void tearDown() throws Exception {
        if (this.workingCopy != null) {
            this.workingCopy.discardWorkingCopy();
        }
        super.tearDown();
    }

    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
        super.tearDownSuite();
    }

    private IJavaScriptUnit createWorkingCopyComputingProblems(String source) throws JavaScriptModelException {
        this.workingCopy = this.getWorkingCopy("/P/src/p/Y.js", source, true);
        return this.workingCopy;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test00Class() throws CoreException {
        try {
            String source = "MyClass.prototype.someMethod = MyClass_someMethod;\nfunction MyClass()\n{\nthis.field1=0;\n}\nfunction MyClass_someMethod()\n{\n}";
            this.createFile("/P/src/X.js", source);
            IJavaScriptUnit compilationUnit = this.getCompilationUnit("/P/src/X.js");
            IType type = compilationUnit.getType("MyClass");
            CompilationUnitTests.assertTrue((String)"Type not defined", (boolean)type.exists());
            IField[] fields = type.getFields();
            CompilationUnitTests.assertEquals((String)"Wrong number of fields returned", (int)1, (int)fields.length);
            CompilationUnitTests.assertEquals((String)"Incorrect name for the  field", (String)"field1", (String)fields[0].getElementName());
            CompilationUnitTests.assertTrue((String)"Field should exist ", (boolean)fields[0].exists());
            IFunction[] methods = type.getFunctions();
            CompilationUnitTests.assertEquals((String)"Wrong number of methods returned", (int)2, (int)methods.length);
            CompilationUnitTests.assertEquals((String)"Incorrect name for the  method", (String)"someMethod", (String)methods[0].getElementName());
            CompilationUnitTests.assertTrue((String)"Field should exist ", (boolean)methods[0].exists());
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.deleteFile("/P/src/X.js");
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.deleteFile("/P/src/X.js");
    }

    public void testCodeCoverage() throws JavaScriptModelException {
        this.cu.discardWorkingCopy();
        this.cu.restore();
    }

    public void testCommitWorkingCopy() {
        try {
            this.cu.commitWorkingCopy(false, null);
        }
        catch (JavaScriptModelException jme) {
            CompilationUnitTests.assertTrue((String)"Incorrect status for committing a JavaScriptUnit", (jme.getStatus().getCode() == 967 ? 1 : 0) != 0);
            return;
        }
        CompilationUnitTests.assertTrue((String)"A compilation unit should throw an exception is a commit is attempted", (boolean)false);
    }

    public void testDeprecatedFlag03() throws JavaScriptModelException {
        IField field = this.cu.getField("f1");
        CompilationUnitTests.assertTrue((String)"Field f1 should not be deprecated", (!Flags.isDeprecated((int)field.getFlags()) ? 1 : 0) != 0);
    }

    public void testDeprecatedFlag04() throws JavaScriptModelException {
        IField field = this.cu.getField("f2");
        CompilationUnitTests.assertTrue((String)"Field f2 should be deprecated", (boolean)Flags.isDeprecated((int)field.getFlags()));
    }

    public void testDeprecatedFlag05() throws JavaScriptModelException {
        IFunction method = this.cu.getFunction("bar", new String[0]);
        CompilationUnitTests.assertTrue((String)"Method bar should not be deprecated", (!Flags.isDeprecated((int)method.getFlags()) ? 1 : 0) != 0);
    }

    public void testDeprecatedFlag06() throws JavaScriptModelException {
        IFunction method = this.cu.getFunction("fred", new String[0]);
        CompilationUnitTests.assertTrue((String)"Method fred should be deprecated", (boolean)Flags.isDeprecated((int)method.getFlags()));
    }

    public void testDeprecatedFlag07() throws JavaScriptModelException {
        IType type = this.cu.getType("I3");
        CompilationUnitTests.assertTrue((String)"Type I3 should be deprecated", (boolean)Flags.isDeprecated((int)type.getFlags()));
    }

    public void testDeprecatedFlag08() throws JavaScriptModelException {
        IField field = this.cu.getType("X").getField("f8");
        CompilationUnitTests.assertTrue((String)"Field f8 should be deprecated", (boolean)Flags.isDeprecated((int)field.getFlags()));
    }

    public void testDeprecatedFlag09() throws JavaScriptModelException {
        IFunction method = this.cu.getType("X").getFunction("fred2", new String[0]);
        CompilationUnitTests.assertTrue((String)"Method fred2 should be deprecated", (boolean)Flags.isDeprecated((int)method.getFlags()));
    }

    public void testGetCategories01() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\n/**\n * @category test\n */\npublic class Y {\n}");
        String[] categories = this.workingCopy.getType("Y").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories02() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\n/**\n * @category test\n */\npublic interface Y {\n}");
        String[] categories = this.workingCopy.getType("Y").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories03() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\n/**\n * @category test\n */\npublic enum Y {\n}");
        String[] categories = this.workingCopy.getType("Y").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories04() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\n/**\n * @category test\n */\npublic @interface Y {\n}");
        String[] categories = this.workingCopy.getType("Y").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories05() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories06() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test\n   */\n  public Y() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("Y", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories07() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test\n   */\n  int field;\n}");
        String[] categories = this.workingCopy.getType("Y").getField("field").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories08() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test\n   */\n  class Member {}\n}");
        String[] categories = this.workingCopy.getType("Y").getType("Member").getCategories();
        this.assertStringsEqual("Unexpected categories", "test\n", categories);
    }

    public void testGetCategories09() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n  */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetCategories10() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test1\n   * @category test2\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\n", categories);
    }

    public void testGetCategories11() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test1 test2\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\n", categories);
    }

    public void testGetCategories12() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test1 test2\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\ntest2\n", categories);
    }

    public void testGetCategories13() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category \t *\t\ttest\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetCategories14() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category\t *\t\ttest\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "", categories);
    }

    public void testGetCategories15() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test1\t *\t\ttest2\n   */\n  void foo() {}\n}");
        String[] categories = this.workingCopy.getType("Y").getFunction("foo", new String[0]).getCategories();
        this.assertStringsEqual("Unexpected categories", "test1\n", categories);
    }

    public void testGetChildrenForCategory01() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test\n   */\n  int field;\n  /**\n   * @category test\n   */\n  void foo1() {}\n  /**\n   * @category test\n   */\n  void foo2() {}\n  /**\n   * @category other\n   */\n  void foo3() {}\n}");
        IJavaScriptElement[] children = this.workingCopy.getType("Y").getChildrenForCategory("test");
        this.assertElementsEqual("Unexpected children", "field [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo1() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo2() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", children);
    }

    public void testGetChildrenForCategory02() throws CoreException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category test1 test2\n   */\n  class Member {}\n  /**\n   * @category test1\n   */\n  void foo1() {}\n  /**\n   * @category test2\n   */\n  void foo2() {}\n}");
        IJavaScriptElement[] children = this.workingCopy.getType("Y").getChildrenForCategory("test1");
        this.assertElementsEqual("Unexpected children", "Member [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo1() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", children);
    }

    public void testGetChildrenForCategory03() throws CoreException, IOException {
        this.createWorkingCopyComputingProblems("package p;\npublic class Y {\n  /**\n   * @category fields test all\n   */\n  int field;\n  /**\n   * @category methods test all\n   */\n  void foo1() {}\n  /**\n   * @category methods test all\n   */\n  void foo2() {}\n  /**\n   * @category methods other all\n   */\n  void foo3() {}\n}");
        IJavaScriptElement[] tests = this.workingCopy.getType("Y").getChildrenForCategory("test");
        this.assertElementsEqual("Unexpected children", "field [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo1() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo2() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", tests);
        IJavaScriptElement[] methods = this.workingCopy.getType("Y").getChildrenForCategory("methods");
        this.assertElementsEqual("Unexpected children", "foo1() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo2() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo3() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", methods);
        IJavaScriptElement[] others = this.workingCopy.getType("Y").getChildrenForCategory("other");
        this.assertElementsEqual("Unexpected children", "foo3() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", others);
        IJavaScriptElement[] all = this.workingCopy.getType("Y").getChildrenForCategory("all");
        this.assertElementsEqual("Unexpected children", "field [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo1() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo2() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]\nfoo3() [in Y [in [Working copy] Y.js [in p [in src [in P]]]]]", all);
    }

    public void testGetContentsForNotPresent() {
        CompilationUnit compilationUnit = (CompilationUnit)this.getCompilationUnit("/P/src/p/Absent.js");
        this.assertSourceEquals("Unexpected contents for non present cu", "", new String(compilationUnit.getContents()));
    }

    public void testGetElementAt() throws JavaScriptModelException {
        IField field = this.cu.getField("f2");
        ISourceRange sourceRange = field.getSourceRange();
        IJavaScriptElement element = this.cu.getElementAt(sourceRange.getOffset() + field.getElementName().length() + 1);
        CompilationUnitTests.assertTrue((String)"Should have found a type", (boolean)(element instanceof IField));
        CompilationUnitTests.assertEquals((String)"Should have found f2", (String)"f2", (String)element.getElementName());
        element = this.cu.getElementAt(this.cu.getSourceRange().getOffset() + 1);
        CompilationUnitTests.assertEquals((String)"Should have not found any element", null, (Object)element);
    }

    public void testGetElementAt3() throws JavaScriptModelException {
        int fieldPos = this.cu.getSource().indexOf("f5");
        IJavaScriptElement element = this.cu.getElementAt(fieldPos);
        CompilationUnitTests.assertEquals((String)"Unexpected field found", (Object)this.cu.getField("f5"), (Object)element);
    }

    public void testGetElementAt4() throws JavaScriptModelException {
        int fieldPos = this.cu.getSource().indexOf("f6");
        IJavaScriptElement element = this.cu.getElementAt(fieldPos);
        CompilationUnitTests.assertEquals((String)"Unexpected field found", (Object)this.cu.getField("f6"), (Object)element);
    }

    public void testGetElementAt5() throws JavaScriptModelException {
        int fieldPos = this.cu.getSource().indexOf("f7");
        IJavaScriptElement element = this.cu.getElementAt(fieldPos);
        CompilationUnitTests.assertEquals((String)"Unexpected field found", (Object)this.cu.getField("f7"), (Object)element);
    }

    public void testGetElementAt6() throws JavaScriptModelException {
        int fieldPos = this.cu.getSource().indexOf("var f5");
        IJavaScriptElement element = this.cu.getElementAt(fieldPos);
        CompilationUnitTests.assertEquals((String)"Unexpected field found", (Object)this.cu.getField("f5"), (Object)element);
    }

    public void testGetFields() throws JavaScriptModelException {
        IField[] fields = this.cu.getFields();
        String[] fieldNames = new String[]{"f1", "f2", "f3", "f4", "f5", "f6", "f7", "f8"};
        String[] stringArray = new String[]{"public", "protected", "private", "", "", "", "", ""};
        String[] stringArray2 = new String[]{"I", "QObject;", "QX;", "Qjava.lang.String;", "I", "I", "I", "I"};
        CompilationUnitTests.assertEquals((String)"Wrong number of fields returned", (int)fieldNames.length, (int)fields.length);
        int i = 0;
        while (i < fields.length) {
            CompilationUnitTests.assertEquals((String)("Incorrect name for the " + i + " field"), (String)fieldNames[i], (String)fields[i].getElementName());
            CompilationUnitTests.assertTrue((String)("Field should exist " + fields[i]), (boolean)fields[i].exists());
            ++i;
        }
    }

    public void testGetKey1() {
        IField type = this.cu.getField("f2");
        CompilationUnitTests.assertEquals((String)"Up/X.js;.f2", (String)type.getKey());
    }

    public void testGetKey2() {
        IType type = this.cu.getType("X").getType("Inner");
        CompilationUnitTests.assertEquals((String)"Lp/X$Inner;", (String)type.getKey());
    }

    public void testGetKey3() {
        IType type = this.cu.getType("I");
        CompilationUnitTests.assertEquals((String)"Lp/X~I;", (String)type.getKey());
    }

    public void testGetKey4() {
        IType type = this.cu.getType("X").getFunction("foo", new String[0]).getType("", 1);
        CompilationUnitTests.assertEquals((String)"Lp/X$1;", (String)type.getKey());
    }

    public void testGetMethod1() throws JavaScriptModelException {
        IFunction foo = this.cu.getFunction("foo", new String[1]);
        String[] parameterNames = foo.getParameterNames();
        CompilationUnitTests.assertEquals((String)"Wrong number of parameter names", (int)1, (int)parameterNames.length);
        CompilationUnitTests.assertEquals((String)"Unexpected parameter name", (String)"y", (String)parameterNames[0]);
    }

    public void testGetMethods() throws JavaScriptModelException {
        IFunction[] methods = this.cu.getFunctions();
        String[] methodNames = new String[]{"foo", "bar", "fred", "fred2"};
        String[] stringArray = new String[]{"public", "protected static", "private", "private"};
        CompilationUnitTests.assertEquals((String)"Wrong number of methods returned", (int)methodNames.length, (int)methods.length);
        int i = 0;
        while (i < methods.length) {
            CompilationUnitTests.assertEquals((String)("Incorrect name for the " + i + " method"), (String)methodNames[i], (String)methods[i].getElementName());
            methods[i].getFlags();
            CompilationUnitTests.assertTrue((String)("Method does not exist " + methods[i]), (boolean)methods[i].exists());
            ++i;
        }
    }

    public void testGetPrimary() {
        IJavaScriptElement primary = this.cu.getPrimaryElement();
        CompilationUnitTests.assertEquals((String)"Primary element for a compilation unit should be the same", (Object)this.cu, (Object)primary);
        primary = this.cu.getPrimary();
        CompilationUnitTests.assertEquals((String)"Primary for a compilation unit should be the same", (Object)this.cu, (Object)primary);
    }

    public void testGetType() {
        IField type = this.cu.getField("someType");
        CompilationUnitTests.assertTrue((String)("Type should not exist " + type), (!type.exists() ? 1 : 0) != 0);
        type = this.cu.getField("f2");
        CompilationUnitTests.assertTrue((String)("Type should exist " + type), (boolean)type.exists());
    }

    public void testHasChildren() throws JavaScriptModelException {
        this.cu.close();
        CompilationUnitTests.assertTrue((String)"A closed compilation unit should have children", (boolean)this.cu.hasChildren());
        this.cu.getChildren();
        CompilationUnitTests.assertTrue((String)"The compilation unit should have children", (boolean)this.cu.hasChildren());
    }

    public void testHasResourceChanged() {
        CompilationUnitTests.assertTrue((String)"A compilation unit's resource should not have changed", (!this.cu.hasResourceChanged() ? 1 : 0) != 0);
    }

    public void testNameWithoutJavaLikeExtension() {
        String name = Util.getNameWithoutJavaLikeExtension((String)"Test.aj");
        CompilationUnitTests.assertEquals((String)"Unepected name without extension", (String)"Test.aj", (String)name);
    }

    public void testNotPresent1() {
        IJavaScriptUnit compilationUnit = ((IPackageFragment)this.cu.getParent()).getJavaScriptUnit("DoesNotExist.js");
        CompilationUnitTests.assertTrue((String)"CU should not be open", (!compilationUnit.isOpen() ? 1 : 0) != 0);
        CompilationUnitTests.assertTrue((String)"CU should not exist", (!compilationUnit.exists() ? 1 : 0) != 0);
        CompilationUnitTests.assertTrue((String)"CU should still not be open", (!compilationUnit.isOpen() ? 1 : 0) != 0);
    }

    public void testPackageDefaultFlag1() throws JavaScriptModelException {
        IField field = this.cu.getField("f4");
        CompilationUnitTests.assertTrue((String)"X#f4 should be package default", (boolean)Flags.isPackageDefault((int)field.getFlags()));
    }

    public void testPackageDefaultFlag3() throws JavaScriptModelException {
        IField field = this.cu.getType("X").getField("f2");
        CompilationUnitTests.assertTrue((String)"X#f2 should not be package default", (!Flags.isPackageDefault((int)field.getFlags()) ? 1 : 0) != 0);
    }

    public void testPackageDefaultFlag4() throws JavaScriptModelException {
        IType type = this.cu.getType("I");
        CompilationUnitTests.assertTrue((String)"X should be package default", (boolean)Flags.isPackageDefault((int)type.getFlags()));
    }

    public void testStructureKnownForCU() throws JavaScriptModelException {
        CompilationUnitTests.assertTrue((String)"Structure is unknown for valid CU", (boolean)this.cu.isStructureKnown());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testStructureUnknownForCU() throws CoreException {
        try {
            this.createFile("/P/src/p/Invalid.js", "@#D(03");
            IJavaScriptUnit badCU = this.getCompilationUnit("/P/src/p/Invalid.js");
            CompilationUnitTests.assertTrue((String)"Structure is known for an invalid CU", (!badCU.isStructureKnown() ? 1 : 0) != 0);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.deleteFile("/P/src/p/Invalid.js");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.deleteFile("/P/src/p/Invalid.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test110172() throws CoreException {
        try {
            String source = "\t /**\n\t  * Javadoc for field f \n\t  */\n\tvar f;\n\t\n\t/**\n\t * Javadoc for method foo\n\t */\n\tfunction foo( i,  l,  s) {\n\t}\n\t\n\t/**\n\t * Javadoc for member type A\n\t */\n\t\n\t/**\n\t * Javadoc for f3\n\t */\n\t/*\n\t * Not a javadoc comment\n\t */\n\t/**\n\t * Real javadoc for f3\n\t */\n\tvar f3;\n\t\n\tvar f2;\n\t\n\tfunction foo2() {\n\t}\n\t\n\n";
            this.createFile("/P/src/X.js", source);
            IJavaScriptElement[] members = this.getCompilationUnit("/P/src/X.js").getChildren();
            int length = members.length;
            CompilationUnitTests.assertEquals((String)"Wrong number", (int)5, (int)length);
            int i = 0;
            while (i < length) {
                String javadocSource;
                int start;
                int end;
                IJavaScriptElement element = members[i];
                CompilationUnitTests.assertTrue((boolean)(element instanceof IMember));
                ISourceRange javadocRange = ((IMember)element).getJSdocRange();
                String elementName = element.getElementName();
                if ("f".equals(elementName)) {
                    CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start2 = javadocRange.getOffset();
                    end = javadocRange.getLength() + start2 - 1;
                    String javadocSource2 = source.substring(start2, end);
                    CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource2.indexOf("field f") != -1 ? 1 : 0) != 0);
                } else if ("foo".equals(elementName)) {
                    CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start3 = javadocRange.getOffset();
                    end = javadocRange.getLength() + start3 - 1;
                    String javadocSource3 = source.substring(start3, end);
                    CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource3.indexOf("method foo") != -1 ? 1 : 0) != 0);
                } else if ("A".equals(elementName)) {
                    CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start4 = javadocRange.getOffset();
                    end = javadocRange.getLength() + start4 - 1;
                    String javadocSource4 = source.substring(start4, end);
                    CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource4.indexOf("member type A") != -1 ? 1 : 0) != 0);
                } else if ("X".equals(elementName)) {
                    CompilationUnitTests.assertTrue((String)"Not an IFunction", (boolean)(element instanceof IFunction));
                    IFunction method = (IFunction)element;
                    switch (method.getNumberOfParameters()) {
                        case 0: {
                            CompilationUnitTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                            break;
                        }
                        case 1: {
                            CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                            start = javadocRange.getOffset();
                            int end2 = javadocRange.getLength() + start - 1;
                            javadocSource = source.substring(start, end2);
                            CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("constructor") != -1 ? 1 : 0) != 0);
                        }
                    }
                } else if ("f3".equals(elementName)) {
                    CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                    int start5 = javadocRange.getOffset();
                    end = javadocRange.getLength() + start5 - 1;
                    String javadocSource5 = source.substring(start5, end);
                    CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource5.indexOf("Real") != -1 ? 1 : 0) != 0);
                } else if ("f2".equals(elementName)) {
                    CompilationUnitTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                } else if ("foo2".equals(elementName)) {
                    CompilationUnitTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                } else if ("B".equals(elementName)) {
                    CompilationUnitTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                } else if (element instanceof IInitializer) {
                    IInitializer initializer = (IInitializer)element;
                    if (Flags.isStatic((int)initializer.getFlags())) {
                        CompilationUnitTests.assertNotNull((String)"No javadoc source range", (Object)javadocRange);
                        start = javadocRange.getOffset();
                        int end3 = javadocRange.getLength() + start - 1;
                        javadocSource = source.substring(start, end3);
                        CompilationUnitTests.assertTrue((String)"Wrong javadoc", (javadocSource.indexOf("initializer") != -1 ? 1 : 0) != 0);
                    } else {
                        CompilationUnitTests.assertNull((String)"Has a javadoc source range", (Object)javadocRange);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var12_23 = null;
            this.deleteFile("/P/src/X.js");
            throw throwable;
        }
        {
            Object var12_24 = null;
        }
        this.deleteFile("/P/src/X.js");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test120902() throws CoreException {
        try {
            String source = "/**\r\n * Toy\r\n */\r\nfunction foo() {\r\n}";
            this.createFile("/P/src/X.js", source);
            IJavaScriptUnit compilationUnit = this.getCompilationUnit("/P/src/X.js");
            IFunction type = compilationUnit.getFunction("foo", null);
            ISourceRange javadocRange = type.getJSdocRange();
            CompilationUnitTests.assertNotNull((String)"No source range", (Object)javadocRange);
            compilationUnit.getBuffer().setContents("");
            try {
                javadocRange = type.getJSdocRange();
                CompilationUnitTests.assertNull((String)"Got a source range", (Object)javadocRange);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                CompilationUnitTests.assertFalse((String)"Should not happen", (boolean)true);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.deleteFile("/P/src/X.js");
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.deleteFile("/P/src/X.js");
    }
}

