/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BooleanLiteral;
import org.eclipse.wst.jsdt.core.dom.BreakStatement;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ContinueStatement;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.LabeledStatement;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.NumberLiteral;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.tests.model.SuiteOfTestCases;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest;

public class ASTRewritingStatementsTest
extends ASTRewritingTest {
    private static final Class THIS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingStatementsTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        THIS = clazz;
    }

    public ASTRewritingStatementsTest(String name) {
        super(name);
    }

    public static Test allTests() {
        return new SuiteOfTestCases.Suite(THIS);
    }

    public static Test setUpTest(Test someTest) {
        SuiteOfTestCases.Suite suite = new SuiteOfTestCases.Suite("one test");
        suite.addTest(someTest);
        return suite;
    }

    public static Test suite() {
        return ASTRewritingStatementsTest.buildModelTestSuite(THIS);
    }

    public void testInsert1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function C() {\n");
        buf.append("    function foo() {\n");
        buf.append("        if (this.equals(new Object())) {\n");
        buf.append("            toString();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        FunctionDeclaration methodDec2 = (FunctionDeclaration)methodDecl.getBody().statements().get(0);
        Block block = methodDec2.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        ReturnStatement returnStatement = block.getAST().newReturnStatement();
        returnStatement.setExpression((Expression)block.getAST().newNullLiteral());
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function C() {\n");
        buf.append("    function foo() {\n");
        buf.append("        if (this.equals(new Object())) {\n");
        buf.append("            toString();\n");
        buf.append("        }\n");
        buf.append("        return null;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function D() {\n");
        buf.append("    function goo() {\n");
        buf.append("        Number i= new Number(3);\n");
        buf.append("    }\n");
        buf.append("    function hoo(p1, p2) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("D.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        FunctionDeclaration methodDeclGoo = (FunctionDeclaration)methodDecl.getBody().statements().get(0);
        List bodyStatements = methodDeclGoo.getBody().statements();
        ASTNode copy = rewrite.createCopyTarget((ASTNode)bodyStatements.get(0));
        FunctionDeclaration methodDeclHoo = (FunctionDeclaration)methodDecl.getBody().statements().get(1);
        Block block = methodDeclHoo.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"No statements in block", (!statements.isEmpty() ? 1 : 0) != 0);
        ASTRewritingStatementsTest.assertTrue((String)"No ReturnStatement", (boolean)(statements.get(0) instanceof ReturnStatement));
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertFirst(copy, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function D() {\n");
        buf.append("    function goo() {\n");
        buf.append("        Number i= new Number(3);\n");
        buf.append("    }\n");
        buf.append("    function hoo(p1, p2) {\n");
        buf.append("        Number i= new Number(3);\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testInsert3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        i++; //comment\n");
        buf.append("        i++; //comment\n");
        buf.append("        return new Integer(3);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        AST ast = astRoot.getAST();
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "goo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        FunctionInvocation invocation1 = ast.newFunctionInvocation();
        invocation1.setName(ast.newSimpleName("foo"));
        ExpressionStatement statement1 = ast.newExpressionStatement((Expression)invocation1);
        FunctionInvocation invocation2 = ast.newFunctionInvocation();
        invocation2.setName(ast.newSimpleName("foo"));
        ExpressionStatement statement2 = ast.newExpressionStatement((Expression)invocation2);
        List statements = methodDecl.getBody().statements();
        ASTNode second = (ASTNode)statements.get(1);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodDecl.getBody(), Block.STATEMENTS_PROPERTY);
        listRewrite.remove(second, null);
        listRewrite.insertBefore((ASTNode)statement1, second, null);
        listRewrite.insertAfter((ASTNode)statement2, second, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        i++; //comment\n");
        buf.append("        foo();\n");
        buf.append("        foo();\n");
        buf.append("        return new Integer(3);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public Object foo() {\n");
        buf.append("        if (this.equals(new Object())) {\n");
        buf.append("            toString();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "C");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"No statements in block", (!statements.isEmpty() ? 1 : 0) != 0);
        rewrite.remove((ASTNode)statements.get(0), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public Object foo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class D {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        return new Integer(3);\n");
        buf.append("    }\n");
        buf.append("    public void hoo(int p1, Object p2) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("D.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "D");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "goo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"No statements in block", (!statements.isEmpty() ? 1 : 0) != 0);
        ASTRewritingStatementsTest.assertTrue((String)"No ReturnStatement", (boolean)(statements.get(0) instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        Expression expr = returnStatement.getExpression();
        rewrite.remove((ASTNode)expr, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class D {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("    public void hoo(int p1, Object p2) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testRemove3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        i++; //comment\n");
        buf.append("        i++; //comment\n");
        buf.append("        return new Integer(3);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "goo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = methodDecl.getBody().statements();
        rewrite.remove((ASTNode)statements.get(0), null);
        rewrite.remove((ASTNode)statements.get(1), null);
        rewrite.remove((ASTNode)statements.get(2), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public Object goo() {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testReplace1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public Object foo() {\n");
        buf.append("        if (this.equals(new Object())) {\n");
        buf.append("            toString();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("C.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "C");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"No statements in block", (!statements.isEmpty() ? 1 : 0) != 0);
        ReturnStatement returnStatement = block.getAST().newReturnStatement();
        rewrite.replace((ASTNode)statements.get(0), (ASTNode)returnStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class C {\n");
        buf.append("    public Object foo() {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testReplace2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class D {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        return new Integer(3);\n");
        buf.append("    }\n");
        buf.append("    public void hoo(int p1, Object p2) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("D.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "D");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "goo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"No block", (block != null ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"No statements in block", (!statements.isEmpty() ? 1 : 0) != 0);
        ASTRewritingStatementsTest.assertTrue((String)"No ReturnStatement", (boolean)(statements.get(0) instanceof ReturnStatement));
        ReturnStatement returnStatement = (ReturnStatement)statements.get(0);
        Expression expr = returnStatement.getExpression();
        NullLiteral modified = block.getAST().newNullLiteral();
        rewrite.replace((ASTNode)expr, (ASTNode)modified, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class D {\n");
        buf.append("    public Object goo() {\n");
        buf.append("        return null;\n");
        buf.append("    }\n");
        buf.append("    public void hoo(int p1, Object p2) {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testBreakStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    break;\n");
        buf.append("    break label;\n");
        buf.append("    break label;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        BreakStatement statement = (BreakStatement)statements.get(0);
        ASTRewritingStatementsTest.assertTrue((String)"Has label", (statement.getLabel() == null ? 1 : 0) != 0);
        SimpleName newLabel = ast.newSimpleName("label2");
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)BreakStatement.LABEL_PROPERTY, (Object)newLabel, null);
        statement = (BreakStatement)statements.get(1);
        SimpleName label = statement.getLabel();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (label != null ? 1 : 0) != 0);
        SimpleName newLabel2 = ast.newSimpleName("label2");
        rewrite.replace((ASTNode)label, (ASTNode)newLabel2, null);
        statement = (BreakStatement)statements.get(2);
        label = statement.getLabel();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (label != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)label, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    break label2;\n");
        buf.append("    break label2;\n");
        buf.append("    break;\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testContinueStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    continue;\n");
        buf.append("    continue label;\n");
        buf.append("    continue label;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        ContinueStatement statement = (ContinueStatement)statements.get(0);
        ASTRewritingStatementsTest.assertTrue((String)"Has label", (statement.getLabel() == null ? 1 : 0) != 0);
        SimpleName newLabel = ast.newSimpleName("label2");
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)ContinueStatement.LABEL_PROPERTY, (Object)newLabel, null);
        statement = (ContinueStatement)statements.get(1);
        SimpleName label = statement.getLabel();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (label != null ? 1 : 0) != 0);
        SimpleName newLabel2 = ast.newSimpleName("label2");
        rewrite.replace((ASTNode)label, (ASTNode)newLabel2, null);
        statement = (ContinueStatement)statements.get(2);
        label = statement.getLabel();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (label != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)label, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    continue label2;\n");
        buf.append("    continue label2;\n");
        buf.append("    continue;\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testDoStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    do {\n");
        buf.append("        System.beep();\n");
        buf.append("    } while (i == j);\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        DoStatement doStatement = (DoStatement)statements.get(0);
        Block newBody = ast.newBlock();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)doStatement.getBody(), (ASTNode)newBody, null);
        BooleanLiteral literal = ast.newBooleanLiteral(true);
        rewrite.replace((ASTNode)doStatement.getExpression(), (ASTNode)literal, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    do {\n");
        buf.append("        hoo(11);\n");
        buf.append("    } while (true);\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testDoStatement1() throws Exception {
    }

    public void testExpressionStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        i= 0;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ExpressionStatement stmt = (ExpressionStatement)statements.get(0);
        Assignment assignment = (Assignment)stmt.getExpression();
        Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment);
        Assignment newExpression = ast.newAssignment();
        newExpression.setLeftHandSide((Expression)ast.newSimpleName("x"));
        newExpression.setRightHandSide(placeholder);
        newExpression.setOperator(Assignment.Operator.ASSIGN);
        rewrite.replace((ASTNode)stmt.getExpression(), (ASTNode)newExpression, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        x = i= 0;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testForStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (int i= 0; i < len; i++) {\n");
        buf.append("        }\n");
        buf.append("        for (i= 0, j= 0; i < len; i++, j++) {\n");
        buf.append("        }\n");
        buf.append("        for (;;) {\n");
        buf.append("        }\n");
        buf.append("        for (;;) {\n");
        buf.append("        }\n");
        buf.append("        for (i= 0; i < len; i++) {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 5", (statements.size() == 5 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)statements.get(0);
        List initializers = forStatement.initializers();
        ASTRewritingStatementsTest.assertTrue((String)"Number of initializers not 1", (initializers.size() == 1 ? 1 : 0) != 0);
        Assignment assignment = ast.newAssignment();
        assignment.setLeftHandSide((Expression)ast.newSimpleName("i"));
        assignment.setOperator(Assignment.Operator.ASSIGN);
        assignment.setRightHandSide((Expression)ast.newNumberLiteral("3"));
        rewrite.replace((ASTNode)initializers.get(0), (ASTNode)assignment, null);
        Assignment assignment2 = ast.newAssignment();
        assignment2.setLeftHandSide((Expression)ast.newSimpleName("j"));
        assignment2.setOperator(Assignment.Operator.ASSIGN);
        assignment2.setRightHandSide((Expression)ast.newNumberLiteral("4"));
        rewrite.getListRewrite((ASTNode)forStatement, ForStatement.INITIALIZERS_PROPERTY).insertLast((ASTNode)assignment2, null);
        BooleanLiteral literal = ast.newBooleanLiteral(true);
        rewrite.replace((ASTNode)forStatement.getExpression(), (ASTNode)literal, null);
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperand((Expression)ast.newSimpleName("j"));
        prefixExpression.setOperator(PrefixExpression.Operator.INCREMENT);
        rewrite.getListRewrite((ASTNode)forStatement, ForStatement.UPDATERS_PROPERTY).insertLast((ASTNode)prefixExpression, null);
        Block newBody = ast.newBlock();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)forStatement.getBody(), (ASTNode)newBody, null);
        forStatement = (ForStatement)statements.get(1);
        initializers = forStatement.initializers();
        ASTRewritingStatementsTest.assertTrue((String)"Number of initializers not 2", (initializers.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)initializers.get(0), null);
        rewrite.remove((ASTNode)initializers.get(1), null);
        rewrite.remove((ASTNode)forStatement.getExpression(), null);
        List updaters = forStatement.updaters();
        ASTRewritingStatementsTest.assertTrue((String)"Number of initializers not 2", (updaters.size() == 2 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)updaters.get(0), null);
        rewrite.remove((ASTNode)updaters.get(1), null);
        forStatement = (ForStatement)statements.get(2);
        PrefixExpression prefixExpression2 = ast.newPrefixExpression();
        prefixExpression2.setOperand((Expression)ast.newSimpleName("j"));
        prefixExpression2.setOperator(PrefixExpression.Operator.INCREMENT);
        rewrite.getListRewrite((ASTNode)forStatement, ForStatement.UPDATERS_PROPERTY).insertLast((ASTNode)prefixExpression2, null);
        forStatement = (ForStatement)statements.get(3);
        Assignment assignment3 = ast.newAssignment();
        assignment3.setLeftHandSide((Expression)ast.newSimpleName("j"));
        assignment3.setOperator(Assignment.Operator.ASSIGN);
        assignment3.setRightHandSide((Expression)ast.newNumberLiteral("3"));
        rewrite.getListRewrite((ASTNode)forStatement, ForStatement.INITIALIZERS_PROPERTY).insertLast((ASTNode)assignment3, null);
        PrefixExpression prefixExpression3 = ast.newPrefixExpression();
        prefixExpression3.setOperand((Expression)ast.newSimpleName("j"));
        prefixExpression3.setOperator(PrefixExpression.Operator.INCREMENT);
        rewrite.getListRewrite((ASTNode)forStatement, ForStatement.UPDATERS_PROPERTY).insertLast((ASTNode)prefixExpression3, null);
        forStatement = (ForStatement)statements.get(4);
        assignment3 = (Assignment)forStatement.initializers().get(0);
        SimpleName leftHandSide = (SimpleName)assignment3.getLeftHandSide();
        VariableDeclarationFragment varFragment = ast.newVariableDeclarationFragment();
        VariableDeclarationExpression varDecl = ast.newVariableDeclarationExpression(varFragment);
        varFragment.setName(ast.newSimpleName(leftHandSide.getIdentifier()));
        Expression placeholder = (Expression)rewrite.createCopyTarget((ASTNode)assignment3.getRightHandSide());
        varFragment.setInitializer(placeholder);
        varDecl.setType((Type)ast.newPrimitiveType(PrimitiveType.INT));
        rewrite.replace((ASTNode)assignment3, (ASTNode)varDecl, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (i = 3, j = 4; true; i++, ++j) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        for (;;) {\n");
        buf.append("        }\n");
        buf.append("        for (;;++j) {\n");
        buf.append("        }\n");
        buf.append("        for (j = 3;;++j) {\n");
        buf.append("        }\n");
        buf.append("        for (int i = 0; i < len; i++) {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testForStatement1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (;;) {\n");
        buf.append("            foo();\n");
        buf.append("        }\n");
        buf.append("        for (;;)\n");
        buf.append("            foo();\n");
        buf.append("        for (;;) {\n");
        buf.append("            foo();\n");
        buf.append("        }\n");
        buf.append("        for (;;)\n");
        buf.append("            foo();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)statements.get(0);
        TryStatement newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        CatchClause newCatchClause = ast.newCatchClause();
        SingleVariableDeclaration varDecl = ast.newSingleVariableDeclaration();
        varDecl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Exception")));
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)forStatement.getBody(), (ASTNode)newTry, null);
        forStatement = (ForStatement)statements.get(1);
        Block newBody = ast.newBlock();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)forStatement.getBody(), (ASTNode)newBody, null);
        forStatement = (ForStatement)statements.get(2);
        newBody = ast.newBlock();
        invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)forStatement.getBody(), (ASTNode)newBody, null);
        forStatement = (ForStatement)statements.get(3);
        newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        newCatchClause = ast.newCatchClause();
        varDecl = ast.newSingleVariableDeclaration();
        varDecl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Exception")));
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)forStatement.getBody(), (ASTNode)newTry, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (;;)\n");
        buf.append("            try {\n");
        buf.append("                return;\n");
        buf.append("            } catch (Exception e) {\n");
        buf.append("            }\n");
        buf.append("        for (;;) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        for (;;) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        for (;;)\n");
        buf.append("            try {\n");
        buf.append("                return;\n");
        buf.append("            } catch (Exception e) {\n");
        buf.append("            }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testForStatement2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (;;) {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ForStatement forStatement = (ForStatement)statements.get(0);
        ForStatement newForStatement = ast.newForStatement();
        List initializers = newForStatement.initializers();
        Assignment init1 = ast.newAssignment();
        init1.setLeftHandSide((Expression)ast.newSimpleName("x"));
        init1.setRightHandSide((Expression)ast.newNumberLiteral("1"));
        initializers.add(init1);
        Assignment init2 = ast.newAssignment();
        init2.setLeftHandSide((Expression)ast.newSimpleName("y"));
        init2.setRightHandSide((Expression)ast.newNumberLiteral("10"));
        initializers.add(init2);
        InfixExpression expression = ast.newInfixExpression();
        expression.setOperator(InfixExpression.Operator.LESS);
        expression.setRightOperand((Expression)ast.newSimpleName("y"));
        expression.setLeftOperand((Expression)ast.newSimpleName("x"));
        newForStatement.setExpression((Expression)expression);
        List updaters = newForStatement.updaters();
        PrefixExpression upd1 = ast.newPrefixExpression();
        upd1.setOperator(PrefixExpression.Operator.INCREMENT);
        upd1.setOperand((Expression)ast.newSimpleName("x"));
        updaters.add(upd1);
        PrefixExpression upd2 = ast.newPrefixExpression();
        upd2.setOperator(PrefixExpression.Operator.DECREMENT);
        upd2.setOperand((Expression)ast.newSimpleName("y"));
        updaters.add(upd2);
        newForStatement.setBody((Statement)ast.newBlock());
        rewrite.replace((ASTNode)forStatement, (ASTNode)newForStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        for (x = 1, y = 10; x < y; ++x, --y) {\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    } else {\n");
        buf.append("    }\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 2", (statements.size() == 2 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        BooleanLiteral literal = ast.newBooleanLiteral(true);
        rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)literal, null);
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        Block newBody = ast.newBlock();
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        ifStatement = (IfStatement)statements.get(1);
        FunctionInvocation invocation2 = ast.newFunctionInvocation();
        invocation2.setName(ast.newSimpleName("hoo"));
        invocation2.arguments().add(ast.newNumberLiteral("11"));
        Block newBody2 = ast.newBlock();
        newBody2.statements().add(ast.newExpressionStatement((Expression)invocation2));
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newBody2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    if (true) {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    } else {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    } else {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("    if (i == 0) {\n");
        buf.append("        System.beep();\n");
        buf.append("    } else\n");
        buf.append("        hoo(11);\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 5", (statements.size() == 3 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block body = (Block)ifStatement.getThenStatement();
        ASTNode statement = (ASTNode)body.statements().get(0);
        ASTNode newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        ifStatement = (IfStatement)statements.get(1);
        body = (Block)ifStatement.getThenStatement();
        statement = (ASTNode)body.statements().get(0);
        newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        ifStatement = (IfStatement)statements.get(2);
        body = (Block)ifStatement.getThenStatement();
        statement = (ASTNode)body.statements().get(0);
        newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    if (i == 0)\n");
        buf.append("        System.beep();\n");
        buf.append("    if (i == 0)\n");
        buf.append("        System.beep();\n");
        buf.append("    else {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("    if (i == 0)\n");
        buf.append("        System.beep();\n");
        buf.append("    else\n");
        buf.append("        hoo(11);\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block body = (Block)ifStatement.getThenStatement();
        ASTNode statement = (ASTNode)body.statements().get(0);
        ASTNode newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        ReturnStatement returnStatement = ast.newReturnStatement();
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)returnStatement, null);
        ifStatement = (IfStatement)statements.get(1);
        body = (Block)ifStatement.getThenStatement();
        statement = (ASTNode)body.statements().get(0);
        newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        ifStatement = (IfStatement)statements.get(2);
        body = (Block)ifStatement.getThenStatement();
        statement = (ASTNode)body.statements().get(0);
        newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        Block newElseBlock = ast.newBlock();
        ReturnStatement returnStatement2 = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement2);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(3);
        body = (Block)ifStatement.getThenStatement();
        statement = (ASTNode)body.statements().get(0);
        newBody = rewrite.createMoveTarget(statement);
        rewrite.replace((ASTNode)body, newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 3", (statements.size() == 3 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        ASTNode placeholder = rewrite.createMoveTarget((ASTNode)statement);
        Block newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        ifStatement = (IfStatement)statements.get(1);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        ASTNode placeholder = rewrite.createMoveTarget((ASTNode)statement);
        Block newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        ReturnStatement returnStatement = ast.newReturnStatement();
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)returnStatement, null);
        ifStatement = (IfStatement)statements.get(1);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        Block newElseBlock = ast.newBlock();
        ReturnStatement returnStatement2 = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement2);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(3);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement5() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true)\n");
        buf.append("            hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        ASTNode placeholder = rewrite.createMoveTarget((ASTNode)statement);
        Block newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        IfStatement newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        Block newBody2 = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        newBody2.statements().add(returnStatement);
        newElseBlock.setThenStatement((Statement)newBody2);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(1);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        ReturnStatement returnStatement2 = ast.newReturnStatement();
        newElseBlock.setThenStatement((Statement)returnStatement2);
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(3);
        statement = ifStatement.getThenStatement();
        placeholder = rewrite.createMoveTarget((ASTNode)statement);
        newBody = ast.newBlock();
        newBody.statements().add(placeholder);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        rewrite.remove((ASTNode)ifStatement.getElseStatement(), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true) {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true)\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement6() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 2", (statements.size() == 2 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        TryStatement newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        CatchClause newCatchClause = ast.newCatchClause();
        SingleVariableDeclaration varDecl = ast.newSingleVariableDeclaration();
        varDecl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Exception")));
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)newTry, null);
        ifStatement = (IfStatement)statements.get(1);
        newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        newCatchClause = ast.newCatchClause();
        varDecl = ast.newSingleVariableDeclaration();
        varDecl.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("Exception")));
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)newTry, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            try {\n");
        buf.append("                return;\n");
        buf.append("            } catch (Exception e) {\n");
        buf.append("            }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            try {\n");
        buf.append("                return;\n");
        buf.append("            } catch (Exception e) {\n");
        buf.append("            }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatement_bug48988() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    void doit() {\n");
        buf.append("        int var;\n");
        buf.append("        if (true)\n");
        buf.append("            var = 17;\n");
        buf.append("        else if (var == 18)\n");
        buf.append("            if (1 < var && var < 17)\n");
        buf.append("                var = 1;\n");
        buf.append("            else\n");
        buf.append("                var++;\n");
        buf.append("        else\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        TypeDeclaration typeDecl = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methDecl = ASTRewritingStatementsTest.findMethodDeclaration(typeDecl, "doit");
        IfStatement outerIf = (IfStatement)methDecl.getBody().statements().get(1);
        Statement node = ((IfStatement)outerIf.getElseStatement()).getThenStatement();
        ASTRewritingStatementsTest.assertTrue((boolean)(node instanceof IfStatement));
        IfStatement ifStatement = (IfStatement)node;
        ASTNode placeholder = rewrite.createMoveTarget((ASTNode)ifStatement);
        Block newBlock = ast.newBlock();
        newBlock.statements().add(placeholder);
        rewrite.replace((ASTNode)ifStatement, (ASTNode)newBlock, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    void doit() {\n");
        buf.append("        int var;\n");
        buf.append("        if (true)\n");
        buf.append("            var = 17;\n");
        buf.append("        else if (var == 18) {\n");
        buf.append("            if (1 < var && var < 17)\n");
        buf.append("                var = 1;\n");
        buf.append("            else\n");
        buf.append("                var++;\n");
        buf.append("        } else\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatementReplaceElse1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Block newElseBlock = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(1);
        newElseBlock = ast.newBlock();
        returnStatement = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(2);
        ReturnStatement returnStatement2 = ast.newReturnStatement();
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)returnStatement2, null);
        ifStatement = (IfStatement)statements.get(3);
        returnStatement2 = ast.newReturnStatement();
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)returnStatement2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatementReplaceElse2() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        Block newBody = ast.newBlock();
        ASTNode newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        Block newElseBlock = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(1);
        Block body = (Block)ifStatement.getThenStatement();
        ASTNode statement2 = (ASTNode)body.statements().get(0);
        ASTNode newBody2 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody2, null);
        newElseBlock = ast.newBlock();
        returnStatement = ast.newReturnStatement();
        newElseBlock.statements().add(returnStatement);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        newBody = ast.newBlock();
        newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        ReturnStatement returnStatement2 = ast.newReturnStatement();
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)returnStatement2, null);
        ifStatement = (IfStatement)statements.get(3);
        body = (Block)ifStatement.getThenStatement();
        statement2 = (ASTNode)body.statements().get(0);
        newBody2 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody2, null);
        returnStatement2 = ast.newReturnStatement();
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)returnStatement2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatementReplaceElse3() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        Block newBody = ast.newBlock();
        ASTNode newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        IfStatement newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        Statement newBody2 = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getElseStatement());
        newElseBlock.setThenStatement(newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(1);
        Block body = (Block)ifStatement.getThenStatement();
        ASTNode statement2 = (ASTNode)body.statements().get(0);
        ASTNode newBody3 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody3, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getElseStatement());
        newElseBlock.setThenStatement(newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        newBody = ast.newBlock();
        newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getElseStatement());
        newElseBlock.setThenStatement(newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(3);
        body = (Block)ifStatement.getThenStatement();
        statement2 = (ASTNode)body.statements().get(0);
        newBody3 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody3, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = (Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getElseStatement());
        newElseBlock.setThenStatement(newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true)\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true)\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true) {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testIfStatementReplaceElse4() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else\n");
        buf.append("            hoo(11);\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else {\n");
        buf.append("            hoo(11);\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        IfStatement ifStatement = (IfStatement)statements.get(0);
        Statement statement = ifStatement.getThenStatement();
        Block newBody = ast.newBlock();
        ASTNode newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        IfStatement newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        Block newBody2 = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        newBody2.statements().add(returnStatement);
        newElseBlock.setThenStatement((Statement)newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(1);
        Block body = (Block)ifStatement.getThenStatement();
        ASTNode statement2 = (ASTNode)body.statements().get(0);
        ASTNode newBody3 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody3, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = ast.newBlock();
        returnStatement = ast.newReturnStatement();
        newBody2.statements().add(returnStatement);
        newElseBlock.setThenStatement((Statement)newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(2);
        statement = ifStatement.getThenStatement();
        newBody = ast.newBlock();
        newStatement = rewrite.createMoveTarget((ASTNode)statement);
        newBody.statements().add(newStatement);
        rewrite.replace((ASTNode)statement, (ASTNode)newBody, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = ast.newReturnStatement();
        newElseBlock.setThenStatement((Statement)newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        ifStatement = (IfStatement)statements.get(3);
        body = (Block)ifStatement.getThenStatement();
        statement2 = (ASTNode)body.statements().get(0);
        newBody3 = rewrite.createMoveTarget(statement2);
        rewrite.replace((ASTNode)body, newBody3, null);
        newElseBlock = ast.newIfStatement();
        newElseBlock.setExpression((Expression)ast.newBooleanLiteral(true));
        newBody2 = ast.newReturnStatement();
        newElseBlock.setThenStatement((Statement)newBody2);
        rewrite.replace((ASTNode)ifStatement.getElseStatement(), (ASTNode)newElseBlock, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true) {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true) {\n");
        buf.append("            return;\n");
        buf.append("        }\n");
        buf.append("        if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        } else if (true)\n");
        buf.append("            return;\n");
        buf.append("        if (i == 0)\n");
        buf.append("            System.beep();\n");
        buf.append("        else if (true)\n");
        buf.append("            return;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testLabeledStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        label: if (i == 0) {\n");
        buf.append("            System.beep();\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        LabeledStatement labeledStatement = (LabeledStatement)statements.get(0);
        SimpleName newLabel = ast.newSimpleName("newLabel");
        rewrite.replace((ASTNode)labeledStatement.getLabel(), (ASTNode)newLabel, null);
        Assignment newExpression = ast.newAssignment();
        newExpression.setLeftHandSide((Expression)ast.newSimpleName("x"));
        newExpression.setRightHandSide((Expression)ast.newNumberLiteral("1"));
        newExpression.setOperator(Assignment.Operator.ASSIGN);
        ExpressionStatement newStatement = ast.newExpressionStatement((Expression)newExpression);
        rewrite.replace((ASTNode)labeledStatement.getBody(), (ASTNode)newStatement, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        newLabel: x = 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testReturnStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        return;\n");
        buf.append("        return 1;\n");
        buf.append("        return 1;\n");
        buf.append("        return 1 + 2;\n");
        buf.append("        return(1 + 2);\n");
        buf.append("        return/*com*/ 1;\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 6", (statements.size() == 6 ? 1 : 0) != 0);
        ReturnStatement statement = (ReturnStatement)statements.get(0);
        ASTRewritingStatementsTest.assertTrue((String)"Has expression", (statement.getExpression() == null ? 1 : 0) != 0);
        SimpleName newExpression = ast.newSimpleName("x");
        rewrite.set((ASTNode)statement, (StructuralPropertyDescriptor)ReturnStatement.EXPRESSION_PROPERTY, (Object)newExpression, null);
        statement = (ReturnStatement)statements.get(1);
        Expression expression = statement.getExpression();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (expression != null ? 1 : 0) != 0);
        SimpleName newExpression2 = ast.newSimpleName("x");
        rewrite.replace((ASTNode)expression, (ASTNode)newExpression2, null);
        statement = (ReturnStatement)statements.get(2);
        expression = statement.getExpression();
        ASTRewritingStatementsTest.assertTrue((String)"Has no label", (expression != null ? 1 : 0) != 0);
        rewrite.remove((ASTNode)expression, null);
        statement = (ReturnStatement)statements.get(3);
        expression = (InfixExpression)statement.getExpression();
        rewrite.replace((ASTNode)expression.getLeftOperand(), (ASTNode)ast.newNumberLiteral("9"), null);
        statement = (ReturnStatement)statements.get(4);
        expression = statement.getExpression();
        rewrite.replace((ASTNode)expression, (ASTNode)ast.newNumberLiteral("9"), null);
        statement = (ReturnStatement)statements.get(5);
        expression = statement.getExpression();
        rewrite.replace((ASTNode)expression, (ASTNode)ast.newNumberLiteral("9"), null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        return x;\n");
        buf.append("        return x;\n");
        buf.append("        return;\n");
        buf.append("        return 9 + 2;\n");
        buf.append("        return 9;\n");
        buf.append("        return 9;\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testSwitchStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(int i) {\n");
        buf.append("        switch (i) {\n");
        buf.append("        }\n");
        buf.append("        switch (i) {\n");
        buf.append("            case 1:\n");
        buf.append("                i= 1;\n");
        buf.append("                break;\n");
        buf.append("            case 2:\n");
        buf.append("                i= 2;\n");
        buf.append("                break;\n");
        buf.append("            default:\n");
        buf.append("                i= 3;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List blockStatements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 2", (blockStatements.size() == 2 ? 1 : 0) != 0);
        SwitchStatement switchStatement = (SwitchStatement)blockStatements.get(0);
        Expression expression = switchStatement.getExpression();
        SimpleName newExpression = ast.newSimpleName("x");
        rewrite.replace((ASTNode)expression, (ASTNode)newExpression, null);
        List statements = switchStatement.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 0", (statements.size() == 0 ? 1 : 0) != 0);
        SwitchCase caseStatement1 = ast.newSwitchCase();
        caseStatement1.setExpression((Expression)ast.newNumberLiteral("1"));
        ReturnStatement statement1 = ast.newReturnStatement();
        SwitchCase caseStatement2 = ast.newSwitchCase();
        caseStatement2.setExpression(null);
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)switchStatement, SwitchStatement.STATEMENTS_PROPERTY);
        listRewrite.insertLast((ASTNode)caseStatement1, null);
        listRewrite.insertLast((ASTNode)statement1, null);
        listRewrite.insertLast((ASTNode)caseStatement2, null);
        switchStatement = (SwitchStatement)blockStatements.get(1);
        List statements2 = switchStatement.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 8", (statements2.size() == 8 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)statements2.get(0), null);
        rewrite.remove((ASTNode)statements2.get(1), null);
        rewrite.remove((ASTNode)statements2.get(2), null);
        SwitchCase caseStatement = (SwitchCase)statements2.get(3);
        NumberLiteral newCaseExpression = ast.newNumberLiteral("10");
        rewrite.replace((ASTNode)caseStatement.getExpression(), (ASTNode)newCaseExpression, null);
        ListRewrite listRewrite2 = rewrite.getListRewrite((ASTNode)switchStatement, SwitchStatement.STATEMENTS_PROPERTY);
        SwitchCase caseStatement22 = ast.newSwitchCase();
        caseStatement22.setExpression((Expression)ast.newNumberLiteral("11"));
        listRewrite2.insertFirst((ASTNode)caseStatement22, null);
        ReturnStatement statement12 = ast.newReturnStatement();
        listRewrite2.insertAfter((ASTNode)statement12, (ASTNode)caseStatement22, null);
        caseStatement22 = ast.newSwitchCase();
        caseStatement22.setExpression((Expression)ast.newNumberLiteral("12"));
        listRewrite2.insertLast((ASTNode)caseStatement22, null);
        statement12 = ast.newReturnStatement();
        listRewrite2.insertAfter((ASTNode)statement12, (ASTNode)caseStatement22, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo(int i) {\n");
        buf.append("        switch (x) {\n");
        buf.append("            case 1:\n");
        buf.append("                return;\n");
        buf.append("            default:\n");
        buf.append("        }\n");
        buf.append("        switch (i) {\n");
        buf.append("            case 11:\n");
        buf.append("                return;\n");
        buf.append("            case 10:\n");
        buf.append("                i= 2;\n");
        buf.append("                break;\n");
        buf.append("            default:\n");
        buf.append("                i= 3;\n");
        buf.append("            case 12:\n");
        buf.append("                return;\n");
        buf.append("        }\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testThrowStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        throw new Exception();\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        throw new Exception('d');\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        TypeDeclaration type = ASTRewritingStatementsTest.findTypeDeclaration(astRoot, "E");
        FunctionDeclaration methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "foo");
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        ThrowStatement statement = (ThrowStatement)statements.get(0);
        ClassInstanceCreation creation = ast.newClassInstanceCreation();
        creation.setName((Name)ast.newSimpleName("NullPointerException"));
        creation.arguments().add(ast.newSimpleName("x"));
        rewrite.replace((ASTNode)statement.getExpression(), (ASTNode)creation, null);
        methodDecl = ASTRewritingStatementsTest.findMethodDeclaration(type, "goo");
        block = methodDecl.getBody();
        statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        statement = (ThrowStatement)statements.get(0);
        creation = (ClassInstanceCreation)statement.getExpression();
        SimpleName newArgument = ast.newSimpleName("x");
        rewrite.replace((ASTNode)creation.arguments().get(0), (ASTNode)newArgument, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("    public void foo() {\n");
        buf.append("        throw new NullPointerException(x);\n");
        buf.append("    }\n");
        buf.append("    public void goo() {\n");
        buf.append("        throw new Exception(x);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testTryStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo(i) {\n");
        buf.append("    try {\n");
        buf.append("    } finally {\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } catch (e) {\n");
        buf.append("    } finally {\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } catch (e) {\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } catch (e) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List blockStatements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (blockStatements.size() == 4 ? 1 : 0) != 0);
        TryStatement tryStatement = (TryStatement)blockStatements.get(0);
        CatchClause catchClause = ast.newCatchClause();
        SingleVariableDeclaration decl = ast.newSingleVariableDeclaration();
        decl.setName(ast.newSimpleName("e"));
        catchClause.setException(decl);
        rewrite.getListRewrite((ASTNode)tryStatement, TryStatement.CATCH_CLAUSES_PROPERTY).insertLast((ASTNode)catchClause, null);
        Block body = ast.newBlock();
        body.statements().add(ast.newReturnStatement());
        rewrite.replace((ASTNode)tryStatement.getFinally(), (ASTNode)body, null);
        tryStatement = (TryStatement)blockStatements.get(1);
        List catchClauses = tryStatement.catchClauses();
        CatchClause catchClause2 = ast.newCatchClause();
        SingleVariableDeclaration decl2 = ast.newSingleVariableDeclaration();
        decl2.setName(ast.newSimpleName("x"));
        catchClause2.setException(decl2);
        rewrite.replace((ASTNode)catchClauses.get(0), (ASTNode)catchClause2, null);
        rewrite.remove((ASTNode)tryStatement.getFinally(), null);
        tryStatement = (TryStatement)blockStatements.get(2);
        catchClauses = tryStatement.catchClauses();
        rewrite.remove((ASTNode)catchClauses.get(0), null);
        Block body2 = ast.newBlock();
        body2.statements().add(ast.newReturnStatement());
        rewrite.set((ASTNode)tryStatement, (StructuralPropertyDescriptor)TryStatement.FINALLY_PROPERTY, (Object)body2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo(i) {\n");
        buf.append("    try {\n");
        buf.append("    } catch ( e) {\n");
        buf.append("    } finally {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } catch (x) {\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } finally {\n");
        buf.append("        return;\n");
        buf.append("    }\n");
        buf.append("    try {\n");
        buf.append("    } catch (e) {\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testVariableDeclarationStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    var i1= 1;\n");
        buf.append("    var i2= 1, k2= 2, n2= 3;\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("A.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 2", (statements.size() == 2 ? 1 : 0) != 0);
        VariableDeclarationStatement decl = (VariableDeclarationStatement)statements.get(0);
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName("k1"));
        frag.setInitializer(null);
        rewrite.getListRewrite((ASTNode)decl, VariableDeclarationStatement.FRAGMENTS_PROPERTY).insertLast((ASTNode)frag, null);
        decl = (VariableDeclarationStatement)statements.get(1);
        List fragments = decl.fragments();
        ASTRewritingStatementsTest.assertTrue((String)"Number of fragments not 3", (fragments.size() == 3 ? 1 : 0) != 0);
        rewrite.remove((ASTNode)fragments.get(0), null);
        rewrite.remove((ASTNode)fragments.get(1), null);
        VariableDeclarationFragment frag2 = ast.newVariableDeclarationFragment();
        frag2.setName(ast.newSimpleName("k2"));
        frag2.setInitializer(null);
        rewrite.replace((ASTNode)fragments.get(2), (ASTNode)frag2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    var i1= 1, k1;\n");
        buf.append("    var k2;\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testWhileStatement() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (i == j) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        WhileStatement whileStatement = (WhileStatement)statements.get(0);
        BooleanLiteral literal = ast.newBooleanLiteral(true);
        rewrite.replace((ASTNode)whileStatement.getExpression(), (ASTNode)literal, null);
        Block newBody = ast.newBlock();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)whileStatement.getBody(), (ASTNode)newBody, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (true) {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testWhileStatement1() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (true) {\n");
        buf.append("        foo();\n");
        buf.append("    }\n");
        buf.append("    while (true)\n");
        buf.append("        foo();\n");
        buf.append("    while (true) {\n");
        buf.append("        foo();\n");
        buf.append("    }\n");
        buf.append("    while (true)\n");
        buf.append("        foo();\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        AST ast = astRoot.getAST();
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((block.getFlags() & 1) == 0 ? 1 : 0) != 0);
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 4", (statements.size() == 4 ? 1 : 0) != 0);
        WhileStatement whileStatement = (WhileStatement)statements.get(0);
        TryStatement newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        CatchClause newCatchClause = ast.newCatchClause();
        SingleVariableDeclaration varDecl = ast.newSingleVariableDeclaration();
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)whileStatement.getBody(), (ASTNode)newTry, null);
        whileStatement = (WhileStatement)statements.get(1);
        Block newBody = ast.newBlock();
        FunctionInvocation invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)whileStatement.getBody(), (ASTNode)newBody, null);
        whileStatement = (WhileStatement)statements.get(2);
        newBody = ast.newBlock();
        invocation = ast.newFunctionInvocation();
        invocation.setName(ast.newSimpleName("hoo"));
        invocation.arguments().add(ast.newNumberLiteral("11"));
        newBody.statements().add(ast.newExpressionStatement((Expression)invocation));
        rewrite.replace((ASTNode)whileStatement.getBody(), (ASTNode)newBody, null);
        whileStatement = (WhileStatement)statements.get(3);
        newTry = ast.newTryStatement();
        newTry.getBody().statements().add(ast.newReturnStatement());
        newCatchClause = ast.newCatchClause();
        varDecl = ast.newSingleVariableDeclaration();
        varDecl.setName(ast.newSimpleName("e"));
        newCatchClause.setException(varDecl);
        newTry.catchClauses().add(newCatchClause);
        rewrite.replace((ASTNode)whileStatement.getBody(), (ASTNode)newTry, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (true)\n");
        buf.append("        try {\n");
        buf.append("            return;\n");
        buf.append("        } catch (e) {\n");
        buf.append("        }\n");
        buf.append("    while (true) {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("    while (true) {\n");
        buf.append("        hoo(11);\n");
        buf.append("    }\n");
        buf.append("    while (true)\n");
        buf.append("        try {\n");
        buf.append("            return;\n");
        buf.append("        } catch (e) {\n");
        buf.append("        }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testInsertCode() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (i == j) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        ASTRewritingStatementsTest.assertTrue((String)"Parse errors", ((astRoot.getFlags() & 1) == 0 ? 1 : 0) != 0);
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        ASTRewritingStatementsTest.assertTrue((String)"Number of statements not 1", (statements.size() == 1 ? 1 : 0) != 0);
        WhileStatement whileStatement = (WhileStatement)statements.get(0);
        String comment = "//hello";
        ASTNode placeHolder = rewrite.createStringPlaceholder(comment, 41);
        rewrite.replace((ASTNode)whileStatement, placeHolder, null);
        StringBuffer buf1 = new StringBuffer();
        buf1.append("if (i == 3) {\n");
        buf1.append("    System.beep();\n");
        buf1.append("}");
        ASTNode placeHolder2 = rewrite.createStringPlaceholder(buf1.toString(), 25);
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertLast(placeHolder2, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    //hello\n");
        buf.append("    if (i == 3) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }

    public void testInsertComment() throws Exception {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuffer buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (i == j) {\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        IJavaScriptUnit cu = pack1.createCompilationUnit("E.js", buf.toString(), false, null);
        JavaScriptUnit astRoot = this.createAST(cu);
        ASTRewrite rewrite = ASTRewrite.create((AST)astRoot.getAST());
        FunctionDeclaration methodDecl = (FunctionDeclaration)astRoot.statements().get(0);
        Block block = methodDecl.getBody();
        List statements = block.statements();
        WhileStatement whileStatement = (WhileStatement)statements.get(0);
        Statement whileBlock = whileStatement.getBody();
        StringBuffer comment = new StringBuffer();
        comment.append("/*\n");
        comment.append(" * Here's the block comment I want to insert :-)\n");
        comment.append(" */");
        ASTNode placeHolder = rewrite.createStringPlaceholder(comment.toString(), 41);
        ListRewrite list = rewrite.getListRewrite((ASTNode)whileBlock, Block.STATEMENTS_PROPERTY);
        list.insertFirst(placeHolder, null);
        String preview = this.evaluateRewrite(cu, rewrite);
        buf = new StringBuffer();
        buf.append("function foo() {\n");
        buf.append("    while (i == j) {\n");
        buf.append("        /*\n");
        buf.append("         * Here's the block comment I want to insert :-)\n");
        buf.append("         */\n");
        buf.append("        System.beep();\n");
        buf.append("    }\n");
        buf.append("}\n");
        ASTRewritingStatementsTest.assertEqualString(preview, buf.toString());
    }
}

