/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.rewrite.describing;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.tests.model.AbstractJavaModelTests;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingExpressionsTest;
import org.eclipse.wst.jsdt.core.tests.rewrite.describing.StringAsserts;

public class ASTRewritingTest
extends AbstractJavaModelTests {
    private static final int AST_INTERNAL_JLS2 = 2;
    protected IJavaScriptProject project1;
    protected IPackageFragmentRoot sourceFolder;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.tests.rewrite.describing.ASTRewritingTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite(clazz.getName());
        suite.addTest(ASTRewritingExpressionsTest.allTests());
        return suite;
    }

    public ASTRewritingTest(String name) {
        super(name);
    }

    public void setUpSuite() throws Exception {
        super.setUpSuite();
    }

    public void tearDownSuite() throws Exception {
        super.tearDownSuite();
    }

    protected void setUp() throws Exception {
        super.setUp();
        IJavaScriptProject proj = this.createJavaProject("P", new String[]{"src"});
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.tabulation.char", "space");
        proj.setOption("org.eclipse.wst.jsdt.core.formatter.tabulation.size", "4");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        proj.setOption("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        this.project1 = proj;
        this.sourceFolder = this.getPackageFragmentRoot("P", "src");
        ASTRewritingTest.waitUntilIndexesReady();
    }

    protected void tearDown() throws Exception {
        this.deleteProject("P");
        super.tearDown();
    }

    protected JavaScriptUnit createAST(IJavaScriptUnit cu) {
        ASTParser parser = ASTParser.newParser((int)2);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        return (JavaScriptUnit)parser.createAST(null);
    }

    protected JavaScriptUnit createAST3(IJavaScriptUnit cu) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(cu);
        parser.setResolveBindings(false);
        return (JavaScriptUnit)parser.createAST(null);
    }

    protected String evaluateRewrite(IJavaScriptUnit cu, ASTRewrite rewrite) throws Exception {
        Document document1 = new Document(cu.getSource());
        TextEdit res = rewrite.rewriteAST((IDocument)document1, cu.getJavaScriptProject().getOptions(true));
        res.apply((IDocument)document1);
        String content1 = document1.get();
        Document document2 = new Document(cu.getSource());
        TextEdit res2 = rewrite.rewriteAST();
        res2.apply((IDocument)document2);
        String content2 = document2.get();
        ASTRewritingTest.assertEquals((String)content1, (String)content2);
        return content1;
    }

    public static void assertEqualString(String actual, String expected) {
        StringAsserts.assertEqualString(actual, expected);
    }

    public static TypeDeclaration findTypeDeclaration(JavaScriptUnit astRoot, String simpleTypeName) {
        return (TypeDeclaration)ASTRewritingTest.findAbstractTypeDeclaration(astRoot, simpleTypeName);
    }

    public static AbstractTypeDeclaration findAbstractTypeDeclaration(JavaScriptUnit astRoot, String simpleTypeName) {
        List types = astRoot.types();
        int i = 0;
        while (i < types.size()) {
            AbstractTypeDeclaration elem = (AbstractTypeDeclaration)types.get(i);
            if (simpleTypeName.equals(elem.getName().getIdentifier())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public static FunctionDeclaration findMethodDeclaration(JavaScriptUnit astRoot, String simpleTypeName) {
        List statements = astRoot.statements();
        int i = 0;
        while (i < statements.size()) {
            FunctionDeclaration elem;
            Object obj = statements.get(i);
            if (obj instanceof FunctionDeclaration && simpleTypeName.equals((elem = (FunctionDeclaration)obj).getName().getIdentifier())) {
                return elem;
            }
            ++i;
        }
        return null;
    }

    public static FunctionDeclaration findMethodDeclaration(TypeDeclaration typeDecl, String methodName) {
        FunctionDeclaration[] methods = typeDecl.getMethods();
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName().getIdentifier())) {
                return methods[i];
            }
            ++i;
        }
        return null;
    }

    public static SingleVariableDeclaration createNewParam(AST ast, String name) {
        SingleVariableDeclaration newParam = ast.newSingleVariableDeclaration();
        newParam.setType((Type)ast.newPrimitiveType(PrimitiveType.FLOAT));
        newParam.setName(ast.newSimpleName(name));
        return newParam;
    }

    private void setModifiers(BodyDeclaration bodyDeclaration, int modifiers) {
        bodyDeclaration.setModifiers(modifiers);
    }

    private void setReturnType(FunctionDeclaration methodDeclaration, Type type) {
        methodDeclaration.setReturnType(type);
    }

    protected FieldDeclaration createNewField(AST ast, String name) {
        VariableDeclarationFragment frag = ast.newVariableDeclarationFragment();
        frag.setName(ast.newSimpleName(name));
        FieldDeclaration newFieldDecl = ast.newFieldDeclaration(frag);
        if (ast.apiLevel() == 2) {
            this.setModifiers((BodyDeclaration)newFieldDecl, 2);
        } else {
            newFieldDecl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
        }
        newFieldDecl.setType((Type)ast.newPrimitiveType(PrimitiveType.DOUBLE));
        return newFieldDecl;
    }

    protected FunctionDeclaration createNewMethod(AST ast, String name, boolean isAbstract) {
        FunctionDeclaration decl = ast.newFunctionDeclaration();
        decl.setName(ast.newSimpleName(name));
        if (ast.apiLevel() == 2) {
            this.setModifiers((BodyDeclaration)decl, isAbstract ? 1026 : 2);
            this.setReturnType(decl, (Type)ast.newPrimitiveType(PrimitiveType.VOID));
        } else {
            decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PRIVATE_KEYWORD));
            if (isAbstract) {
                decl.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.ABSTRACT_KEYWORD));
            }
            decl.setReturnType2((Type)ast.newPrimitiveType(PrimitiveType.VOID));
        }
        SingleVariableDeclaration param = ast.newSingleVariableDeclaration();
        param.setName(ast.newSimpleName("str"));
        param.setType((Type)ast.newSimpleType((Name)ast.newSimpleName("String")));
        decl.parameters().add(param);
        decl.setBody(isAbstract ? null : ast.newBlock());
        return decl;
    }
}

