/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;

public class TestExcludeResultPrefixesCompletionProposal
extends AbstractSourceViewerTest {
    private ICompletionProposal[] setupProposals(int column, int line) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException, BadLocationException, Exception {
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        int offset = document.getLineOffset(line) + column;
        ICompletionProposal[] proposals = this.getProposals(offset);
        return proposals;
    }

    public void testAllDefaultValueNoProposals() throws Exception {
        this.fileName = "TestResultPrefixes.xsl";
        int column = 29;
        int line = 2;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Found proposals when #all already in result value.", (int)0, (int)proposals.length);
    }

    public void testXHTMLNamespacePropsoalAvailable() throws Exception {
        this.fileName = "TestResultPrefixesEmpty.xsl";
        int column = 29;
        int line = 2;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        ICompletionProposal[] proposals = this.getProposals(line, column);
        TestExcludeResultPrefixesCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Proposal length not 2.", (int)2, (int)proposals.length);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Proposal did not find xhtml as proposal value.", (String)"xhtml", (String)proposals[1].getDisplayString());
    }

    public void testAllPropsoalAvailable() throws Exception {
        this.fileName = "TestResultPrefixesEmpty.xsl";
        int column = 29;
        int line = 2;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument cfr_ignored_0 = (IStructuredDocument)this.sourceViewer.getDocument();
        ICompletionProposal[] proposals = this.getProposals(line, column);
        TestExcludeResultPrefixesCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Proposal length not 2.", (int)2, (int)proposals.length);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Proposal did not find xhtml as proposal value.", (String)"#all", (String)proposals[0].getDisplayString());
    }

    public void testExcludeXHTMLProposal() throws Exception {
        this.fileName = "TestResultPrefixesWithXhtml.xsl";
        int column = 35;
        int line = 2;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        TestExcludeResultPrefixesCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("xhtml")) {
                TestExcludeResultPrefixesCompletionProposal.fail((String)"XHTML Proposal found, when it should not have been!");
            }
            ++cnt;
        }
    }

    public void testTestProposal() throws Exception {
        this.fileName = "TestResultPrefixesWithXhtml.xsl";
        int column = 35;
        int line = 2;
        ICompletionProposal[] proposals = this.setupProposals(column, line);
        TestExcludeResultPrefixesCompletionProposal.assertNotNull((String)"Did not find proposals.", (Object)proposals);
        TestExcludeResultPrefixesCompletionProposal.assertFalse((String)"Proposals returned more than one.", (proposals.length > 1 ? 1 : 0) != 0);
        TestExcludeResultPrefixesCompletionProposal.assertEquals((String)"Did not find test in proposal list", (String)"test", (String)proposals[0].getDisplayString());
    }
}

