/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.contentassist;

import java.io.File;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsl.ui.tests.AbstractSourceViewerTest;

public class XSLCompletionTest
extends AbstractSourceViewerTest {
    public void testGetNodeAtLine15() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(14) + 1));
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:stylesheet", (String)node.getNodeName());
    }

    public void testGetNodeAtLine16() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(15) + 11));
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:template", (String)node.getNodeName());
    }

    public void testGetNodeAtLine17() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)(this.sourceViewer.getDocument().getLineOffset(16) + 14));
        XSLCompletionTest.assertEquals((String)"Wrong node name returned:", (String)"xsl:param", (String)node.getNodeName());
    }

    public void testAttributeNotValueAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(838);
        XSLCompletionTest.assertTrue((proposals.length > 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[0];
        XSLCompletionTest.assertFalse((String)"Found \"number(substring($date, 6, 2))\".", (boolean)proposal.getDisplayString().equals("\"number(substring($date, 6, 2))\""));
    }

    public void testSelectAttributeProposalsAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        int offset = this.sourceViewer.getDocument().getLineOffset(18) + 44;
        String s = this.sourceViewer.getDocument().get(offset - 1, 6);
        XSLCompletionTest.assertEquals((String)"number", (String)s);
        ICompletionProposal[] proposals = this.getProposals(18, 43);
        XSLCompletionTest.assertTrue((proposals.length > 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[3];
        XSLCompletionTest.assertEquals((String)"Wrong select item returned: ", (String)"..", (String)proposal.getDisplayString());
    }

    public void testSelectAttributeProposalsNarrow() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        int offset = this.sourceViewer.getDocument().getLineOffset(18) + 44;
        String s = this.sourceViewer.getDocument().get(offset - 9, 9);
        XSLCompletionTest.assertEquals((String)"select=\"n", (String)s);
        ICompletionProposal[] proposals = this.getProposals(offset);
        XSLCompletionTest.assertEquals((String)"Wrong xpath item returned: ", (String)"name(node-set)", (String)proposals[0].getDisplayString());
        XSLCompletionTest.assertEquals((String)"Wrong Number of items returned: ", (int)6, (int)proposals.length);
    }

    public void testTestAttributeProposalsAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getXMLProposals(37, 18);
        XSLCompletionTest.assertTrue((proposals.length >= 1 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[0];
        XSLCompletionTest.assertTrue((String)"Wrong attribute proposal returned:", (boolean)proposal.getDisplayString().contains("disable-output-escaping"));
    }

    public void testXSLElementProposalsAvailable() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getXMLProposals(31, 58);
        XSLCompletionTest.assertTrue((proposals.length >= 2 ? 1 : 0) != 0);
        ICompletionProposal proposal = proposals[1];
        XSLCompletionTest.assertTrue((String)"Can't find XSL element proposals.", (boolean)proposal.getDisplayString().equals("xsl:otherwise"));
    }

    public void testXPathProposalAvaialbleAfterComma() throws Exception {
        this.fileName = "utils.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(861);
        XSLCompletionTest.assertTrue((proposals.length > 0 ? 1 : 0) != 0);
    }

    public void testVariableInsertPositionOffset() throws Exception {
        this.fileName = "bug281420.xsl";
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        ICompletionProposal[] proposals = this.getProposals(4, 25);
        XSLCompletionTest.assertTrue((String)"Did not find any proposals.", (proposals.length > 0 ? 1 : 0) != 0);
        CustomCompletionProposal testprop = null;
        int cnt = 0;
        while (cnt < proposals.length) {
            if (proposals[cnt].getDisplayString().equals("$test")) {
                testprop = (CustomCompletionProposal)proposals[cnt];
            }
            ++cnt;
        }
        if (testprop == null) {
            XSLCompletionTest.fail((String)"Didn't find the $test proposal");
        }
        int startoffset = this.calculateOffset(4, 24);
        if (testprop.getReplacementOffset() != startoffset) {
            XSLCompletionTest.fail((String)("Replacement Offset position worng expected " + startoffset + "but received " + testprop.getReplacementOffset()));
        }
    }
}

