/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.ui.tests.style;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.provisional.style.Highlighter;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xsl.core.internal.text.rules.StructuredTextPartitionerForXSL;
import org.eclipse.wst.xsl.ui.internal.StructuredTextViewerConfigurationXSL;
import org.eclipse.wst.xsl.ui.tests.AbstractXSLUITest;

public class TestXSLLineStyleProvider
extends AbstractXSLUITest {
    protected String projectName = null;
    protected String fileName = null;
    protected IFile file = null;
    protected IEditorPart textEditorPart = null;
    protected ITextEditor editor = null;
    protected XMLDocumentLoader xmlDocumentLoader = null;
    protected IStructuredDocument document = null;
    protected StructuredTextViewer sourceViewer = null;
    protected StructuredTextViewerConfigurationXSL xslConfiguration = new StructuredTextViewerConfigurationXSL();
    protected String Partitioning = "__dftl_partitioning";
    protected StructuredTextPartitionerForXSL defaultPartitioner = new StructuredTextPartitionerForXSL();
    protected Shell shell = null;
    protected Composite parent = null;
    private IStructuredModel model = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.setupProject();
    }

    protected void loadFileForTesting(String xslFilePath) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(xslFilePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + this.fileName + " stylesheet."));
        }
        this.loadXSLFile();
        this.initializeSourceViewer();
    }

    protected void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            this.shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            this.parent = new Composite((Composite)this.shell, 0);
            this.sourceViewer = new StructuredTextViewer(this.parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)this.xslConfiguration);
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void loadXSLFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.model = modelManager.getNewModelForEdit(this.file, true);
        this.document = this.model.getStructuredDocument();
        IDocumentPartitioner partitioner = this.defaultPartitioner.newInstance();
        partitioner.connect((IDocument)this.document);
        this.document.setDocumentPartitioner(partitioner);
    }

    protected void setupProject() {
        this.projectName = "xsltestfiles";
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.parent.dispose();
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
    }

    private LineStyleProvider[] getLineStyleProviders() {
        LineStyleProvider[] lineStyleProviders = this.xslConfiguration.getLineStyleProviders((ISourceViewer)this.sourceViewer, "org.eclipse.wst.xml.XML_DEFAULT");
        return lineStyleProviders;
    }

    private void setUpTest(String file) throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        this.fileName = file;
        String xslFilePath = String.valueOf(this.projectName) + File.separator + this.fileName;
        this.loadFileForTesting(xslFilePath);
        IStructuredDocument document = (IStructuredDocument)this.sourceViewer.getDocument();
        TestXSLLineStyleProvider.assertNotNull((String)"Missing Document Partitioner", (Object)document.getDocumentPartitioner());
    }

    private LineStyleProvider initializeProvider() {
        LineStyleProvider[] lineStyleProviders = this.getLineStyleProviders();
        LineStyleProvider lineStyleProvider = lineStyleProviders[0];
        Highlighter highlighter = new Highlighter();
        lineStyleProvider.init(this.document, highlighter);
        return lineStyleProvider;
    }

    private IRegion getDocumentRangeFromWidgetRange(int offset, int length) {
        IRegion styleRegion = null;
        if (this.sourceViewer instanceof ITextViewerExtension5) {
            StructuredTextViewer extension = this.sourceViewer;
            styleRegion = extension.widgetRange2ModelRange((IRegion)new Region(offset, length));
        } else {
            Object vr = null;
            vr = this.sourceViewer != null ? this.sourceViewer.getVisibleRegion() : new Region(0, this.document.getLength());
            if (offset <= vr.getLength()) {
                styleRegion = new Region(offset + vr.getOffset(), length);
            }
        }
        return styleRegion;
    }

    private void applyStyles(LineStyleProvider provider, ITypedRegion[] partitions, ArrayList holdStyleResults) {
        int i = 0;
        while (i < partitions.length) {
            ITypedRegion currentPartition = partitions[i];
            boolean bl = provider.prepareRegions(currentPartition, currentPartition.getOffset(), currentPartition.getLength(), (Collection)holdStyleResults);
            ++i;
        }
    }

    public void testHasLineStyleProvider() throws Exception {
        this.setUpTest("utils.xsl");
        LineStyleProvider[] lineStyleProviders = this.getLineStyleProviders();
        TestXSLLineStyleProvider.assertNotNull((String)"No line style providers found.", (Object)lineStyleProviders);
        TestXSLLineStyleProvider.assertEquals((String)"Wrong number of providers", (int)1, (int)lineStyleProviders.length);
    }

    public void testInitializeLineStyleProvider() throws Exception {
        this.setUpTest("utils.xsl");
        this.initializeProvider();
    }

    public void testPrepareRegion() throws Exception {
        this.setUpTest("utils.xsl");
        LineStyleProvider provider = this.initializeProvider();
        ITypedRegion[] partitions = this.setupPartitions();
        TestXSLLineStyleProvider.assertTrue((String)"No Partitions found.", (partitions.length > 0 ? 1 : 0) != 0);
        ArrayList holdStyleResults = new ArrayList();
        this.applyStyles(provider, partitions, holdStyleResults);
        TestXSLLineStyleProvider.assertFalse((String)"No styles applied.", (boolean)holdStyleResults.isEmpty());
        TestXSLLineStyleProvider.assertEquals((String)"Unexpected StyleRange size", (int)241, (int)holdStyleResults.size());
    }

    private ITypedRegion[] setupPartitions() throws BadLocationException {
        int startOffset = this.document.getFirstStructuredDocumentRegion().getStartOffset();
        int endLineLength = this.document.getLength();
        IRegion styleRegion = this.getDocumentRangeFromWidgetRange(startOffset, endLineLength);
        ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)this.document, (String)this.Partitioning, (int)styleRegion.getOffset(), (int)styleRegion.getLength(), (boolean)false);
        return partitions;
    }
}

