/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.internal.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedObject<V>
implements Cloneable,
Serializable {
    private V value;
    private final Object mutex;
    private static final long serialVersionUID = 1L;

    public SynchronizedObject(V value, Object mutex) {
        this.value = value;
        this.mutex = mutex;
    }

    public SynchronizedObject(V value) {
        this.value = value;
        this.mutex = this;
    }

    public SynchronizedObject() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getValue() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueEquals(V v) {
        Object object = this.mutex;
        synchronized (object) {
            return Tools.valuesAreEqual(this.value, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valueNotEqual(V v) {
        Object object = this.mutex;
        synchronized (object) {
            return Tools.valuesAreDifferent(this.value, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotNull() {
        Object object = this.mutex;
        synchronized (object) {
            return this.value != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V setValue(V value) {
        Object object = this.mutex;
        synchronized (object) {
            return this.setValue_(value);
        }
    }

    private V setValue_(V v) {
        V old = this.value;
        if (this.value != v) {
            this.value = v;
            this.mutex.notifyAll();
        }
        return old;
    }

    public V setNull() {
        return this.setValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V compareAndSwap(V expectedValue, V newValue) {
        Object object = this.mutex;
        synchronized (object) {
            return this.compareAndSwap_(expectedValue, newValue);
        }
    }

    private V compareAndSwap_(V expectedValue, V newValue) {
        return Tools.valuesAreEqual(this.value, expectedValue) ? this.setValue_(newValue) : this.value;
    }

    public Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIs(V v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(v);
        }
    }

    private void waitUntilValueIs_(V v) throws InterruptedException {
        while (Tools.valuesAreDifferent(this.value, v)) {
            this.mutex.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilValueIsNot(V v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot_(v);
        }
    }

    private void waitUntilValueIsNot_(V v) throws InterruptedException {
        while (Tools.valuesAreEqual(this.value, v)) {
            this.mutex.wait();
        }
    }

    public void waitUntilNull() throws InterruptedException {
        this.waitUntilValueIs(null);
    }

    public void waitUntilNotNull() throws InterruptedException {
        this.waitUntilValueIsNot(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitToSetValue(V v) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIsNot_(v);
            return this.setValue_(v);
        }
    }

    public V waitToSetNull() throws InterruptedException {
        return this.waitToSetValue(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V waitToSwap(V expectedValue, V newValue) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            this.waitUntilValueIs_(expectedValue);
            return this.setValue_(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIs(V v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIs_(v, timeout);
        }
    }

    private boolean waitUntilValueIs_(V v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilValueIs_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (Tools.valuesAreDifferent(this.value, v) && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value == v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitUntilValueIsNot(V v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            return this.waitUntilValueIsNot_(v, timeout);
        }
    }

    private boolean waitUntilValueIsNot_(V v, long timeout) throws InterruptedException {
        if (timeout == 0L) {
            this.waitUntilValueIsNot_(v);
            return true;
        }
        long stop = System.currentTimeMillis() + timeout;
        long remaining = timeout;
        while (Tools.valuesAreEqual(this.value, v) && remaining > 0L) {
            this.mutex.wait(remaining);
            remaining = stop - System.currentTimeMillis();
        }
        return this.value != v;
    }

    public boolean waitUntilNull(long timeout) throws InterruptedException {
        return this.waitUntilValueIs(null, timeout);
    }

    public boolean waitUntilNotNull(long timeout) throws InterruptedException {
        return this.waitUntilValueIsNot(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSetValue(V v, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIsNot_(v, timeout);
            if (success) {
                this.setValue_(v);
            }
            return success;
        }
    }

    public boolean waitToSetNull(long timeout) throws InterruptedException {
        return this.waitToSetValue(null, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitToSwap(V expectedValue, V newValue, long timeout) throws InterruptedException {
        Object object = this.mutex;
        synchronized (object) {
            boolean success = this.waitUntilValueIs_(expectedValue, timeout);
            if (success) {
                this.setValue_(newValue);
            }
            return success;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Command command) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.mutex;
        synchronized (object) {
            command.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizedObject<V> clone() {
        try {
            Object object = this.mutex;
            synchronized (object) {
                SynchronizedObject clone = (SynchronizedObject)super.clone();
                return clone;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof SynchronizedObject && Tools.valuesAreEqual(this.getValue(), ((SynchronizedObject)obj).getValue());
    }

    public int hashCode() {
        V v = this.getValue();
        return v == null ? 0 : v.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.getValue()) + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            s.defaultWriteObject();
        }
    }
}

