/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.value;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.jpt.utility.internal.model.value.AbstractCollectionValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCollectionValueModelAdapter<E>
extends AbstractCollectionValueModel
implements CollectionValueModel<E> {
    protected final PropertyValueModel<? extends E> valueHolder;
    protected final PropertyChangeListener propertyChangeListener;
    protected E value;

    public PropertyCollectionValueModelAdapter(PropertyValueModel<? extends E> valueHolder) {
        if (valueHolder == null) {
            throw new NullPointerException();
        }
        this.valueHolder = valueHolder;
        this.propertyChangeListener = this.buildPropertyChangeListener();
        this.value = null;
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Object eventNewValue = event.getNewValue();
                PropertyCollectionValueModelAdapter.this.valueChanged(eventNewValue);
            }

            public String toString() {
                return "property change listener";
            }
        };
    }

    @Override
    public Iterator<E> iterator() {
        return this.value == null ? EmptyIterator.instance() : this.iterator_();
    }

    protected Iterator<E> iterator_() {
        return new SingleElementIterator<E>(this.value);
    }

    @Override
    public int size() {
        return this.value == null ? 0 : 1;
    }

    @Override
    protected void engageModel() {
        this.valueHolder.addPropertyChangeListener("value", this.propertyChangeListener);
        this.value = this.valueHolder.getValue();
    }

    @Override
    protected void disengageModel() {
        this.valueHolder.removePropertyChangeListener("value", this.propertyChangeListener);
        this.value = null;
    }

    protected void valueChanged(E newValue) {
        E oldValue = this.value;
        this.value = newValue;
        if (oldValue == null) {
            this.fireItemAdded("values", newValue);
        } else if (newValue == null) {
            this.fireItemRemoved("values", oldValue);
        } else {
            this.fireCollectionChanged("values", Collections.singleton(newValue));
        }
    }

    @Override
    public void toString(StringBuilder sb) {
        StringTools.append(sb, this);
    }
}

