/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.gen.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.gen.internal.Association;
import org.eclipse.jpt.gen.internal.ORMGenColumn;
import org.eclipse.jpt.gen.internal.ORMGenTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationRole
implements Serializable {
    private transient Association mAssociation;
    private boolean mIsReferrerRole;
    private String mPropertyName;
    private String mCascade;
    private static final long serialVersionUID = 1L;

    AssociationRole(Association association, boolean isReferrerRole) {
        this.mAssociation = association;
        this.mIsReferrerRole = isReferrerRole;
    }

    public AssociationRole() {
    }

    protected void restore(Association association) {
        this.mAssociation = association;
    }

    public Association getAssociation() {
        return this.mAssociation;
    }

    public boolean isReferrerRole() {
        return this.mIsReferrerRole;
    }

    public AssociationRole getOppositeRole() {
        Association association = this.getAssociation();
        if (!association.getDirectionality().equals("bi-di")) {
            return null;
        }
        if (this.isReferrerRole()) {
            return association.getReferencedRole();
        }
        return association.getReferrerRole();
    }

    public String getCardinality() {
        String type = this.mAssociation.getCardinality();
        if (!this.mIsReferrerRole) {
            if (type.equals("one-to-many")) {
                type = "many-to-one";
            } else if (type.equals("many-to-one")) {
                type = "one-to-many";
            }
        }
        return type;
    }

    public ORMGenTable getReferrerTable() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferrerTable();
        }
        return this.mAssociation.getReferencedTable();
    }

    public List<ORMGenColumn> getReferrerColumns() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferrerColumns();
        }
        return this.mAssociation.getReferencedColumns();
    }

    public ORMGenColumn getReferencedColumn(String referrerColumn) {
        boolean hasJoinTable = this.mAssociation.getJoinTable() != null;
        List<ORMGenColumn> referrerColumns = this.getReferrerColumns();
        int i = 0;
        int n = referrerColumns.size();
        while (i < n) {
            ORMGenColumn column = referrerColumns.get(i);
            if (column.getName().equals(referrerColumn)) {
                if (hasJoinTable) {
                    return this.getReferrerJoinColumns().get(i);
                }
                return this.getReferencedColumns().get(i);
            }
            ++i;
        }
        assert (false);
        return null;
    }

    public ORMGenColumn getReferrerColumn(String referencedColumn) {
        boolean hasJoinTable = this.mAssociation.getJoinTable() != null;
        List<ORMGenColumn> referencedColumns = this.getReferencedColumns();
        int i = 0;
        int n = referencedColumns.size();
        while (i < n) {
            ORMGenColumn column = referencedColumns.get(i);
            if (column.getName().equals(referencedColumn)) {
                if (hasJoinTable) {
                    return this.getReferencedJoinColumns().get(i);
                }
                return this.getReferrerColumns().get(i);
            }
            ++i;
        }
        assert (false);
        return null;
    }

    public ORMGenTable getReferencedTable() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferencedTable();
        }
        return this.mAssociation.getReferrerTable();
    }

    public List<ORMGenColumn> getReferencedColumns() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferencedColumns();
        }
        return this.mAssociation.getReferrerColumns();
    }

    public List<ORMGenColumn> getReferrerJoinColumns() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferrerJoinColumns();
        }
        return this.mAssociation.getReferencedJoinColumns();
    }

    public List<ORMGenColumn> getReferencedJoinColumns() {
        if (this.mIsReferrerRole) {
            return this.mAssociation.getReferencedJoinColumns();
        }
        return this.mAssociation.getReferrerJoinColumns();
    }

    public String getPropertyName() {
        if (this.mPropertyName != null) {
            return this.mPropertyName;
        }
        return this.getDefaultPropertyName();
    }

    private String getDefaultPropertyName() {
        String propName = "";
        ORMGenTable referrerTable = this.getReferrerTable();
        ORMGenTable referencedTable = this.getReferencedTable();
        boolean isSingular = this.isSingular();
        propName = referencedTable.getVarName(isSingular);
        ArrayList<AssociationRole> clashingRoles = new ArrayList<AssociationRole>();
        for (AssociationRole role : referrerTable.getAssociationRoles()) {
            if (!role.getReferrerTable().getName().equals(referrerTable.getName()) || !role.getReferencedTable().getName().equals(referencedTable.getName()) || role.isSingular() != isSingular) continue;
            clashingRoles.add(role);
        }
        if (clashingRoles.size() > 1) {
            int index = clashingRoles.indexOf(this);
            assert (index >= 0);
            propName = String.valueOf(propName) + (index + 1);
        }
        for (ORMGenColumn column : referrerTable.getColumns()) {
            if (!column.getPropertyName().equals(propName)) continue;
            String prefix = isSingular ? "Bean" : "Set";
            propName = String.valueOf(propName) + prefix;
            break;
        }
        return propName;
    }

    private boolean isSingular() {
        String cardinality = this.getCardinality();
        return cardinality.equals("one-to-one") || cardinality.equals("many-to-one");
    }

    public void setPropertyName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (name != null && name.equals(this.getDefaultPropertyName())) {
            name = null;
        }
        this.mPropertyName = name;
    }

    public String getCascade() {
        return this.mCascade;
    }

    public void setCascade(String cascade) {
        if (cascade != null && cascade.length() == 0) {
            cascade = null;
        }
        this.mCascade = cascade;
    }

    public String getDescription() {
        String directionality = this.getAssociation().getDirectionality().equals("bi-di") ? "bi-directional" : "uni-directional";
        return String.valueOf(directionality) + " " + this.getAssociation().getCardinality() + " association to " + this.getReferencedTable().getClassName();
    }
}

