/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RequestHandler;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DebugSession;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.SocketTransportService;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TimeoutException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TransportService;

public class DebugSessionManager {
    private static final boolean DEBUG = false;
    private static final String ADDRESS = "address";
    private static final String SOCKET = "socket";
    private static final String TRANSPORT = "transport";
    private final TransportService transportService;
    private final String address;
    private final boolean startSuspended;
    private DebugSession debugSession;
    private Thread debuggerThread;
    private volatile boolean shutdown = false;

    public DebugSessionManager(TransportService transportService, String address, boolean startSuspended) {
        this.transportService = transportService;
        this.address = address;
        this.startSuspended = startSuspended;
        this.prettyPrintHeader();
    }

    static DebugSessionManager create(String configString) {
        Map config = DebugSessionManager.parseConfigString(configString);
        String transport = (String)config.get(TRANSPORT);
        if (!SOCKET.equals(transport)) {
            throw new IllegalArgumentException("Transport service must be 'socket': " + transport);
        }
        SocketTransportService parsedTransportService = new SocketTransportService();
        String parsedAddress = (String)config.get(ADDRESS);
        String suspend = (String)config.get("suspend");
        boolean parsedStartSuspended = false;
        if (suspend != null) {
            parsedStartSuspended = Boolean.valueOf(suspend) != false || suspend.trim().equalsIgnoreCase("y");
        }
        return new DebugSessionManager(parsedTransportService, parsedAddress, parsedStartSuspended);
    }

    private static Map parseConfigString(String configString) {
        HashMap<String, String> config = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(configString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int equalsIndex = token.indexOf(61);
            if (equalsIndex == -1) {
                config.put(token, null);
                continue;
            }
            config.put(token.substring(0, equalsIndex), token.substring(equalsIndex + 1));
        }
        return config;
    }

    private void prettyPrintHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Rhino attaching debugger\n");
        buffer.append("Start at time: ").append(this.getStartAtDate());
        buffer.append("\nListening to ");
        buffer.append(this.transportService instanceof SocketTransportService ? "socket on " : "transport service on ");
        buffer.append("port: ").append(this.address);
        if (this.startSuspended) {
            buffer.append("\nStarted suspended - waiting for client resume...");
        }
        System.out.println(buffer.toString());
    }

    String getStartAtDate() {
        try {
            return DateFormat.getDateTimeInstance(1, 1).format(Calendar.getInstance().getTime());
        }
        catch (Throwable throwable) {
            return "<unknown>";
        }
    }

    public boolean isStartSuspended() {
        return this.startSuspended;
    }

    public synchronized boolean isConnected() {
        return this.debugSession != null;
    }

    public synchronized void start(RhinoDebuggerImpl debugger) {
        this.debuggerThread = new DebugSessionThread("RhinoDebugger - Request Handler", debugger);
        this.debuggerThread.start();
        if (this.startSuspended) {
            try {
                this.wait(300000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void stop() {
        this.shutdown = true;
        try {
            this.debuggerThread.interrupt();
            if (this.debuggerThread.isAlive()) {
                this.wait();
            }
            this.debuggerThread.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    private synchronized void setDebugSession(DebugSession session) {
        if (this.debugSession != session) {
            if (this.debugSession != null) {
                this.debugSession.dispose();
            }
            this.debugSession = session;
            this.notify();
        }
    }

    public synchronized boolean sendEvent(EventPacket event) {
        try {
            if (this.debugSession != null) {
                this.debugSession.sendEvent(event);
                return true;
            }
        }
        catch (DisconnectedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void sendDeathEvent() {
        EventPacket event = new EventPacket("vmdeath");
        this.sendEvent(event);
    }

    public class DebugSessionThread
    extends Thread {
        private TransportService.ListenerKey listenerKey;
        private Connection connection;
        private RequestHandler requestHandler;

        public DebugSessionThread(String name, RhinoDebuggerImpl debugger) {
            super(name);
            this.requestHandler = new RequestHandler(debugger);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.listenerKey = DebugSessionManager.this.transportService.startListening(DebugSessionManager.this.address);
                    while (!DebugSessionManager.this.shutdown) {
                        try {
                            this.acceptConnection(10000L);
                        }
                        catch (IOException iOException) {
                            if (this.connection == null) continue;
                        }
                        while (!DebugSessionManager.this.shutdown && this.connection.isOpen()) {
                            try {
                                Request request = DebugSessionManager.this.debugSession.receiveRequest(1000);
                                Response response = this.requestHandler.handleRequest(request);
                                DebugSessionManager.this.debugSession.sendResponse(response);
                                continue;
                            }
                            catch (TimeoutException timeoutException) {
                                continue;
                            }
                            catch (DisconnectedException disconnectedException) {}
                            break;
                        }
                        this.closeConnection();
                    }
                }
                catch (IOException iOException) {
                    DebugSessionManager.this.sendDeathEvent();
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                try {
                    if (this.listenerKey == null) throw throwable;
                    DebugSessionManager.this.transportService.stopListening(this.listenerKey);
                    throw throwable;
                }
                catch (IOException iOException) {
                    DebugSessionManager.this.sendDeathEvent();
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            try {}
            catch (IOException iOException) {
                DebugSessionManager.this.sendDeathEvent();
                return;
            }
            if (this.listenerKey == null) return;
            DebugSessionManager.this.transportService.stopListening(this.listenerKey);
        }

        private void closeConnection() throws IOException {
            if (this.connection != null) {
                DebugSessionManager.this.setDebugSession(null);
                this.connection.close();
                this.connection = null;
            }
        }

        private void acceptConnection(long timeout) throws IOException {
            if (this.connection == null) {
                this.connection = DebugSessionManager.this.transportService.accept(this.listenerKey, timeout, timeout);
                DebugSessionManager.this.setDebugSession(new DebugSession(this.connection));
            }
        }
    }
}

