/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.adapters;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.model.elements.ElementContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptThread;
import org.eclipse.wst.jsdt.debug.core.model.IScriptGroup;
import org.eclipse.wst.jsdt.debug.internal.ui.PreferencesManager;

public class JavaScriptAsyncContentProvider
extends ElementContentProvider {
    static final Object[] NO_CHILDREN = new Object[0];

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (parent instanceof IJavaScriptDebugTarget) {
            IJavaScriptDebugTarget target = (IJavaScriptDebugTarget)parent;
            Object[] threads = target.getThreads();
            if (PreferencesManager.getManager().showLoadedScripts()) {
                Object[] children = new Object[threads.length + 1];
                children[0] = target.getScriptGroup();
                System.arraycopy(threads, 0, children, 1, threads.length);
                return this.getElements(children, index, length);
            }
            return threads;
        }
        if (parent instanceof IScriptGroup) {
            IScriptGroup group = (IScriptGroup)parent;
            List scripts = group.allScripts();
            return this.getElements(scripts.toArray(), index, length);
        }
        if (parent instanceof IJavaScriptThread) {
            return ((IJavaScriptThread)parent).getStackFrames();
        }
        return NO_CHILDREN;
    }

    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        if (element instanceof IJavaScriptDebugTarget) {
            IJavaScriptDebugTarget target = (IJavaScriptDebugTarget)element;
            int count = target.getThreads().length;
            if (target.getScriptGroup() != null && PreferencesManager.getManager().showLoadedScripts()) {
                ++count;
            }
            return count;
        }
        if (element instanceof IScriptGroup) {
            return ((IScriptGroup)element).allScripts().size();
        }
        if (element instanceof IJavaScriptThread) {
            return ((IJavaScriptThread)element).getFrameCount();
        }
        return 0;
    }

    protected boolean supportsContext(IPresentationContext context) {
        return "org.eclipse.debug.ui.DebugView".equals(context.getId());
    }

    protected boolean supportsContextId(String id) {
        return "org.eclipse.debug.ui.DebugView".equals(id);
    }
}

