/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.propertypage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizardPage;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.propertypage.IReferenceWizardConstants;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ProjectReferenceWizardFragment
extends WizardFragment {
    protected LabelProvider labelProvider = null;
    protected ITreeContentProvider contentProvider = null;
    protected TreeViewer viewer;
    protected IProject[] selected;

    public ProjectReferenceWizardFragment() {
        this.setComplete(false);
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        handle.setTitle(Messages.ProjectReferenceTitle);
        handle.setDescription(Messages.ProjectReferenceDescription);
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "org.eclipse.wst.common.modulecore.ui.DEPLOYMENT_ASSEMBLY_PREFERENCE_PAGE_ADD_NEW_PROJECT_REFERENCE_P1");
        this.viewer = new TreeViewer(c, 2050);
        this.viewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectReferenceWizardFragment.this.selChanged();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectReferenceWizardFragment.this.advanceToNextPageOrFinish();
            }
        });
        this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
        GridData data = new GridData(1808);
        data.widthHint = 390;
        data.heightHint = 185;
        this.viewer.getTree().setLayoutData((Object)data);
        return c;
    }

    protected void selChanged() {
        if (this.viewer != null) {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            if (sel != null) {
                List selectionList = sel.toList();
                this.selected = selectionList.toArray(new IProject[selectionList.size()]);
                if (this.selected.length != 0) {
                    this.setComplete(true);
                } else {
                    this.setComplete(false);
                }
            } else {
                this.setComplete(false);
            }
        }
        ((TaskWizardPage)this.getPage()).update();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        VirtualReference[] refs = new VirtualReference[this.selected.length];
        String runtimeLoc = (String)this.getTaskModel().getObject("default.library.location");
        IReferenceWizardConstants.ProjectConverterOperationProvider converter = (IReferenceWizardConstants.ProjectConverterOperationProvider)this.getTaskModel().getObject("project.converter.operation.provider");
        runtimeLoc = runtimeLoc != null ? runtimeLoc : "/";
        int i = 0;
        while (i < this.selected.length) {
            IProject proj = this.selected[i];
            if (!ModuleCoreNature.isFlexibleProject((IProject)proj)) {
                this.convertProject(this.selected[i], converter, monitor);
            }
            refs[i] = new VirtualReference((IVirtualComponent)this.getTaskModel().getObject("root.component"), ComponentCore.createComponent((IProject)proj, (boolean)false));
            refs[i].setArchiveName(new Path(this.getArchiveName(proj, refs[i].getReferencedComponent())).lastSegment());
            refs[i].setRuntimePath(new Path(runtimeLoc).makeAbsolute());
            ++i;
        }
        this.getTaskModel().putObject("dependency.reference.final", refs);
    }

    protected void convertProject(IProject proj, IReferenceWizardConstants.ProjectConverterOperationProvider converter, IProgressMonitor monitor) {
        IDataModelOperation operation;
        if (converter != null && (operation = converter.getConversionOperation(proj)) != null) {
            try {
                operation.execute(monitor, null);
                return;
            }
            catch (ExecutionException ee) {
                ModuleCoreUIPlugin.log(NLS.bind((String)Messages.ProjectConversionError, (Object)proj.getName()), (Exception)((Object)ee));
            }
        }
        try {
            if (!ModuleCoreNature.isFlexibleProject((IProject)proj)) {
                ModuleCoreNature.addModuleCoreNatureIfNecessary((IProject)proj, (IProgressMonitor)monitor);
                ProjectFacetsManager.create((IProject)proj, (boolean)true, (IProgressMonitor)monitor);
            }
        }
        catch (CoreException ce) {
            ModuleCoreUIPlugin.log(NLS.bind((String)Messages.ProjectConversionError, (Object)proj.getName()), (Exception)((Object)ce));
        }
    }

    protected String getArchiveName(IProject proj, IVirtualComponent comp) {
        return this.getModuleHandler().getArchiveName(proj, comp);
    }

    protected IModuleHandler getModuleHandler() {
        return (IModuleHandler)this.getTaskModel().getObject("module.handler");
    }

    protected LabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new LabelProvider(){

                public Image getImage(Object element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }

                public String getText(Object element) {
                    if (element instanceof IProject) {
                        return ((IProject)element).getName();
                    }
                    return element == null ? "" : element.toString();
                }
            };
        }
        return this.labelProvider;
    }

    protected ITreeContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new ITreeContentProvider(){

                public Object[] getElements(Object inputElement) {
                    IProject cfr_ignored_0 = (IProject)ProjectReferenceWizardFragment.this.getTaskModel().getObject("root.project");
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    ArrayList currentRefs = (ArrayList)ProjectReferenceWizardFragment.this.getTaskModel().getObject("current.references");
                    ArrayList<IProject> availableList = this.getAvailableProjects(projects, currentRefs);
                    IVirtualComponent comp = (IVirtualComponent)ProjectReferenceWizardFragment.this.getTaskModel().getObject("root.component");
                    List filtered = ProjectReferenceWizardFragment.this.getModuleHandler().getFilteredProjectListForAdd(comp, availableList);
                    return filtered.toArray(new IProject[filtered.size()]);
                }

                private ArrayList<IProject> getAvailableProjects(IProject[] projects, ArrayList<IVirtualReference> currentRefs) {
                    if (currentRefs.isEmpty()) {
                        return new ArrayList<IProject>(Arrays.asList(projects));
                    }
                    ArrayList<IProject> availProjects = new ArrayList<IProject>();
                    int i = 0;
                    while (i < projects.length) {
                        IProject proj = projects[i];
                        boolean matches = false;
                        int j = 0;
                        while (j < currentRefs.size() && !matches) {
                            IVirtualReference ref = currentRefs.get(j);
                            if (ref.getReferencedComponent().getProject().equals((Object)proj) || availProjects.contains(proj)) {
                                matches = true;
                            }
                            ++j;
                        }
                        if (!matches) {
                            availProjects.add(proj);
                        }
                        ++i;
                    }
                    return availProjects;
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public boolean hasChildren(Object element) {
                    return false;
                }

                public Object getParent(Object element) {
                    return null;
                }

                public Object[] getChildren(Object parentElement) {
                    return null;
                }
            };
        }
        return this.contentProvider;
    }
}

