/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.application.internal.operations.RemoveReferenceFromEnterpriseApplicationDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEModuleHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.preferences.Messages;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.jst.jee.project.facet.EarCreateDeploymentFilesDataModelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.common.componentcore.internal.IModuleHandler;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;
import org.eclipse.wst.common.componentcore.ui.propertypage.IReferenceWizardConstants;
import org.eclipse.wst.common.componentcore.ui.propertypage.ModuleAssemblyRootPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarModuleDependenciesPropertyPage
extends AddModuleDependenciesPropertiesPage {
    private String libDir = null;
    private Text libDirText;

    public EarModuleDependenciesPropertyPage(IProject project, ModuleAssemblyRootPage page) {
        super(project, page);
    }

    protected void createTableComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gData = new GridData(1808);
        composite.setLayoutData((Object)gData);
        this.fillTableComposite(composite);
        if (JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)1) && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)0)) {
            this.addLibDirComposite(composite);
        }
    }

    private String loadLibDirString() {
        return EarUtilities.getEARLibDir((IVirtualComponent)this.rootComponent);
    }

    protected void addLibDirComposite(Composite parent) {
        this.libDir = this.loadLibDirString();
        if (this.libDir != null) {
            Composite c = new Composite(parent, 0);
            GridData mainData = new GridData(768);
            c.setLayoutData((Object)mainData);
            GridLayout gl = new GridLayout(2, false);
            c.setLayout((Layout)gl);
            Label l = new Label(c, 0);
            l.setText(Messages.EarModuleDependenciesPropertyPage_LIBDIR);
            this.libDirText = new Text(c, 2048);
            GridData gd = new GridData(768);
            this.libDirText.setLayoutData((Object)gd);
            this.libDirText.setText(this.libDir);
            this.libDirText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    EarModuleDependenciesPropertyPage.this.libDirTextModified();
                }
            });
        }
    }

    protected void libDirTextModified() {
        this.libDir = this.libDirText.getText();
    }

    protected IDataModelOperation generateEARDDOperation() {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EarCreateDeploymentFilesDataModelProvider());
        model.setProperty("ICreateDeploymentFilesDataModelProperties.GENERATE_DD", (Object)this.rootComponent);
        model.setProperty("ICreateDeploymentFilesDataModelProperties.TARGET_PROJECT", (Object)this.project);
        return model.getDefaultOperation();
    }

    public boolean postHandleChanges(IProgressMonitor monitor) {
        return true;
    }

    protected void handleRemoved(ArrayList<IVirtualReference> removed) {
        super.handleRemoved(removed);
        J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(this.rootComponent.getProject());
    }

    protected IDataModelProvider getAddReferenceDataModelProvider(IVirtualReference component) {
        return new AddReferenceToEnterpriseApplicationDataModelProvider();
    }

    protected String getModuleAssemblyRootPageDescription() {
        return Messages.EarModuleDependenciesPropertyPage_3;
    }

    protected IDataModelProvider getRemoveReferenceDataModelProvider(IVirtualReference component) {
        return new RemoveReferenceFromEnterpriseApplicationDataModelProvider();
    }

    protected DependencyPageExtensionManager.ReferenceExtension[] filterReferenceTypes(DependencyPageExtensionManager.ReferenceExtension[] defaults) {
        int i = 0;
        while (i < defaults.length) {
            if (defaults[i].getId().equals("org.eclipse.wst.common.componentcore.ui.newProjectReference")) {
                defaults[i] = DependencyPageExtensionManager.getManager().findReferenceExtension("org.eclipse.jst.j2ee.internal.ui.preferences.CustomEARProjectReferenceWizardFragment");
            }
            ++i;
        }
        return defaults;
    }

    protected void createDD(IProgressMonitor monitor) {
        if (this.rootComponent != null) {
            IDataModelOperation op = this.generateEARDDOperation();
            try {
                op.execute(monitor, null);
            }
            catch (ExecutionException e) {
                J2EEUIPlugin.logError(e);
            }
        }
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)1) && JavaEEProjectUtilities.isJEEComponent((IVirtualComponent)this.rootComponent, (int)0) && this.libDir != null) {
            this.updateLibDir();
        }
        return result;
    }

    private void updateLibDir() {
        IVirtualFile vFile;
        if (!this.libDir.equals("/lib") && !(vFile = this.rootComponent.getRootFolder().getFile((IPath)new Path("META-INF/application.xml"))).exists()) {
            if (!MessageDialog.openQuestion(null, (String)J2EEUIMessages.getResourceString("NO_DD_MSG_TITLE"), (String)J2EEUIMessages.getResourceString("GEN_DD_QUESTION"))) {
                return;
            }
            this.createDD((IProgressMonitor)new NullProgressMonitor());
        }
        final IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)this.project);
        Application app = (Application)earModel.getModelObject();
        String oldLibDir = app.getLibraryDirectory();
        if (this.libDir.equals("/lib")) {
            if (oldLibDir != null) {
                earModel.modify(new Runnable(){

                    public void run() {
                        Application app2 = (Application)earModel.getModelObject();
                        app2.setLibraryDirectory(null);
                    }
                }, null);
            }
        } else if (oldLibDir != null && !oldLibDir.equals(this.libDir) || oldLibDir == null) {
            earModel.modify(new Runnable(){

                public void run() {
                    Application app2 = (Application)earModel.getModelObject();
                    app2.setLibraryDirectory(EarModuleDependenciesPropertyPage.this.libDir);
                }
            }, null);
        }
    }

    protected void setCustomReferenceWizardProperties(TaskModel model) {
        model.putObject("default.library.location", (Object)this.libDir);
        model.putObject("project.converter.operation.provider", (Object)this.getConverterProvider());
    }

    public IReferenceWizardConstants.ProjectConverterOperationProvider getConverterProvider() {
        return new IReferenceWizardConstants.ProjectConverterOperationProvider(){

            public IDataModelOperation getConversionOperation(IProject project) {
                return J2EEProjectUtilities.createFlexJavaProjectForProjectOperation((IProject)project);
            }
        };
    }

    protected IModuleHandler getModuleHandler() {
        if (this.moduleHandler == null) {
            this.moduleHandler = new JavaEEModuleHandler();
        }
        return this.moduleHandler;
    }
}

