/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;

public class InMemoryNameEnvironment
implements INameEnvironment {
    INameEnvironment[] classLibs;
    HashtableOfObject compilationUnits = new HashtableOfObject();

    public InMemoryNameEnvironment(String[] compilationUnits, INameEnvironment[] classLibs) {
        this.classLibs = classLibs;
        int i = 0;
        int length = compilationUnits.length - 1;
        while (i < length) {
            String fileName = compilationUnits[i];
            char[] contents = compilationUnits[i + 1].toCharArray();
            String dirName = "";
            int lastSlash = -1;
            lastSlash = fileName.lastIndexOf(47);
            if (lastSlash != -1) {
                dirName = fileName.substring(0, lastSlash);
            }
            char[] packageName = dirName.replace('/', '.').toCharArray();
            char[] cuName = fileName.substring(lastSlash == -1 ? 0 : lastSlash + 1, fileName.length() - 3).toCharArray();
            HashtableOfObject cus = (HashtableOfObject)this.compilationUnits.get(packageName);
            if (cus == null) {
                cus = new HashtableOfObject();
                this.compilationUnits.put(packageName, (Object)cus);
            }
            CompilationUnit unit = new CompilationUnit(contents, fileName, null);
            cus.put(cuName, (Object)unit);
            i += 2;
        }
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName, ITypeRequestor requestor) {
        return this.findType(compoundTypeName[compoundTypeName.length - 1], CharOperation.subarray((char[][])compoundTypeName, (int)0, (int)(compoundTypeName.length - 1)), requestor);
    }

    public NameEnvironmentAnswer findBinding(char[] typeName, char[][] packageName, int type, ITypeRequestor requestor, boolean returnMultiple, String excludePath) {
        HashtableOfObject cus;
        if ((type & 0x2000) != 0 && (cus = (HashtableOfObject)this.compilationUnits.get(CharOperation.concatWith((char[][])packageName, (char)'.'))) != null) {
            CompilationUnit unit = (CompilationUnit)cus.get(typeName);
            unit.packageName = packageName;
            return new NameEnvironmentAnswer((ICompilationUnit)unit, null);
        }
        return this.findTypeFromClassLibs(typeName, packageName, type, requestor);
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, ITypeRequestor requestor) {
        return this.findBinding(typeName, packageName, 16388, requestor, false, null);
    }

    private NameEnvironmentAnswer findTypeFromClassLibs(char[] typeName, char[][] packageName, int type, ITypeRequestor requestor) {
        int i = 0;
        while (i < this.classLibs.length) {
            NameEnvironmentAnswer answer = this.classLibs[i].findBinding(typeName, packageName, type, requestor, false, null);
            if (answer != null) {
                return answer;
            }
            ++i;
        }
        return null;
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        char[] pkg = CharOperation.concatWith((char[][])parentPackageName, (char[])packageName, (char)'.');
        return this.compilationUnits.get(pkg) != null || this.isPackageFromClassLibs(parentPackageName, packageName);
    }

    public boolean isPackageFromClassLibs(char[][] parentPackageName, char[] packageName) {
        int i = 0;
        while (i < this.classLibs.length) {
            if (this.classLibs[i].isPackage(parentPackageName, packageName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void cleanup() {
        int i = 0;
        int max = this.classLibs.length;
        while (i < max) {
            this.classLibs[i].cleanup();
            ++i;
        }
        this.compilationUnits = new HashtableOfObject();
    }
}

