/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.internal.impl.ModuleImpl;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.jee.application.ICommonApplication;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.operation.RemoveReferenceComponentOperation;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class RemoveComponentFromEnterpriseApplicationOperation
extends RemoveReferenceComponentOperation {
    public RemoveComponentFromEnterpriseApplicationOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            this.updateEARDD(monitor);
            super.execute(monitor, info);
            IStatus iStatus = OK_STATUS;
            return iStatus;
        }
        finally {
            J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
        }
    }

    protected void updateEARDD(final IProgressMonitor monitor) {
        block15: {
            final IVirtualComponent comp = (IVirtualComponent)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT");
            if (!comp.getProject().isAccessible()) {
                return;
            }
            J2EEComponentClasspathUpdater.getInstance().queueUpdateEAR(comp.getProject());
            final IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider(comp.getProject());
            StructureEdit se = null;
            try {
                try {
                    se = StructureEdit.getStructureEditForWrite((IProject)comp.getProject());
                    WorkbenchComponent earwc = se.getComponent();
                    List list = (List)this.model.getProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT");
                    if (list == null || list.size() <= 0) break block15;
                    int i = 0;
                    while (i < list.size()) {
                        final IVirtualComponent wc = (IVirtualComponent)list.get(i);
                        StructureEdit compse = null;
                        try {
                            compse = StructureEdit.getStructureEditForWrite((IProject)wc.getProject());
                            if (compse != null) {
                                WorkbenchComponent refwc = compse.getComponent();
                                final ReferencedComponent ref = se.findReferencedComponent(earwc, refwc);
                                earModel.modify(new Runnable(){

                                    public void run() {
                                        IVirtualFile vFile;
                                        IFile iFile;
                                        ICommonApplication application = (ICommonApplication)earModel.getModelObject();
                                        if (application == null) {
                                            return;
                                        }
                                        IVirtualComponent moduleComponent = wc.getComponent();
                                        if (!moduleComponent.isBinary()) {
                                            J2EEComponentClasspathUpdater.getInstance().queueUpdateModule(moduleComponent.getProject());
                                        }
                                        Object module = RemoveComponentFromEnterpriseApplicationOperation.this.getModule(earModel, ref);
                                        String moduleURI = null;
                                        if (module != null) {
                                            if (module instanceof ModuleImpl) {
                                                moduleURI = ((ModuleImpl)module).getUri();
                                            } else if (module instanceof org.eclipse.jst.javaee.application.internal.impl.ModuleImpl) {
                                                moduleURI = ((org.eclipse.jst.javaee.application.internal.impl.ModuleImpl)module).getUri();
                                            }
                                            if (moduleURI != null) {
                                                Path path1 = new Path(ref.getArchiveName());
                                                Path path2 = new Path(moduleURI);
                                                boolean removed = false;
                                                if (path1.lastSegment().equals(path2.lastSegment()) && RemoveComponentFromEnterpriseApplicationOperation.this.removeModule(application, module)) {
                                                    removed = true;
                                                }
                                                if (!removed) {
                                                    module = null;
                                                    moduleURI = null;
                                                }
                                            }
                                        }
                                        if (module == null && (module = RemoveComponentFromEnterpriseApplicationOperation.this.getModuleFromURI(earModel, ref.getArchiveName())) != null) {
                                            if (module instanceof Module) {
                                                moduleURI = ((Module)module).getUri();
                                            } else if (module instanceof ModuleImpl) {
                                                moduleURI = ((ModuleImpl)module).getUri();
                                            }
                                            RemoveComponentFromEnterpriseApplicationOperation.this.removeModule(application, module);
                                        }
                                        if (moduleURI != null && (iFile = (vFile = comp.getRootFolder().getFile(moduleURI)).getUnderlyingFile()).exists()) {
                                            try {
                                                iFile.delete(true, monitor);
                                            }
                                            catch (CoreException e) {
                                                J2EEPlugin.logError(e);
                                            }
                                        }
                                    }
                                }, null);
                            } else {
                                earModel.modify(new Runnable(){

                                    public void run() {
                                        IVirtualFile vFile;
                                        IFile iFile;
                                        String moduleURI;
                                        Object module;
                                        ICommonApplication application = (ICommonApplication)earModel.getModelObject();
                                        if (application == null) {
                                            return;
                                        }
                                        IVirtualComponent moduleComponent = wc.getComponent();
                                        if (!moduleComponent.isBinary()) {
                                            J2EEComponentClasspathUpdater.getInstance().queueUpdateModule(moduleComponent.getProject());
                                        }
                                        if ((module = RemoveComponentFromEnterpriseApplicationOperation.this.getModuleFromURI(earModel, moduleURI = RemoveComponentFromEnterpriseApplicationOperation.this.getModuleURI(earModel, wc))) != null) {
                                            if (module instanceof Module) {
                                                moduleURI = ((Module)module).getUri();
                                            } else if (module instanceof ModuleImpl) {
                                                moduleURI = ((ModuleImpl)module).getUri();
                                            }
                                            RemoveComponentFromEnterpriseApplicationOperation.this.removeModule(application, module);
                                        }
                                        if (moduleURI != null && (iFile = (vFile = comp.getRootFolder().getFile(moduleURI)).getUnderlyingFile()).exists()) {
                                            try {
                                                iFile.delete(true, monitor);
                                            }
                                            catch (CoreException e) {
                                                J2EEPlugin.logError(e);
                                            }
                                        }
                                    }
                                }, null);
                            }
                        }
                        finally {
                            if (compse != null) {
                                compse.saveIfNecessary(monitor);
                                compse.dispose();
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception e) {
                    J2EEPlugin.logError(e);
                    if (se != null) {
                        se.saveIfNecessary(monitor);
                        se.dispose();
                    }
                }
            }
            finally {
                if (se != null) {
                    se.saveIfNecessary(monitor);
                    se.dispose();
                }
            }
        }
    }

    protected Object getModule(IEARModelProvider earModel, ReferencedComponent refComp) {
        EObject moduleObj;
        block5: {
            Object app;
            block4: {
                app = earModel.getModelObject();
                moduleObj = refComp.getDependentObject();
                if (!(app instanceof org.eclipse.jst.javaee.application.Application)) break block4;
                List modules = ((org.eclipse.jst.javaee.application.Application)app).getModules();
                if (moduleObj == null) break block5;
                for (Module curModule : modules) {
                    if (curModule == null || curModule.getUri() == null || curModule.getId() == null || (!(moduleObj instanceof org.eclipse.jst.javaee.application.internal.impl.ModuleImpl) || !curModule.getId().equals(((Module)moduleObj).getId())) && (!(moduleObj instanceof ModuleImpl) || !curModule.getId().equals(((ModuleImpl)moduleObj).getId()))) continue;
                    return curModule;
                }
                break block5;
            }
            if (app instanceof Application) {
                EList modules = ((Application)app).getModules();
                if (moduleObj != null && moduleObj instanceof ModuleImpl) {
                    for (ModuleImpl curModule : modules) {
                        if (curModule == null || curModule.getUri() == null || curModule.getId() == null || (!(moduleObj instanceof org.eclipse.jst.javaee.application.internal.impl.ModuleImpl) || !curModule.getId().equals(((Module)moduleObj).getId())) && (!(moduleObj instanceof ModuleImpl) || !curModule.getId().equals(((ModuleImpl)moduleObj).getId()))) continue;
                        return curModule;
                    }
                }
            }
        }
        return moduleObj;
    }

    protected Object getModuleFromURI(IEARModelProvider earModel, String uri) {
        block4: {
            String archiveName;
            Object app;
            block3: {
                app = earModel.getModelObject();
                if (uri == null) {
                    return null;
                }
                archiveName = new Path(uri).lastSegment();
                if (!(app instanceof org.eclipse.jst.javaee.application.Application)) break block3;
                List modules = ((org.eclipse.jst.javaee.application.Application)app).getModules();
                for (Module curModule : modules) {
                    if (curModule == null || curModule.getUri() == null || !new Path(curModule.getUri()).lastSegment().equals(archiveName)) continue;
                    return curModule;
                }
                break block4;
            }
            if (!(app instanceof Application)) break block4;
            EList modules = ((Application)app).getModules();
            for (ModuleImpl curModule : modules) {
                if (curModule == null || curModule.getUri() == null || !new Path(curModule.getUri()).lastSegment().equals(archiveName)) continue;
                return curModule;
            }
        }
        return null;
    }

    protected String getModuleURI(IEARModelProvider earModule, IVirtualComponent targetComponent) {
        return earModule.getModuleURI(targetComponent);
    }

    protected void removeModule(ICommonApplication application, String moduleURI) {
        ICommonModule module = application.getFirstEARModule(moduleURI);
        application.getEARModules().remove(module);
    }

    protected boolean removeModule(ICommonApplication application, Object module) {
        return application.getEARModules().remove(module);
    }
}

