/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.UnresolvedReferenceBinding;

public final class ArrayBinding
extends ReferenceBinding {
    public static final FieldBinding ArrayLength = new FieldBinding(TypeConstants.LENGTH, (TypeBinding)TypeBinding.INT, 17, null);
    public TypeBinding leafComponentType;
    public int dimensions;
    LookupEnvironment environment;
    char[] constantPoolName;
    char[] genericTypeSignature;
    ReferenceBinding referenceBinding;

    public ArrayBinding(TypeBinding type, int dimensions, LookupEnvironment environment) {
        this.tagBits |= 1L;
        this.leafComponentType = type;
        this.dimensions = dimensions;
        this.environment = environment;
        if (type instanceof UnresolvedReferenceBinding) {
            ((UnresolvedReferenceBinding)type).addWrapper(this, environment);
        }
        this.referenceBinding = environment.getResolvedType(TypeConstants.ARRAY, null);
        this.fPackage = environment.defaultPackage;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        return CharOperation.concat(brackets, this.leafComponentType.computeUniqueKey(isLeaf));
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        char[] brackets = new char[this.dimensions];
        int i = this.dimensions - 1;
        while (i >= 0) {
            brackets[i] = 91;
            --i;
        }
        this.constantPoolName = CharOperation.concat(brackets, this.leafComponentType.signature());
        return this.constantPoolName;
    }

    public String debugName() {
        StringBuffer brackets = new StringBuffer(this.dimensions * 2);
        int i = this.dimensions;
        while (--i >= 0) {
            brackets.append("[]");
        }
        return String.valueOf(this.leafComponentType.debugName()) + brackets.toString();
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding elementsType() {
        if (this.dimensions == 1) {
            return this.leafComponentType;
        }
        return this.environment.createArrayType(this.leafComponentType, this.dimensions - 1);
    }

    public LookupEnvironment environment() {
        return this.environment;
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            char[] brackets = new char[this.dimensions];
            int i = this.dimensions - 1;
            while (i >= 0) {
                brackets[i] = 91;
                --i;
            }
            this.genericTypeSignature = CharOperation.concat(brackets, this.leafComponentType.signature());
        }
        return this.genericTypeSignature;
    }

    public PackageBinding getPackage() {
        return this.leafComponentType.getPackage();
    }

    public int hashCode() {
        return this.leafComponentType == null ? super.hashCode() : this.leafComponentType.hashCode();
    }

    public boolean isCompatibleWith(TypeBinding otherType) {
        if (this == otherType) {
            return true;
        }
        switch (otherType.kind()) {
            case 68: {
                ArrayBinding otherArray = (ArrayBinding)otherType;
                return this.leafComponentType.isCompatibleWith(otherArray.leafComponentType);
            }
            case 132: {
                return otherType.isAnyType();
            }
            case 4: {
                return otherType == this.referenceBinding;
            }
        }
        switch (otherType.leafComponentType().id) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int kind() {
        return 68;
    }

    public TypeBinding leafComponentType() {
        return this.leafComponentType;
    }

    public int problemId() {
        return this.leafComponentType.problemId();
    }

    public char[] qualifiedSourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.qualifiedSourceName(), brackets);
    }

    public char[] readableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.readableName(), brackets);
    }

    public char[] shortReadableName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.shortReadableName(), brackets);
    }

    public char[] sourceName() {
        char[] brackets = new char[this.dimensions * 2];
        int i = this.dimensions * 2 - 1;
        while (i >= 0) {
            brackets[i] = 93;
            brackets[i - 1] = 91;
            i -= 2;
        }
        return CharOperation.concat(this.leafComponentType.sourceName(), brackets);
    }

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedType, ReferenceBinding resolvedType, LookupEnvironment env) {
        if (this.leafComponentType == unresolvedType) {
            this.leafComponentType = resolvedType;
            this.tagBits |= this.leafComponentType.tagBits;
        }
    }

    public String toString() {
        return this.leafComponentType != null ? this.debugName() : "NULL TYPE ARRAY";
    }

    public FieldBinding[] availableFields() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.availableFields();
        }
        return new FieldBinding[0];
    }

    public MethodBinding[] availableMethods() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.availableMethods();
        }
        return new MethodBinding[0];
    }

    public int fieldCount() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.fieldCount();
        }
        return 0;
    }

    public FieldBinding[] fields() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.fields();
        }
        return new FieldBinding[0];
    }

    public InferredType getInferredType() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getInferredType();
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getMethods(selector);
        }
        return new MethodBinding[0];
    }

    boolean implementsMethod(MethodBinding method) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.implementsMethod(method);
        }
        return false;
    }

    public MethodBinding[] methods() {
        if (this.referenceBinding != null) {
            return this.referenceBinding.methods();
        }
        return new MethodBinding[0];
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getExactMethod(selector, argumentTypes, refScope);
        }
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        if (this.referenceBinding != null) {
            return this.referenceBinding.getField(fieldName, needResolve);
        }
        return null;
    }
}

