/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredField;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredStatement;

public class RecoveredUnit
extends RecoveredElement {
    public CompilationUnitDeclaration unitDeclaration;
    public RecoveredElement[] statements;
    public int statementCount;

    public RecoveredUnit(CompilationUnitDeclaration unitDeclaration, int bracketBalance, Parser parser) {
        super(null, bracketBalance, parser);
        this.unitDeclaration = unitDeclaration;
    }

    public RecoveredElement add(AbstractMethodDeclaration methodDeclaration, int bracketBalanceValue) {
        RecoveredMethod element = new RecoveredMethod(methodDeclaration, this, bracketBalanceValue, this.recoveringParser);
        this.addStatement(element);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (methodDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int bracketBalanceValue) {
        RecoveredField element = new RecoveredField(fieldDeclaration, this, bracketBalanceValue);
        this.addStatement(element);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (fieldDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalanceValue) {
        RecoveredLocalVariable element = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.addStatement(element);
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        if (localDeclaration.declarationSourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(ImportReference importReference, int bracketBalanceValue) {
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        return this;
    }

    private void addStatement(RecoveredElement statement) {
        if (this.statements == null) {
            this.statements = new RecoveredElement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredElement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = statement;
    }

    public ASTNode parseTree() {
        return this.unitDeclaration;
    }

    public int sourceEnd() {
        return this.unitDeclaration.sourceEnd;
    }

    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered unit: [\n");
        this.unitDeclaration.print(tab + 1, result);
        result.append(this.tabString(tab + 1));
        result.append("]");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statementCount) {
                result.append("\n");
                result.append(this.statements[i].toString(tab + 1));
                ++i;
            }
        }
        return result.toString();
    }

    public CompilationUnitDeclaration updatedCompilationUnitDeclaration() {
        int sourceEnd;
        int n = sourceEnd = this.unitDeclaration.sourceEnd > 0 ? this.unitDeclaration.sourceEnd : this.parser().scanner.eofPosition;
        if (this.statementCount > 0) {
            int existingCount = this.unitDeclaration.statements == null ? 0 : this.unitDeclaration.statements.length;
            ProgramElement[] stmts = new ProgramElement[existingCount + this.statementCount];
            if (existingCount > 0) {
                System.arraycopy(this.unitDeclaration.statements, 0, stmts, 0, existingCount);
            }
            ASTNode astNode = this.statements[this.statementCount - 1].parseTree();
            if (astNode.sourceEnd == 0) {
                astNode.sourceEnd = sourceEnd;
                if (astNode instanceof Assignment) {
                    Assignment assign = (Assignment)astNode;
                    if (assign.expression instanceof FunctionExpression) {
                        FunctionExpression functionExpression = (FunctionExpression)assign.expression;
                        functionExpression.sourceEnd = astNode.sourceEnd;
                        functionExpression.methodDeclaration.bodyEnd = functionExpression.methodDeclaration.sourceEnd = astNode.sourceEnd;
                    }
                }
            }
            if (astNode instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)astNode).bodyEnd <= 0) {
                ((AbstractMethodDeclaration)astNode).bodyEnd = this.unitDeclaration.sourceEnd;
            }
            int actualCount = existingCount;
            int i = 0;
            while (i < this.statementCount) {
                ProgramElement updatedASTNode = this.statements[i].updatedASTNode();
                if (updatedASTNode != null && updatedASTNode.sourceEnd <= 0) {
                    updatedASTNode.sourceEnd = this.unitDeclaration.sourceEnd;
                }
                if (updatedASTNode instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)updatedASTNode).bodyEnd <= 0) {
                    ((AbstractMethodDeclaration)updatedASTNode).bodyEnd = this.unitDeclaration.sourceEnd;
                } else if (updatedASTNode instanceof AbstractVariableDeclaration && ((AbstractVariableDeclaration)updatedASTNode).declarationSourceEnd <= 0) {
                    ((AbstractVariableDeclaration)updatedASTNode).declarationSourceEnd = this.unitDeclaration.sourceEnd;
                }
                stmts[actualCount++] = updatedASTNode;
                ++i;
            }
            this.unitDeclaration.statements = stmts;
        } else if (this.unitDeclaration.statements == null) {
            this.unitDeclaration.statements = new ProgramElement[0];
        }
        return this.unitDeclaration;
    }

    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        RecoveredBlock element = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalanceValue);
        if (this.parser().statementRecoveryActivated) {
            this.addBlockStatement(element);
        }
        this.addStatement(element);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return element;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        RecoveredStatement element = new RecoveredStatement(statement, this, bracketBalanceValue);
        this.addStatement(element);
        if (statement.sourceEnd == 0) {
            return element;
        }
        return this;
    }

    public void updateParseTree() {
        this.updatedCompilationUnitDeclaration();
    }

    public void updateSourceEndIfNecessary(int bodyStart, int bodyEnd) {
        if (this.unitDeclaration.sourceEnd == 0) {
            this.unitDeclaration.sourceEnd = bodyEnd;
        }
    }

    public ProgramElement updatedASTNode() {
        throw new UnimplementedException();
    }

    public void updateFromParserState() {
        int cfr_ignored_0 = this.parser().astPtr;
    }
}

