/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.iterators;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIterator<E>
implements Iterator<E> {
    final E[] array;
    int cursor;
    private final int max;

    public ArrayIterator(E ... array) {
        this(array, 0, array.length);
    }

    public ArrayIterator(E[] array, int start) {
        this(array, start, array.length - start);
    }

    public ArrayIterator(E[] array, int start, int length) {
        if (start < 0 || start > array.length) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (length < 0 || length > array.length - start) {
            throw new IllegalArgumentException("length: " + length);
        }
        this.array = array;
        this.cursor = start;
        this.max = start + length;
    }

    @Override
    public boolean hasNext() {
        return this.cursor != this.max;
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.array[this.cursor++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return StringTools.buildToStringFor(this, Arrays.toString(this.array));
    }
}

