/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.utility.model.event.TreeAddEvent;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.event.TreeClearEvent;
import org.eclipse.jpt.utility.model.event.TreeRemoveEvent;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;

public final class AWTTreeChangeListenerWrapper
implements TreeChangeListener {
    private final TreeChangeListener listener;

    public AWTTreeChangeListenerWrapper(TreeChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void nodeAdded(TreeAddEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.nodeAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildNodeAddedRunnable(event));
        }
    }

    public void nodeRemoved(TreeRemoveEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.nodeRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildNodeRemovedRunnable(event));
        }
    }

    public void treeCleared(TreeClearEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.treeCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildTreeClearedRunnable(event));
        }
    }

    public void treeChanged(TreeChangeEvent event) {
        if (this.isExecutingOnUIThread()) {
            this.treeChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildTreeChangedRunnable(event));
        }
    }

    private Runnable buildNodeAddedRunnable(final TreeAddEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.nodeAdded_(event);
            }

            public String toString() {
                return "node added";
            }
        };
    }

    private Runnable buildNodeRemovedRunnable(final TreeRemoveEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.nodeRemoved_(event);
            }

            public String toString() {
                return "node removed";
            }
        };
    }

    private Runnable buildTreeClearedRunnable(final TreeClearEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.treeCleared_(event);
            }

            public String toString() {
                return "tree cleared";
            }
        };
    }

    private Runnable buildTreeChangedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.treeChanged_(event);
            }

            public String toString() {
                return "tree changed";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return EventQueue.isDispatchThread();
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void nodeAdded_(TreeAddEvent event) {
        this.listener.nodeAdded(event);
    }

    void nodeRemoved_(TreeRemoveEvent event) {
        this.listener.nodeRemoved(event);
    }

    void treeCleared_(TreeClearEvent event) {
        this.listener.treeCleared(event);
    }

    void treeChanged_(TreeChangeEvent event) {
        this.listener.treeChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ')';
    }
}

