/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.internal.enumerations.EmptyEnumeration;
import org.eclipse.jpt.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.utility.internal.iterators.ArrayIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionToolsTests
extends TestCase {
    public CollectionToolsTests(String name) {
        super(name);
    }

    public void testAddAllCollectionIterable_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterable_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterable_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> iterable2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(iterable2));
    }

    public void testAddAllCollectionIterable_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> iterable3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(iterable3));
    }

    public void testAddAllCollectionIterable_EmptyIterable() {
        Set<Object> set1 = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, (Iterable)EmptyIterable.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
    }

    public void testAddAllCollectionIterableInt_Modified() {
        List<String> list2;
        List<String> list1 = this.buildStringList1();
        List<String> iterable2 = list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, iterable2, (int)list2.size()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(this.buildStringList2()));
    }

    public void testAddAllCollectionIterableInt_Unmodified() {
        List<String> list1;
        Set<String> set1 = this.buildStringSet1();
        List<String> iterable3 = list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, iterable3, (int)list1.size()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(this.buildStringList1()));
    }

    public void testAddAllCollectionIterator_StringModified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_StringUnmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_ObjectModified() {
        List<Object> list1 = this.buildObjectList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator()));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIterator_ObjectUnmodified() {
        Set<Object> set1 = this.buildObjectSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator()));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIterator_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionIteratorInt_Modified() {
        List<String> list1 = this.buildStringList1();
        List<String> list2 = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list1, list2.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)6, (int)list1.size());
        CollectionToolsTests.assertTrue((boolean)list1.containsAll(list2));
    }

    public void testAddAllCollectionIteratorInt_Unmodified() {
        Set<String> set1 = this.buildStringSet1();
        List<String> list3 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set1, list3.iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)3, (int)set1.size());
        CollectionToolsTests.assertTrue((boolean)set1.containsAll(list3));
    }

    public void testAddAllCollectionIteratorInt_EmptyIterator() {
        List<String> list1 = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list1, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)3, (int)list1.size());
    }

    public void testAddAllCollectionObjectArray_StringModified() {
        List<String> list = this.buildStringList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_StringListEmptyArray() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(list, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringUnmodified() {
        Set<String> set = this.buildStringSet1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_StringSetEmptyArray() {
        Set<String> set = this.buildStringSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])new String[0]));
    }

    public void testAddAllCollectionObjectArray_ObjectModified() {
        List<Object> list = this.buildObjectList1();
        Object[] a = this.buildStringArray1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.addAll(list, (Object[])a));
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testAddAllCollectionObjectArray_ObjectUnmodified() {
        Object[] a = this.buildStringArray1();
        Set<Object> set = this.buildObjectSet1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.addAll(set, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)set.size());
        CollectionToolsTests.assertTrue((boolean)set.containsAll((Collection<?>)CollectionTools.collection((Object[])a)));
    }

    public void testAddAllListIntObjectArray() {
        List<String> list = this.buildStringList1();
        CollectionTools.addAll(list, (int)2, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_Zero() {
        ArrayList list = new ArrayList();
        CollectionTools.addAll(list, (int)0, (Object[])new String[]{"X", "X", "X"});
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntObjectArray_EmptyArray() {
        List<String> list = this.buildStringList1();
        CollectionTools.addAll(list, (int)2, (Object[])new String[0]);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable() {
        List<String> list = this.buildStringList1();
        List<String> iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)2, iterable);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterable_Zero() {
        ArrayList list = new ArrayList();
        List<String> iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)0, iterable);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterable_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        CollectionTools.addAll(list, (int)2, (Iterable)iterable);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt() {
        List<String> list = this.buildStringList1();
        List<String> iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)2, iterable, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_Zero() {
        ArrayList list = new ArrayList();
        List<String> iterable = Arrays.asList("X", "X", "X");
        CollectionTools.addAll(list, (int)0, iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterableInt_EmptyIterable() {
        List<String> list = this.buildStringList1();
        Iterable iterable = EmptyIterable.instance();
        CollectionTools.addAll(list, (int)2, (Iterable)iterable, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)2, iterator);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIterator_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)0, iterator);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIterator_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        CollectionTools.addAll(list, (int)2, (Iterator)iterator);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt() {
        List<String> list = this.buildStringList1();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)2, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)6, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "X", "X", "X", "two"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_Zero() {
        ArrayList list = new ArrayList();
        Iterator<String> iterator = Arrays.asList("X", "X", "X").iterator();
        CollectionTools.addAll(list, (int)0, iterator, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)list.contains("X"));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, list.toArray()));
    }

    public void testAddAllListIntIteratorInt_EmptyIterator() {
        List<String> list = this.buildStringList1();
        Iterator iterator = EmptyIterator.instance();
        CollectionTools.addAll(list, (int)2, (Iterator)iterator, (int)0);
        CollectionToolsTests.assertEquals((int)3, (int)list.size());
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"zero", "one", "two"}, list.toArray()));
    }

    public void testBagEnumeration_String() {
        HashBag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumeration_Object() {
        HashBag b = CollectionTools.bag(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumeration_Empty() {
        HashBag b = CollectionTools.bag((Enumeration)EmptyEnumeration.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagEnumerationInt() {
        HashBag b = CollectionTools.bag(this.buildStringVector1().elements(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringVector1()));
    }

    public void testBagEnumerationInt_Empty() {
        HashBag b = CollectionTools.bag((Enumeration)EmptyEnumeration.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagIterable() {
        List<String> iterable = this.buildStringList1();
        HashBag b = CollectionTools.bag(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterableInt() {
        List<String> iterable = this.buildStringList1();
        HashBag b = CollectionTools.bag(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_String() {
        HashBag b = CollectionTools.bag(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIterator_StringObject() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        HashBag b = CollectionTools.bag(c.iterator());
        CollectionToolsTests.assertEquals((int)4, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(c));
    }

    public void testBagIterator_Empty() {
        HashBag b = CollectionTools.bag((Iterator)EmptyIterator.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagIteratorInt() {
        HashBag b = CollectionTools.bag(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)b.containsAll(this.buildStringList1()));
    }

    public void testBagIteratorInt_Empty() {
        HashBag b = CollectionTools.bag((Iterator)EmptyIterator.instance(), (int)3);
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testBagObjectArray() {
        HashBag b = CollectionTools.bag((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])this.buildStringArray1()));
    }

    public void testBagObjectArray_Vararg() {
        HashBag b = CollectionTools.bag((Object[])new String[]{"foo", "bar", "baz"});
        CollectionToolsTests.assertEquals((int)3, (int)b.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)b, (Object[])new Object[]{"foo", "bar", "baz"}));
    }

    public void testBagObjectArray_Empty() {
        HashBag b = CollectionTools.bag((Iterable)Bag.Empty.instance());
        CollectionToolsTests.assertEquals((int)0, (int)b.size());
    }

    public void testCollectionEnumeration() {
        HashBag c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionEnumeration_ObjectString() {
        HashBag c = CollectionTools.collection(this.buildStringVector1().elements());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionEnumerationInt() {
        HashBag c = CollectionTools.collection(this.buildStringVector1().elements(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringVector1()));
    }

    public void testCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        HashBag c = CollectionTools.collection(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterableInt() {
        List<String> iterable = this.buildStringList1();
        HashBag c = CollectionTools.collection(iterable, (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIterator_ObjectString() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionIteratorInt() {
        HashBag c = CollectionTools.collection(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)c.containsAll(this.buildStringList1()));
    }

    public void testCollectionObjectArray() {
        HashBag c = CollectionTools.collection((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll((Collection)c, (Object[])this.buildStringArray1()));
    }

    public void testContainsEnumerationObject_String() {
        Vector<String> v = this.buildStringVector1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(v.elements(), null));
        v.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(v.elements(), null));
    }

    public void testContainsEnumerationObject_Object() {
        Vector<String> c = new Vector<String>();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.elements(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.elements(), null));
    }

    public void testContainsIterableObject() {
        List<String> c;
        List<String> iterable = c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(iterable, (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(iterable, null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(iterable, null));
    }

    public void testContainsIteratorObject_String() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)"one"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsIteratorObject_Object() {
        HashBag c = new HashBag();
        c.add("zero");
        c.add("one");
        c.add("two");
        c.add("three");
        String one = "one";
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), (Object)one));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.contains(c.iterator(), null));
        c.add(null);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.contains(c.iterator(), null));
    }

    public void testContainsAllCollectionIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), iterable));
    }

    public void testContainsAllCollectionIterator_String() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), this.buildStringList1().iterator()));
    }

    public void testContainsAllCollectionIterator_Object() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("two");
        c2.add("zero");
        c2.add("one");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1, c2.iterator()));
    }

    public void testContainsAllCollectionObjectArray_StringObject() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllCollectionObjectArray() {
        Object[] a = new Object[]{"zero", "one", "two"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1(), (Object[])a));
    }

    public void testContainsAllIterableCollection() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, this.buildStringList1()));
    }

    public void testContainsAllIterableIntCollection() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, this.buildStringList1()));
    }

    public void testContainsAllIterableIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable1, iterable2));
    }

    public void testContainsAllIterableIntIterable() {
        List<String> iterable1 = this.buildStringList1();
        List<String> iterable2 = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable1, (int)3, iterable2));
    }

    public void testContainsAllIterableIterator() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableIntIterator() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, this.buildStringList1().iterator()));
    }

    public void testContainsAllIterableObjectArray() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(iterable, (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllIterableIntObjectArray() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(iterable, (int)3, (Object[])this.buildObjectArray1()));
    }

    public void testContainsAllIteratorCollection_StringString() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2()));
    }

    public void testContainsAllIteratorCollection_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2));
    }

    public void testContainsAllIteratorIntCollection() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)5, this.buildStringList2()));
    }

    public void testContainsAllIteratorIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), iterable));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), iterable));
    }

    public void testContainsAllIteratorIntIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, iterable));
    }

    public void testContainsAllIteratorIterator_StringString() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList1().iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(c1.iterator(), c2.iterator()));
    }

    public void testContainsAllIteratorIntIterator() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList1().iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, this.buildStringList2().iterator()));
    }

    public void testContainsAllIteratorObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllIteratorIntObjectArray() {
        CollectionToolsTests.assertTrue((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.containsAll(this.buildStringList1().iterator(), (int)3, (Object[])this.buildObjectArray2()));
    }

    public void testDiffEndListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.diffEnd(list1, list2));
    }

    public void testDiffRangeListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        CollectionToolsTests.assertEquals((Object)new Range(3, -1), (Object)CollectionTools.diffRange(list1, list2));
    }

    public void testDiffStartListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add(new String("a"));
        list2.add(new String("b"));
        list2.add(new String("c"));
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.diffStart(list1, list2));
    }

    public void testIdentityDiffEndListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.identityDiffEnd(list1, list2));
    }

    public void testIdentityDiffRangeListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        CollectionToolsTests.assertEquals((Object)new Range(3, -1), (Object)CollectionTools.identityDiffRange(list1, list2));
    }

    public void testIdentityDiffStartListList() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("a");
        list1.add("b");
        list1.add("c");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("a");
        list2.add("b");
        list2.add("c");
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.identityDiffStart(list1, list2));
    }

    public void testElementsAreDifferentIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList list2 = new ArrayList();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreDifferent(list1, list2));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreDifferentIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList list2 = new ArrayList();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreDifferent(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreEqualIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreIdentical(list1, list2));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreDifferent(list1, list2));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(list1, list2));
    }

    public void testElementsAreEqualIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("1000");
        list1.add("2000");
        list1.add("3000");
        list1.add("4000");
        ArrayList<String> list2 = new ArrayList<String>();
        int i = 0;
        while (i < list1.size()) {
            list2.add(String.valueOf((i + 1) * 1000));
            ++i;
        }
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreDifferent(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIterableIterable() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> iterable1 = list1;
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        ArrayList<String> iterable2 = list2;
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreIdentical(iterable1, iterable2));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(iterable1, iterable2));
    }

    public void testElementsAreIdenticalIteratorIterator() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIteratorIterator_Not() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(0);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testElementsAreIdenticalIteratorIterator_DifferentSizes() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList<String> list2 = new ArrayList<String>();
        for (String s : list1) {
            list2.add(s);
        }
        list2.remove(3);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreIdentical(list1.iterator(), list2.iterator()));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.elementsAreEqual(list1.iterator(), list2.iterator()));
    }

    public void testGetIterableInt() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        String o = (String)CollectionTools.get(iterable, (int)1);
        CollectionToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)CollectionTools.get(iterable, (int)3);
        CollectionToolsTests.assertNull((Object)o);
    }

    public void testGetIteratorInt1() {
        List<String> list = this.buildStringList1();
        String o = (String)CollectionTools.get(list.iterator(), (int)1);
        CollectionToolsTests.assertEquals((String)"one", (String)o);
        list.add(null);
        o = (String)CollectionTools.get(list.iterator(), (int)(list.size() - 1));
        CollectionToolsTests.assertNull((Object)o);
    }

    public void testGetIteratorInt2() {
        List<String> list = this.buildStringList1();
        boolean exCaught = false;
        try {
            CollectionTools.get(list.iterator(), (int)list.size());
            CollectionToolsTests.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testHashCodeIterable1() {
        Iterable iterable = null;
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.hashCode(iterable));
    }

    public void testHashCodeIterable2() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        int hashCode = CollectionTools.hashCode(iterable);
        CollectionToolsTests.assertEquals((int)list.hashCode(), (int)hashCode);
        list.add(null);
        hashCode = CollectionTools.hashCode(iterable);
        CollectionToolsTests.assertEquals((int)list.hashCode(), (int)hashCode);
    }

    public void testIndexOfIterableObject_String() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf(iterable, (Object)"one"));
    }

    public void testIndexOfIteratorObject_String() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf(list.iterator(), (Object)"one"));
    }

    public void testIndexOfIteratorObject_String_Not() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.indexOf(list.iterator(), null));
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.indexOf(list.iterator(), (Object)"shazam"));
    }

    public void testIndexOfIteratorObject_Null() {
        List<String> list = this.buildStringList1();
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf(list.iterator(), null));
    }

    public void testIndexOfIteratorObject_Object() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        String one = "1";
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.indexOf(list.iterator(), (Object)one));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.indexOf(list.iterator(), null));
    }

    public void testInsertionIndexOfListComparable() {
        List<String> list = Arrays.asList("A", "C", "D");
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)4, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"B")));
        list = Arrays.asList("A", "B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"E")));
        list = Arrays.asList("B", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
        list = Arrays.asList("A", "A", "B", "B", "C", "D");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfListObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        List<String> list = Arrays.asList("D", "C", "A");
        CollectionToolsTests.assertEquals((int)2, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "A");
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"B", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B", "A");
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.insertionIndexOf(list, (Object)"E", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "B");
        CollectionToolsTests.assertEquals((int)5, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
        list = Arrays.asList("D", "C", "B", "B", "A", "A");
        CollectionToolsTests.assertEquals((int)6, (int)CollectionTools.insertionIndexOf(list, (Object)"A", (Comparator)c));
    }

    public void testIsEmptyIterable() {
        CollectionToolsTests.assertFalse((boolean)CollectionTools.isEmpty(this.buildObjectList1()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.isEmpty((Iterable)EmptyIterable.instance()));
    }

    public void testIsEmptyIterator() {
        CollectionToolsTests.assertFalse((boolean)CollectionTools.isEmpty(this.buildObjectList1().iterator()));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.isEmpty((Iterator)EmptyIterator.instance()));
    }

    public void testIterableObjectArray() {
        Object[] strings = this.buildStringArray1();
        int i = 0;
        for (String string : CollectionTools.iterable((Object[])strings)) {
            CollectionToolsTests.assertEquals((String)strings[i++], (String)string);
        }
    }

    public void testIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        Iterator stream = CollectionTools.iterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testLastIterable1() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        CollectionToolsTests.assertEquals((String)"two", (String)((String)CollectionTools.last(iterable)));
        list.add(null);
        CollectionToolsTests.assertEquals(null, (String)((String)CollectionTools.last(iterable)));
    }

    public void testLastIterable2() {
        ArrayList iterable = new ArrayList();
        boolean exCaught = false;
        try {
            CollectionTools.last(iterable);
            CollectionToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testLastIterator1() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((String)"two", (String)((String)CollectionTools.last(list.iterator())));
        list.add(null);
        CollectionToolsTests.assertEquals(null, (String)((String)CollectionTools.last(list.iterator())));
    }

    public void testLastIterator2() {
        ArrayList list = new ArrayList();
        boolean exCaught = false;
        try {
            CollectionTools.last(list.iterator());
            CollectionToolsTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    public void testLastIndexOfIterableObject() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf(iterable, (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf(iterable, null));
    }

    public void testLastIndexOfIterableIntObject() {
        List<String> list;
        List<String> iterable = list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf(iterable, (int)23, (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf(iterable, (int)42, null));
    }

    public void testLastIndexOfIteratorObject() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf(list.iterator(), (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf(list.iterator(), null));
    }

    public void testLastIndexOfIteratorObject_Empty() {
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.lastIndexOf((Iterator)EmptyIterator.instance(), (Object)"foo"));
    }

    public void testLastIndexOfIteratorIntObject() {
        List<String> list = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)1, (int)CollectionTools.lastIndexOf(list.iterator(), (int)3, (Object)"one"));
        list.add(null);
        CollectionToolsTests.assertEquals((int)(list.size() - 1), (int)CollectionTools.lastIndexOf(list.iterator(), (int)4, null));
    }

    public void testLastIndexOfIteratorIntObject_Empty() {
        CollectionToolsTests.assertEquals((int)-1, (int)CollectionTools.lastIndexOf((Iterator)EmptyIterator.instance(), (int)42, (Object)"foo"));
    }

    public void testListIterable() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)CollectionTools.list(iterable));
    }

    public void testListIterableInt() {
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)CollectionTools.list(iterable, (int)3));
    }

    public void testListIterator_String() {
        ArrayList list = CollectionTools.list(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIterator_StringObject() {
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("0");
        list1.add("1");
        list1.add("2");
        list1.add("3");
        ArrayList list2 = CollectionTools.list(list1.iterator());
        CollectionToolsTests.assertEquals(list1, (Object)list2);
    }

    public void testListIterator_Empty() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.list((Iterator)EmptyIterator.instance()).size());
    }

    public void testListIteratorInt() {
        ArrayList list = CollectionTools.list(this.buildStringList1().iterator(), (int)3);
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorInt_Empty() {
        CollectionToolsTests.assertEquals((int)0, (int)CollectionTools.list((Iterator)EmptyIterator.instance(), (int)5).size());
    }

    public void testListObjectArray() {
        ArrayList list = CollectionTools.list((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals(this.buildStringList1(), (Object)list);
    }

    public void testListIteratorObjectArray() {
        Object[] a = this.buildStringArray1();
        int i = 0;
        ListIterator stream = CollectionTools.listIterator((Object[])a);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testListIteratorObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        int i = 1;
        ListIterator stream = CollectionTools.listIterator((Object[])a, (int)1);
        while (stream.hasNext()) {
            CollectionToolsTests.assertEquals((String)a[i], (String)((String)stream.next()));
            ++i;
        }
    }

    public void testMoveListIntIntRandomAccess() {
        ArrayList list = new ArrayList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = CollectionTools.move(list, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntSequentialAccess() {
        LinkedList list = new LinkedList();
        CollectionTools.addAll(list, (Object[])new String[]{"0", "1", "2", "3", "4", "5"});
        List result = CollectionTools.move(list, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
    }

    public void testMoveListIntIntIntRandomAccess() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = CollectionTools.move(list, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testMoveListIntIntIntSequentialAccess() {
        LinkedList<String> list = new LinkedList<String>(Arrays.asList("0", "1", "2", "3", "4", "5"));
        List result = CollectionTools.move(list, (int)4, (int)2, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)5, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result.toArray()));
        result = CollectionTools.move(list, (int)2, (int)4, (int)2);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)0, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)1, (int)4);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
        result = CollectionTools.move(list, (int)1, (int)0, (int)0);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result.toArray()));
    }

    public void testRemoveAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, iterable, (int)4));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        iterable = this.buildStringList2();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, iterable, (int)55));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIteratorInt_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, this.buildStringList1().iterator(), (int)5));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, this.buildStringList2().iterator(), (int)5));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionIterator_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = new ArrayIterator(a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = new ArrayIterator(a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionIterator_ObjectString() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        ArrayIterator iterator = new ArrayIterator(a);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        iterator = new ArrayIterator(a);
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Iterator)iterator));
    }

    public void testRemoveAllCollectionObjectArray_Empty() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])new Object[0]));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
    }

    public void testRemoveAllCollectionObjectArray_Duplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("d");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllCollectionObjectArray_MoreDuplicates() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("a");
        c.add("b");
        c.add("c");
        c.add("d");
        c.add("a");
        c.add("d");
        c.add("d");
        c.add("a");
        c.add("c");
        Object[] a = new String[]{"a", "d"};
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAll(c, (Object[])a));
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("a"));
        CollectionToolsTests.assertTrue((boolean)c.contains("b"));
        CollectionToolsTests.assertTrue((boolean)c.contains("c"));
        CollectionToolsTests.assertFalse((boolean)c.contains("d"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAll(c, (Object[])a));
    }

    public void testRemoveAllOccurrencesCollectionObject() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertEquals((int)3, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"three"));
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"two"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add("five");
        c.add("five");
        c.add("five");
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, (Object)"five"));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
        c.add(null);
        c.add(null);
        c.add(null);
        CollectionToolsTests.assertEquals((int)5, (int)c.size());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeAllOccurrences(c, null));
        CollectionToolsTests.assertEquals((int)2, (int)c.size());
    }

    public void testRemoveElementsAtIndexListIntInt() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList("A", "B", "A", "C", "A", "D"));
        ArrayList removed = CollectionTools.removeElementsAtIndex(list, (int)3, (int)2);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "D"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"C", "A"}, removed.toArray()));
        list = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = CollectionTools.removeElementsAtIndex(list, (int)3, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, removed.toArray()));
        list = new ArrayList<String>(Arrays.asList("A", "B", "C", "D", "E", "F"));
        removed = CollectionTools.removeElementsAtIndex(list, (int)0, (int)3);
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"D", "E", "F"}, list.toArray()));
        CollectionToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C"}, removed.toArray()));
    }

    public void testRemoveDuplicateElementsList1() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        CollectionToolsTests.assertTrue((boolean)CollectionTools.removeDuplicateElements(list));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((String)"one", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((String)"two", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsList2() {
        Vector<String> list = this.buildStringVector1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeDuplicateElements(list));
        int i = 0;
        CollectionToolsTests.assertEquals((String)"zero", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((String)"one", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((String)"two", (String)((String)list.get(i++)));
        CollectionToolsTests.assertEquals((int)i, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_Empty() {
        ArrayList list = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeDuplicateElements(list));
        CollectionToolsTests.assertEquals((int)0, (int)list.size());
    }

    public void testRemoveDuplicateElementsList_SingleElement() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("zero");
        CollectionToolsTests.assertFalse((boolean)CollectionTools.removeDuplicateElements(list));
        CollectionToolsTests.assertEquals((int)1, (int)list.size());
    }

    public void testRetainAllCollectionIterable() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterableInt() {
        List<String> c = this.buildStringList1();
        List<String> iterable = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, iterable));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        iterable = this.buildStringList2();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, iterable, (int)7));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIterator_ObjectString() {
        ArrayList<String> c1 = new ArrayList<String>();
        c1.add("zero");
        c1.add("one");
        c1.add("two");
        ArrayList<String> c2 = new ArrayList<String>();
        c2.add("zero");
        c2.add("one");
        c2.add("two");
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c1, c2.iterator()));
        CollectionToolsTests.assertEquals((int)c2.size(), (int)c1.size());
        CollectionToolsTests.assertEquals(c2, c1);
        ArrayList<String> c3 = new ArrayList<String>();
        c3.add("three");
        c3.add("four");
        c3.add("five");
    }

    public void testRetainAllCollectionIterator_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIterator_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIterator_EmptyCollectionEmptyIterator() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)8));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, this.buildStringList2().iterator(), (int)9));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionIteratorInt_EmptyIterator() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, this.buildStringList1().iterator(), (int)3));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionIteratorInt_EmptyCollectionEmptyIterator() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Iterator)EmptyIterator.instance(), (int)0));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray1()));
        CollectionToolsTests.assertEquals((int)this.buildStringList1().size(), (int)c.size());
        CollectionToolsTests.assertEquals(this.buildStringList1(), c);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])this.buildObjectArray2()));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
        CollectionToolsTests.assertFalse((boolean)c.contains("one"));
        CollectionToolsTests.assertFalse((boolean)c.contains("two"));
        CollectionToolsTests.assertFalse((boolean)c.contains("three"));
    }

    public void testRetainAllCollectionObjectArray_EmptyObjectArray() {
        List<String> c = this.buildStringList1();
        CollectionToolsTests.assertTrue((boolean)CollectionTools.retainAll(c, (Object[])new Object[0]));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray_EmptyCollection() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])new String[]{"foo"}));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testRetainAllCollectionObjectArray_EmptyCollectionEmptyObjectArray() {
        ArrayList c = new ArrayList();
        CollectionToolsTests.assertFalse((boolean)CollectionTools.retainAll(c, (Object[])new String[0]));
        CollectionToolsTests.assertEquals((int)0, (int)c.size());
    }

    public void testReverseListIterable() {
        List<String> iterable = this.buildStringList1();
        List actual = CollectionTools.reverseList(iterable);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterableInt() {
        List<String> iterable = this.buildStringList1();
        List actual = CollectionTools.reverseList(iterable, (int)10);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterator_String() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIterator_Object() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator());
        List<Object> expected = this.buildObjectList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testReverseListIteratorInt() {
        List actual = CollectionTools.reverseList(this.buildStringList1().iterator(), (int)33);
        List<String> expected = this.buildStringList1();
        Collections.reverse(expected);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testRotateList() {
        List actual = CollectionTools.rotate(this.buildStringList1());
        List<String> expected = this.buildStringList1();
        Collections.rotate(expected, 1);
        CollectionToolsTests.assertEquals(expected, (Object)actual);
    }

    public void testSetIterable() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable));
    }

    public void testSetIterableInt() {
        Set<String> iterable = this.buildStringSet1();
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(iterable, (int)22));
    }

    public void testSetIterator_String() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator()));
    }

    public void testSetIterator_Object() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        list.add("0");
        list.add("1");
        list.add("2");
        list.add("3");
        HashSet<String> set = new HashSet<String>();
        set.addAll(list);
        CollectionToolsTests.assertEquals(set, (Object)CollectionTools.set(list.iterator()));
    }

    public void testSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set(this.buildStringSet1().iterator(), (int)3));
    }

    public void testSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildStringSet1(), (Object)CollectionTools.set((Object[])this.buildStringSet1().toArray()));
    }

    public void testSingletonIterator_String() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
    }

    public void testSingletonIterator_Object() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonIterator_Cast() {
        Iterator stream = CollectionTools.singletonIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((Object)"foo", stream.next());
    }

    public void testSingletonListIterator_String() {
        ListIterator stream = CollectionTools.singletonListIterator((Object)"foo");
        CollectionToolsTests.assertTrue((boolean)stream.hasNext());
        CollectionToolsTests.assertEquals((String)"foo", (String)((String)stream.next()));
        CollectionToolsTests.assertFalse((boolean)stream.hasNext());
        CollectionToolsTests.assertTrue((boolean)stream.hasPrevious());
        CollectionToolsTests.assertEquals((String)"foo", (String)((String)stream.previous()));
    }

    public void testSizeIterable() {
        List<Object> iterable = this.buildObjectList1();
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.size(iterable));
    }

    public void testSizeIterator() {
        CollectionToolsTests.assertEquals((int)3, (int)CollectionTools.size(this.buildObjectList1().iterator()));
    }

    public void testSortIterable() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = CollectionTools.sort(iterable1);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = CollectionTools.sort(iterable1, (int)77);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = CollectionTools.sort(iterable1, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterableComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss.addAll(list);
        ArrayList<String> iterable1 = list;
        Iterable iterable2 = CollectionTools.sort(iterable1, (Comparator)new ReverseComparator(), (int)77);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss, (Iterable)iterable2));
    }

    public void testSortIterator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = CollectionTools.sort(iterator1);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = CollectionTools.sort(iterator1, (int)77);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = CollectionTools.sort(iterator1, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortIteratorComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss.addAll(list);
        Iterator iterator1 = list.iterator();
        ListIterator iterator2 = CollectionTools.sort(iterator1, (Comparator)new ReverseComparator(), (int)77);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss.iterator(), (Iterator)iterator2));
    }

    public void testSortedSetIterable() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (int)5);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterableComparatorInt() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        ArrayList<String> iterable = list;
        TreeSet ss2 = CollectionTools.sortedSet(iterable, (Comparator)new ReverseComparator(), (int)5);
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testSortedSetIterator() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator()));
    }

    public void testSortedSetIterator_TreeSet() {
        TreeSet<String> ss1 = new TreeSet<String>();
        ss1.add("0");
        ss1.add("2");
        ss1.add("3");
        ss1.add("1");
        TreeSet set2 = CollectionTools.sortedSet(ss1.iterator());
        CollectionToolsTests.assertEquals(ss1, (Object)set2);
    }

    public void testSortedSetIteratorInt() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet(this.buildSortedStringSet1().iterator(), (int)8));
    }

    public void testSortedSetObjectArray() {
        CollectionToolsTests.assertEquals(this.buildSortedStringSet1(), (Object)CollectionTools.sortedSet((Comparable[])this.buildStringSet1().toArray(new String[0])));
    }

    public void testSortedSetObjectArrayComparator() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("0");
        list.add("2");
        list.add("3");
        list.add("1");
        TreeSet<String> ss1 = new TreeSet<String>((Comparator<String>)new ReverseComparator());
        ss1.addAll(list);
        Object[] array = list.toArray(new String[list.size()]);
        TreeSet ss2 = CollectionTools.sortedSet((Object[])array, (Comparator)new ReverseComparator());
        CollectionToolsTests.assertEquals(ss1, (Object)ss2);
    }

    public void testVectorIterable() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterableInt() {
        List<String> iterable = this.buildStringList1();
        Vector v = CollectionTools.vector(iterable, (int)8);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_String() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIterator_Object() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorIteratorInt() {
        Vector v = CollectionTools.vector(this.buildStringList1().iterator(), (int)7);
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testVectorObjectArray() {
        Vector v = CollectionTools.vector((Object[])this.buildStringArray1());
        CollectionToolsTests.assertEquals((int)3, (int)v.size());
        CollectionToolsTests.assertTrue((boolean)v.containsAll(this.buildStringList1()));
    }

    public void testIterableIterator() {
        Iterator emptyIterator = EmptyIterator.instance();
        Iterable emptyIterable = CollectionTools.iterable((Iterator)emptyIterator);
        CollectionToolsTests.assertFalse((boolean)emptyIterable.iterator().hasNext());
        boolean exceptionThrown = false;
        try {
            emptyIterator = emptyIterable.iterator();
            CollectionToolsTests.fail((String)("invalid iterator: " + emptyIterator));
        }
        catch (IllegalStateException illegalStateException) {
            exceptionThrown = true;
        }
        CollectionToolsTests.assertTrue((String)"IllegalStateException not thrown.", (boolean)exceptionThrown);
    }

    public void testIterableIterator_NPE() {
        Iterator nullIterator = null;
        boolean exceptionThrown = false;
        try {
            Iterable emptyIterable = CollectionTools.iterable(nullIterator);
            CollectionToolsTests.fail((String)("invalid iterable: " + emptyIterable));
        }
        catch (NullPointerException nullPointerException) {
            exceptionThrown = true;
        }
        CollectionToolsTests.assertTrue((boolean)exceptionThrown);
    }

    public void testIterableIterator_ToString() {
        Iterator emptyIterator = EmptyIterator.instance();
        Iterable emptyIterable = CollectionTools.iterable((Iterator)emptyIterator);
        CollectionToolsTests.assertNotNull((Object)emptyIterable.toString());
    }

    public void testCopyListList() {
        List<String> src = this.buildStringList1();
        ArrayList<String> dest = new ArrayList<String>();
        for (String s : src) {
            dest.add(s.toUpperCase());
        }
        List result = CollectionTools.copy(dest, src);
        CollectionToolsTests.assertSame(dest, (Object)result);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreIdentical(src, dest));
    }

    public void testFillListObject() {
        List<String> list = this.buildStringList1();
        List result = CollectionTools.fill(list, (Object)"foo");
        CollectionToolsTests.assertSame(list, (Object)result);
        for (String string : result) {
            CollectionToolsTests.assertEquals((String)"foo", (String)string);
        }
    }

    public void testShuffleList() {
        List<String> list = this.buildStringList1();
        List result = CollectionTools.shuffle(list);
        CollectionToolsTests.assertSame(list, (Object)result);
    }

    public void testShuffleListRandom() {
        List<String> list = this.buildStringList1();
        List result = CollectionTools.shuffle(list, (Random)new Random());
        CollectionToolsTests.assertSame(list, (Object)result);
    }

    public void testSortList() {
        List<String> list = this.buildStringList1();
        TreeSet<String> ss = new TreeSet<String>();
        ss.addAll(list);
        List result = CollectionTools.sort(list);
        CollectionToolsTests.assertSame(list, (Object)result);
        CollectionToolsTests.assertTrue((boolean)CollectionTools.elementsAreEqual(ss, (Iterable)result));
    }

    public void testSwapListIntInt() {
        List<String> list = this.buildStringList1();
        List result = CollectionTools.swap(list, (int)0, (int)1);
        CollectionToolsTests.assertSame(list, (Object)result);
        List<String> original = this.buildStringList1();
        CollectionToolsTests.assertEquals((String)original.get(0), (String)((String)result.get(1)));
        CollectionToolsTests.assertEquals((String)original.get(1), (String)((String)result.get(0)));
        CollectionToolsTests.assertEquals((String)original.get(2), (String)((String)result.get(2)));
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ReflectionTools.newInstance(CollectionTools.class);
                CollectionToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        CollectionToolsTests.assertTrue((boolean)exCaught);
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Set<String> buildStringSet1() {
        HashSet<String> s = new HashSet<String>();
        this.addToCollection1(s);
        return s;
    }

    private Set<Object> buildObjectSet1() {
        HashSet<Object> s = new HashSet<Object>();
        this.addToCollection1(s);
        return s;
    }

    private SortedSet<String> buildSortedStringSet1() {
        TreeSet<String> s = new TreeSet<String>();
        this.addToCollection1(s);
        return s;
    }
}

