/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.Bag;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.IdentityHashBag;
import org.eclipse.jpt.utility.internal.Tools;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashBagTests
extends TestCase {
    private IdentityHashBag<String> bag;
    private String one = "one";
    private String two = "two";
    private String three = "three";
    private String four = "four";
    private String foo = "foo";
    private String bar = "bar";

    public IdentityHashBagTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bag = this.buildBag();
    }

    protected IdentityHashBag<String> buildBag() {
        IdentityHashBag result = new IdentityHashBag();
        result.add(null);
        result.add((Object)this.one);
        result.add((Object)this.two);
        result.add((Object)this.two);
        result.add((Object)this.three);
        result.add((Object)this.three);
        result.add((Object)this.three);
        result.add((Object)this.four);
        result.add((Object)this.four);
        result.add((Object)this.four);
        result.add((Object)this.four);
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    private Collection<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.foo);
        c.add(this.foo);
        c.add(this.bar);
        c.add(this.bar);
        c.add(this.bar);
        return c;
    }

    public void testCtorCollection() {
        Collection<String> c = this.buildCollection();
        IdentityHashBag localBag = new IdentityHashBag(c);
        for (String s : c) {
            IdentityHashBagTests.assertTrue((boolean)localBag.contains((Object)s));
        }
    }

    public void testCtorIntFloat() {
        boolean exCaught = false;
        try {
            this.bag = new IdentityHashBag(-20, 0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
        exCaught = false;
        try {
            this.bag = new IdentityHashBag(20, -0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)"IllegalArgumentException not thrown", (boolean)exCaught);
    }

    public void testAdd() {
        String five = "five";
        IdentityHashBagTests.assertTrue((boolean)this.bag.add((Object)five));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.four));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)five));
    }

    public void testAddCount() {
        String minus3 = "minus3";
        String zero = "zero";
        String five = "five";
        this.bag.add((Object)minus3, -3);
        this.bag.add((Object)zero, 0);
        this.bag.add((Object)five, 5);
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)minus3));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)zero));
        IdentityHashBagTests.assertEquals((int)1, (int)this.bag.count((Object)this.one));
        IdentityHashBagTests.assertEquals((int)2, (int)this.bag.count((Object)this.two));
        IdentityHashBagTests.assertEquals((int)3, (int)this.bag.count((Object)this.three));
        IdentityHashBagTests.assertEquals((int)4, (int)this.bag.count((Object)this.four));
        IdentityHashBagTests.assertEquals((int)5, (int)this.bag.count((Object)five));
        this.bag.add((Object)this.three, 2);
        IdentityHashBagTests.assertEquals((int)5, (int)this.bag.count((Object)this.three));
    }

    public void testAddAll() {
        Collection<String> c = this.buildCollection();
        IdentityHashBagTests.assertTrue((boolean)this.bag.addAll(c));
        for (String s : c) {
            IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)s));
        }
    }

    public void testClear() {
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.four));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains(null));
        IdentityHashBagTests.assertEquals((int)11, (int)this.bag.size());
        this.bag.clear();
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.four));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains(null));
        IdentityHashBagTests.assertEquals((int)0, (int)this.bag.size());
    }

    public void testClone() {
        IdentityHashBag bag2 = this.bag.clone();
        IdentityHashBagTests.assertTrue((String)"bad clone", (this.bag != bag2 ? 1 : 0) != 0);
        IdentityHashBagTests.assertEquals((String)"bad clone", this.bag, (Object)bag2);
        IdentityHashBagTests.assertTrue((String)"bad clone", (this.bag.hashCode() == bag2.hashCode() ? 1 : 0) != 0);
    }

    public void testContains() {
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains(null));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.four));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)new String("four")));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)"five"));
    }

    public void testContainsAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(null);
        c.add(this.one);
        c.add(this.two);
        c.add(this.three);
        c.add(this.four);
        IdentityHashBagTests.assertTrue((boolean)this.bag.containsAll(c));
        c.add(new String(this.four));
        IdentityHashBagTests.assertFalse((boolean)this.bag.containsAll(c));
    }

    public void testCount() {
        IdentityHashBagTests.assertEquals((int)0, (int)this.bag.count((Object)"zero"));
        IdentityHashBagTests.assertEquals((int)1, (int)this.bag.count((Object)"one"));
        IdentityHashBagTests.assertEquals((int)2, (int)this.bag.count((Object)"two"));
        IdentityHashBagTests.assertEquals((int)3, (int)this.bag.count((Object)"three"));
        IdentityHashBagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        IdentityHashBagTests.assertEquals((int)0, (int)this.bag.count((Object)"five"));
    }

    public void testEquals() {
        IdentityHashBag<String> bag2 = this.buildBag();
        IdentityHashBagTests.assertEquals(this.bag, bag2);
        bag2.add((Object)"five");
        IdentityHashBagTests.assertFalse((boolean)this.bag.equals(bag2));
        ArrayList<String> c = new ArrayList<String>((Collection<String>)this.bag);
        IdentityHashBagTests.assertFalse((boolean)this.bag.equals(c));
    }

    public void testHashCode() {
        IdentityHashBag<String> bag2 = this.buildBag();
        IdentityHashBagTests.assertEquals((int)this.bag.hashCode(), (int)bag2.hashCode());
    }

    public void testIsEmpty() {
        IdentityHashBagTests.assertFalse((boolean)this.bag.isEmpty());
        this.bag.clear();
        IdentityHashBagTests.assertTrue((boolean)this.bag.isEmpty());
        this.bag.add((Object)"foo");
        IdentityHashBagTests.assertFalse((boolean)this.bag.isEmpty());
    }

    public void testEmptyIterator() {
        this.bag.clear();
        Iterator iterator = this.bag.iterator();
        IdentityHashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
    }

    public void testIterator() {
        int i = 0;
        Iterator iterator = this.bag.iterator();
        IdentityHashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        IdentityHashBagTests.assertEquals((int)11, (int)i);
        IdentityHashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)("NoSuchElementException not thrown: " + element), (boolean)exCaught);
        iterator.remove();
        IdentityHashBagTests.assertEquals((int)10, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)"IllegalStateException not thrown", (boolean)exCaught);
        iterator = this.bag.iterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((String)"ConcurrentModificationException not thrown", (boolean)exCaught);
    }

    public void testUniqueIterator() {
        int i = 0;
        Iterator iterator = this.bag.uniqueIterator();
        IdentityHashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        IdentityHashBagTests.assertEquals((int)5, (int)i);
        IdentityHashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            IdentityHashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        Object next = null;
        while (iterator.hasNext() && !this.four.equals(next)) {
            next = iterator.next();
        }
        iterator.remove();
        IdentityHashBagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        String five = "five";
        this.bag.add((Object)five);
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
    }

    public void testEntries() {
        int i = 0;
        Iterator iterator = this.bag.entries();
        IdentityHashBagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        IdentityHashBagTests.assertEquals((int)5, (int)i);
        IdentityHashBagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            IdentityHashBagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals(this.four)) continue;
            iterator.remove();
            break;
        }
        IdentityHashBagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        String five = "five";
        this.bag.add((Object)five);
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        IdentityHashBagTests.assertTrue((boolean)exCaught);
    }

    public void testHashingDistribution() throws Exception {
        IdentityHashBag bigBag = new IdentityHashBag();
        int i = 0;
        while (i < 10000) {
            bigBag.add((Object)("object" + i));
            ++i;
        }
        Field field = bigBag.getClass().getDeclaredField("table");
        field.setAccessible(true);
        Object[] table = (Object[])field.get(bigBag);
        int bucketCount = table.length;
        int filledBucketCount = 0;
        int i2 = 0;
        while (i2 < bucketCount) {
            if (table[i2] != null) {
                ++filledBucketCount;
            }
            ++i2;
        }
        float loadFactor = (float)filledBucketCount / (float)bucketCount;
        if ((double)loadFactor < 0.2 || (double)loadFactor > 0.8) {
            String msg = "poor load factor: " + loadFactor;
            if (Tools.jvmIsSun()) {
                IdentityHashBagTests.fail((String)msg);
            } else {
                System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + '.' + this.getName() + " - " + msg);
                TestTools.printSystemProperties();
            }
        }
    }

    public void testRemove() {
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)new String(this.three)));
    }

    public void testRemoveCount() {
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.one, 0));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.one, 1));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.two, -3));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.two, 1));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.two, 1));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.three, 3));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.three));
    }

    public void testRemoveAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.one);
        c.add(new String(this.two));
        c.add(this.three);
        IdentityHashBagTests.assertTrue((boolean)this.bag.removeAll(c));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.three));
        IdentityHashBagTests.assertFalse((boolean)this.bag.removeAll(c));
    }

    public void testRetainAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(this.one);
        c.add(new String(this.two));
        c.add(this.three);
        IdentityHashBagTests.assertTrue((boolean)this.bag.retainAll(c));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.one));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)this.bag.contains((Object)this.three));
        IdentityHashBagTests.assertFalse((boolean)this.bag.contains((Object)this.four));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.two));
        IdentityHashBagTests.assertFalse((boolean)this.bag.remove((Object)this.four));
        IdentityHashBagTests.assertFalse((boolean)this.bag.retainAll(c));
    }

    public void testSize() {
        IdentityHashBagTests.assertTrue((this.bag.size() == 11 ? 1 : 0) != 0);
        String five = "five";
        this.bag.add((Object)five);
        this.bag.add((Object)five);
        this.bag.add((Object)five);
        this.bag.add((Object)five);
        this.bag.add((Object)new String(five));
        IdentityHashBagTests.assertEquals((int)16, (int)this.bag.size());
    }

    public void testSerialization() throws Exception {
        IdentityHashBag<String> bag2 = TestTools.serialize(this.bag);
        IdentityHashBagTests.assertTrue((String)"same object?", (this.bag != bag2 ? 1 : 0) != 0);
        IdentityHashBagTests.assertEquals((int)11, (int)bag2.size());
        IdentityHashBagTests.assertEquals((Object)CollectionTools.bag((Iterator)this.bag.iterator()), (Object)CollectionTools.bag((Iterator)bag2.iterator()));
        IdentityHashBagTests.assertTrue((boolean)CollectionTools.bag((Iterator)bag2.iterator()).contains(null));
        IdentityHashBagTests.assertTrue((boolean)CollectionTools.bag((Iterator)bag2.iterator()).contains((Object)"one"));
        IdentityHashBagTests.assertTrue((boolean)CollectionTools.bag((Iterator)bag2.iterator()).contains((Object)"two"));
        IdentityHashBagTests.assertTrue((boolean)CollectionTools.bag((Iterator)bag2.iterator()).contains((Object)"three"));
        IdentityHashBagTests.assertTrue((boolean)CollectionTools.bag((Iterator)bag2.iterator()).contains((Object)"four"));
        int nullCount = 0;
        int oneCount = 0;
        int twoCount = 0;
        int threeCount = 0;
        int fourCount = 0;
        for (String next : bag2) {
            if (next == null) {
                ++nullCount;
                continue;
            }
            if (next.equals("one")) {
                ++oneCount;
                continue;
            }
            if (next.equals("two")) {
                ++twoCount;
                continue;
            }
            if (next.equals("three")) {
                ++threeCount;
                continue;
            }
            if (!next.equals("four")) continue;
            ++fourCount;
        }
        IdentityHashBagTests.assertEquals((int)1, (int)nullCount);
        IdentityHashBagTests.assertEquals((int)1, (int)oneCount);
        IdentityHashBagTests.assertEquals((int)2, (int)twoCount);
        IdentityHashBagTests.assertEquals((int)3, (int)threeCount);
        IdentityHashBagTests.assertEquals((int)4, (int)fourCount);
    }

    public void testToArray() {
        Object[] a = this.bag.toArray();
        IdentityHashBagTests.assertEquals((int)11, (int)a.length);
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.three));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.four));
    }

    public void testToArrayObjectArray() {
        Object[] a = new String[12];
        a[11] = "not null";
        String[] b = (String[])this.bag.toArray(a);
        IdentityHashBagTests.assertEquals((Object)a, (Object)b);
        IdentityHashBagTests.assertEquals((int)12, (int)a.length);
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.one));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.two));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.three));
        IdentityHashBagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)this.four));
        IdentityHashBagTests.assertTrue((a[11] == null ? 1 : 0) != 0);
    }

    public void testToString() {
        String s = this.bag.toString();
        IdentityHashBagTests.assertTrue((boolean)s.startsWith("["));
        IdentityHashBagTests.assertTrue((boolean)s.endsWith("]"));
        int commaCount = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++commaCount;
            }
            ++i;
        }
        IdentityHashBagTests.assertEquals((String)"invalid number of commas", (int)10, (int)commaCount);
        IdentityHashBagTests.assertTrue((s.indexOf("one") != -1 ? 1 : 0) != 0);
        IdentityHashBagTests.assertTrue((s.indexOf("two") != -1 ? 1 : 0) != 0);
        IdentityHashBagTests.assertTrue((s.indexOf("three") != -1 ? 1 : 0) != 0);
        IdentityHashBagTests.assertTrue((s.indexOf("four") != -1 ? 1 : 0) != 0);
        IdentityHashBagTests.assertTrue((s.indexOf("null") != -1 ? 1 : 0) != 0);
    }
}

