/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ObjectReference;

public class ObjectReferenceTests
extends TestCase {
    public ObjectReferenceTests(String name) {
        super(name);
    }

    public void testGetValue() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertNull((Object)or.getValue());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
    }

    public void testValueEqualsObject() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.valueEquals(null));
        ObjectReferenceTests.assertFalse((boolean)or.valueEquals((Object)"foo"));
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertFalse((boolean)or.valueEquals(null));
        ObjectReferenceTests.assertTrue((boolean)or.valueEquals((Object)"foo"));
    }

    public void testValueNotEqualObject() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or.valueNotEqual(null));
        ObjectReferenceTests.assertTrue((boolean)or.valueNotEqual((Object)"foo"));
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertTrue((boolean)or.valueNotEqual(null));
        ObjectReferenceTests.assertFalse((boolean)or.valueNotEqual((Object)"foo"));
    }

    public void testIsNull() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertTrue((boolean)or.isNull());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertFalse((boolean)or.isNull());
    }

    public void testIsNotNull() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertFalse((boolean)or.isNotNull());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertTrue((boolean)or.isNotNull());
    }

    public void testSetNull() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertNull((Object)or.getValue());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertEquals((String)"foo", (String)((String)or.getValue()));
        or.setNull();
        ObjectReferenceTests.assertNull((Object)or.getValue());
    }

    public void testClone() {
        ObjectReference or = new ObjectReference((Object)"foo");
        ObjectReference clone = or.clone();
        ObjectReferenceTests.assertEquals((String)"foo", (String)((String)clone.getValue()));
        ObjectReferenceTests.assertEquals((Object)or, (Object)clone);
    }

    public void testEquals() {
        ObjectReference or1 = new ObjectReference((Object)"foo");
        ObjectReference or2 = new ObjectReference((Object)"foo");
        ObjectReferenceTests.assertTrue((boolean)or1.equals((Object)or2));
        ObjectReference or3 = new ObjectReference((Object)"bar");
        ObjectReferenceTests.assertFalse((boolean)or1.equals((Object)or3));
    }

    public void testHashCode() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertEquals((int)0, (int)or.hashCode());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertEquals((int)"foo".hashCode(), (int)or.hashCode());
    }

    public void testToString() {
        ObjectReference or = new ObjectReference();
        ObjectReferenceTests.assertEquals((String)"[null]", (String)or.toString());
        or.setValue((Object)"foo");
        ObjectReferenceTests.assertEquals((String)"[foo]", (String)or.toString());
    }
}

