/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jpt.utility.internal.Association;
import org.eclipse.jpt.utility.internal.SimpleAssociation;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleAssociationTests
extends TestCase {
    private SimpleAssociation<String, String> assoc;

    public static Test suite() {
        return new TestSuite(SimpleAssociationTests.class);
    }

    public SimpleAssociationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.assoc = new SimpleAssociation((Object)"foo", (Object)"bar");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testGetKey() {
        SimpleAssociationTests.assertEquals((String)"foo", (String)((String)this.assoc.key()));
    }

    public void testGetValue() {
        SimpleAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.value()));
    }

    public void testSetValue() {
        SimpleAssociationTests.assertEquals((String)"bar", (String)((String)this.assoc.value()));
        this.assoc.setValue((Object)"baz");
        SimpleAssociationTests.assertEquals((String)"baz", (String)((String)this.assoc.value()));
    }

    public void testEquals() {
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)"foo"));
        SimpleAssociationTests.assertEquals(this.assoc, this.copy(this.assoc));
        SimpleAssociation assoc2 = new SimpleAssociation((Object)"foo", (Object)"baz");
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)assoc2));
        assoc2 = new SimpleAssociation((Object)"fop", (Object)"bar");
        SimpleAssociationTests.assertFalse((boolean)this.assoc.equals((Object)assoc2));
        SimpleAssociation assoc3 = new SimpleAssociation(null, null);
        SimpleAssociation assoc4 = new SimpleAssociation(null, null);
        SimpleAssociationTests.assertEquals((Object)assoc3, (Object)assoc4);
    }

    public void testHashCode() {
        SimpleAssociationTests.assertEquals((int)this.assoc.hashCode(), (int)this.copy(this.assoc).hashCode());
        SimpleAssociation assoc2 = new SimpleAssociation(null, null);
        SimpleAssociationTests.assertEquals((int)assoc2.hashCode(), (int)this.copy((SimpleAssociation<String, String>)assoc2).hashCode());
    }

    public void testToString() {
        SimpleAssociationTests.assertNotNull((Object)this.assoc.toString());
    }

    public void testClone() {
        this.verifyClone((Association<String, String>)this.assoc, (Association<String, String>)this.assoc.clone());
    }

    private void verifyClone(Association<String, String> expected, Association<String, String> actual) {
        SimpleAssociationTests.assertEquals(expected, actual);
        SimpleAssociationTests.assertNotSame(expected, actual);
        SimpleAssociationTests.assertEquals((String)((String)expected.key()), (String)((String)actual.key()));
        SimpleAssociationTests.assertSame((Object)expected.key(), (Object)actual.key());
        SimpleAssociationTests.assertEquals((String)((String)expected.value()), (String)((String)actual.value()));
        SimpleAssociationTests.assertSame((Object)expected.value(), (Object)actual.value());
    }

    public void testSerialization() throws Exception {
        Association assoc2 = (Association)TestTools.serialize(this.assoc);
        SimpleAssociationTests.assertEquals(this.assoc, (Object)assoc2);
        SimpleAssociationTests.assertNotSame(this.assoc, (Object)assoc2);
        SimpleAssociationTests.assertEquals((String)((String)this.assoc.key()), (String)((String)assoc2.key()));
        SimpleAssociationTests.assertNotSame((Object)this.assoc.key(), (Object)assoc2.key());
        SimpleAssociationTests.assertEquals((String)((String)this.assoc.value()), (String)((String)assoc2.value()));
        SimpleAssociationTests.assertNotSame((Object)this.assoc.value(), (Object)assoc2.value());
    }

    private SimpleAssociation<String, String> copy(SimpleAssociation<String, String> sa) {
        return new SimpleAssociation((Object)((String)sa.key()), (Object)((String)sa.value()));
    }
}

