/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.ListIterator;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterables.ArrayListIterable;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayListIterableTests
extends TestCase {
    public ArrayListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        int i = 1;
        ListIterable<String> iterable = this.buildIterable();
        for (String string : iterable) {
            ArrayListIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
        ListIterator stream = iterable.iterator();
        while (stream.hasNext()) {
            stream.next();
        }
        while (stream.hasPrevious()) {
            ArrayListIterableTests.assertEquals((int)(--i), (int)Integer.parseInt((String)stream.previous()));
        }
    }

    public void testSubIterator() {
        int i = 3;
        for (String string : this.buildIterable(2)) {
            ArrayListIterableTests.assertEquals((int)i++, (int)Integer.parseInt(string));
        }
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    private void triggerIllegalArgumentException(int start, int length) {
        boolean exCaught = false;
        try {
            ListIterable<String> iterable = this.buildIterable(start, length);
            ArrayListIterableTests.fail((String)("bogus iterable: " + iterable));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayListIterableTests.assertTrue((boolean)exCaught);
    }

    private ListIterable<String> buildIterable() {
        return this.buildIterable(0);
    }

    private ListIterable<String> buildIterable(int start) {
        return this.buildIterable(this.buildArray(), start);
    }

    private ListIterable<String> buildIterable(String[] array, int start) {
        return start == 0 ? new ArrayListIterable((Object[])array) : new ArrayListIterable((Object[])array, start);
    }

    private ListIterable<String> buildIterable(int start, int length) {
        return this.buildIterable(this.buildArray(), start, length);
    }

    private ListIterable<String> buildIterable(String[] array, int start, int length) {
        return new ArrayListIterable((Object[])array, start, length);
    }

    private String[] buildArray() {
        return new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

