/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.Iterator;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.utility.internal.iterables.ListListIterable;
import org.eclipse.jpt.utility.internal.iterables.ReadOnlyListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyListIterableTests
extends TestCase {
    public ReadOnlyListIterableTests(String name) {
        super(name);
    }

    public void testIterator() {
        Iterator<String> nestedIterator = this.buildVector().iterator();
        for (String s : this.buildReadOnlyListIterable()) {
            ReadOnlyListIterableTests.assertEquals((String)nestedIterator.next(), (String)s);
        }
    }

    public void testRemove() {
        boolean exCaught = false;
        Iterator<String> stream = this.buildReadOnlyListIterable().iterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("three")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ReadOnlyListIterableTests.assertTrue((boolean)exCaught);
    }

    public void testToString() {
        ReadOnlyListIterableTests.assertNotNull((Object)this.buildReadOnlyListIterable().toString());
    }

    private Iterable<String> buildReadOnlyListIterable() {
        return new ReadOnlyListIterable(this.buildNestedListIterable());
    }

    private ListIterable<String> buildNestedListIterable() {
        return new ListListIterable(this.buildVector());
    }

    private Vector<String> buildVector() {
        Vector<String> v = new Vector<String>();
        v.addElement("one");
        v.addElement("two");
        v.addElement("three");
        v.addElement("four");
        v.addElement("five");
        v.addElement("six");
        v.addElement("seven");
        v.addElement("eight");
        return v;
    }
}

