/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.iterables;

import java.util.List;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.SnapshotCloneIterable;
import org.eclipse.jpt.utility.tests.internal.iterables.CloneIterableTests;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotCloneIterableTests
extends CloneIterableTests {
    public SnapshotCloneIterableTests(String name) {
        super(name);
    }

    @Override
    public void testIterator() {
        super.testIterator();
        int i = 0;
        for (String s : this.iterable) {
            SnapshotCloneIterableTests.assertEquals((String)String.valueOf(i++), (String)s);
        }
        SnapshotCloneIterableTests.assertEquals((int)4, (int)i);
    }

    @Override
    public void testRemove() {
        super.testRemove();
        SnapshotCloneIterableTests.assertTrue((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)"three"));
    }

    @Override
    public void testRemover() {
        super.testRemover();
        SnapshotCloneIterableTests.assertTrue((boolean)CollectionTools.contains((Iterable)this.iterable, (Object)"three"));
    }

    @Override
    Iterable<String> buildIterable(List<String> c) {
        return new SnapshotCloneIterable(c);
    }

    @Override
    Iterable<String> buildRemovingIterable(final List<String> c) {
        return new SnapshotCloneIterable<String>(c){

            protected void remove(String current) {
                c.remove(current);
            }
        };
    }

    @Override
    Iterable<String> buildIterableWithRemover(List<String> c) {
        return new SnapshotCloneIterable(c, this.buildRemover(c));
    }
}

