/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class SimplePropertyValueModelTests
extends TestCase {
    private WritablePropertyValueModel<String> objectHolder;
    PropertyChangeEvent event;

    public SimplePropertyValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.objectHolder = new SimplePropertyValueModel((Object)"foo");
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testValue() {
        SimplePropertyValueModelTests.assertEquals((String)"foo", (String)((String)this.objectHolder.getValue()));
    }

    public void testSetValue() {
        this.objectHolder.setValue((Object)"bar");
        SimplePropertyValueModelTests.assertEquals((String)"bar", (String)((String)this.objectHolder.getValue()));
        this.objectHolder.setValue(null);
        SimplePropertyValueModelTests.assertEquals(null, (String)((String)this.objectHolder.getValue()));
        this.objectHolder.setValue((Object)"baz");
        SimplePropertyValueModelTests.assertEquals((String)"baz", (String)((String)this.objectHolder.getValue()));
    }

    public void testPropertyChange1() {
        this.objectHolder.addChangeListener(this.buildListener());
        this.verifyPropertyChange();
    }

    public void testPropertyChange2() {
        this.objectHolder.addPropertyChangeListener("value", (PropertyChangeListener)this.buildListener());
        this.verifyPropertyChange();
    }

    private void verifyPropertyChange() {
        this.event = null;
        this.objectHolder.setValue((Object)"bar");
        this.verifyEvent("foo", "bar");
        this.event = null;
        this.objectHolder.setValue(null);
        this.verifyEvent("bar", null);
        this.event = null;
        this.objectHolder.setValue((Object)"baz");
        this.verifyEvent(null, "baz");
    }

    private ChangeListener buildListener() {
        return new ChangeAdapter(){

            public void propertyChanged(PropertyChangeEvent e) {
                SimplePropertyValueModelTests.this.event = e;
            }
        };
    }

    private void verifyEvent(Object oldValue, Object newValue) {
        SimplePropertyValueModelTests.assertEquals(this.objectHolder, (Object)this.event.getSource());
        SimplePropertyValueModelTests.assertEquals((String)"value", (String)this.event.getPropertyName());
        SimplePropertyValueModelTests.assertEquals((Object)oldValue, (Object)this.event.getOldValue());
        SimplePropertyValueModelTests.assertEquals((Object)newValue, (Object)this.event.getNewValue());
    }
}

