/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.ValuePropertyAdapter;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.event.StateChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.StateChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class ValuePropertyAdapterTests
extends TestCase {
    private Junk junk;
    private SimplePropertyValueModel<Junk> junkHolder;
    private ValuePropertyAdapter<Junk> junkHolder2;

    public ValuePropertyAdapterTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.junk = new Junk("foo");
        this.junkHolder = new SimplePropertyValueModel((Object)this.junk);
        this.junkHolder2 = new ValuePropertyAdapter(this.junkHolder, new String[]{"name"});
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testWrappedPVM() {
        Junk junk2 = new Junk("bar");
        LocalListener l = new LocalListener(this.junkHolder2, (Object)this.junk, (Object)junk2);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        this.junkHolder.setValue((Object)junk2);
        ValuePropertyAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    public void testHasPropertyChangeListeners() throws Exception {
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addChangeListener((ChangeListener)l);
        ValuePropertyAdapterTests.assertTrue((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValuePropertyAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
        this.junkHolder2.removeChangeListener((ChangeListener)l);
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder.hasAnyPropertyChangeListeners("value"));
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyPropertyChangeListeners("value"));
    }

    public void testHasStateChangeListeners() throws Exception {
        ValuePropertyAdapterTests.assertFalse((boolean)this.junk.hasAnyPropertyChangeListeners("name"));
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        ValuePropertyAdapterTests.assertTrue((boolean)this.junk.hasAnyPropertyChangeListeners("name"));
        ValuePropertyAdapterTests.assertTrue((boolean)this.junkHolder2.hasAnyStateChangeListeners());
        this.junkHolder2.removeStateChangeListener((StateChangeListener)l);
        ValuePropertyAdapterTests.assertFalse((boolean)this.junk.hasAnyPropertyChangeListeners("name"));
        ValuePropertyAdapterTests.assertFalse((boolean)this.junkHolder2.hasAnyStateChangeListeners());
    }

    public void testChangeProperty() {
        LocalListener l = new LocalListener(this.junkHolder2, null, (Object)this.junk);
        this.junkHolder2.addStateChangeListener((StateChangeListener)l);
        this.junk.setName("bar");
        ValuePropertyAdapterTests.assertTrue((boolean)l.eventReceived());
    }

    class Junk
    extends AbstractModel {
        private String name;
        public static final String NAME_PROPERTY = "name";

        public Junk(String name) {
            this.name = name;
        }

        public void setName(String name) {
            String old = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, old, name);
        }

        public String toString() {
            return "Junk(" + this.name + ")";
        }
    }

    class LocalListener
    extends ChangeAdapter {
        private boolean eventReceived = false;
        private final Object source;
        private final Object oldValue;
        private final Object newValue;

        LocalListener(Object source) {
            this(source, null, null);
        }

        LocalListener(Object source, Object oldValue, Object newValue) {
            this.source = source;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public void propertyChanged(PropertyChangeEvent e) {
            this.eventReceived = true;
            ValuePropertyAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
            ValuePropertyAdapterTests.assertEquals((Object)this.oldValue, (Object)e.getOldValue());
            ValuePropertyAdapterTests.assertEquals((Object)this.newValue, (Object)e.getNewValue());
            ValuePropertyAdapterTests.assertEquals((String)"value", (String)e.getPropertyName());
        }

        public void stateChanged(StateChangeEvent e) {
            this.eventReceived = true;
            ValuePropertyAdapterTests.assertEquals((Object)this.source, (Object)e.getSource());
        }

        boolean eventReceived() {
            return this.eventReceived;
        }
    }
}

