/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.synchronizers;

import org.eclipse.jpt.utility.Command;
import org.eclipse.jpt.utility.internal.CompositeException;
import org.eclipse.jpt.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.utility.internal.synchronizers.Synchronizer;
import org.eclipse.jpt.utility.internal.synchronizers.SynchronousSynchronizer;
import org.eclipse.jpt.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.utility.tests.internal.TestTools;

public class SynchronousSynchronizerTests
extends MultiThreadedTestCase {
    PrimaryModel1 primaryModel1;
    SecondaryModel1 secondaryModel1;
    Command command1;
    Synchronizer synchronizer1;
    PrimaryModel2 primaryModel2;
    SecondaryModel2 secondaryModel2;
    Command command2;
    Synchronizer synchronizer2;
    public static final boolean DEBUG = false;

    public SynchronousSynchronizerTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.primaryModel1 = new PrimaryModel1();
        this.secondaryModel1 = new SecondaryModel1(this.primaryModel1);
        this.command1 = new SynchronizeSecondaryModelCommand1(this.secondaryModel1);
        this.synchronizer1 = new SynchronousSynchronizer(this.command1);
        this.primaryModel1.setSynchronizer(this.synchronizer1);
        this.primaryModel2 = new PrimaryModel2();
        this.secondaryModel2 = new SecondaryModel2(this.primaryModel2);
        this.command2 = new SynchronizeSecondaryModelCommand2(this.primaryModel2, this.secondaryModel2);
        this.synchronizer2 = new SynchronousSynchronizer(this.command2);
        this.primaryModel2.setSynchronizer(this.synchronizer2);
    }

    public void testInitialization() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testToString() {
        SynchronousSynchronizerTests.assertNotNull((Object)this.synchronizer1.toString());
    }

    public void testChange() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testStart() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(Synchronizer.Null.instance());
        this.primaryModel1.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.setSynchronizer(this.synchronizer1);
        SynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testStop() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        this.primaryModel1.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testDoubleStart() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        boolean exCaught = false;
        try {
            this.primaryModel1.startSynchronizer();
            SynchronousSynchronizerTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        SynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testDoubleStop() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
        this.primaryModel1.dispose();
        boolean exCaught = false;
        try {
            this.primaryModel1.dispose();
            SynchronousSynchronizerTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        SynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        this.primaryModel1.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel1.getDoubleCount());
    }

    public void testRecursiveChange() {
        SynchronousSynchronizerTests.assertEquals((int)4, (int)this.secondaryModel2.getDoubleCount());
        this.primaryModel2.setCount(7);
        SynchronousSynchronizerTests.assertEquals((int)10, (int)this.primaryModel2.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)14, (int)this.secondaryModel2.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)20, (int)this.secondaryModel2.getDoubleCountPlus3());
    }

    public void testCallStopFromAnotherThread() throws Exception {
        SynchronousSynchronizerTests.log("=====" + this.getName() + "=====");
        PrimaryModel2 primaryModel3 = new PrimaryModel2();
        SecondaryModel3 secondaryModel3 = new SecondaryModel3(primaryModel3);
        SynchronizeSecondaryModelCommand2 command3 = new SynchronizeSecondaryModelCommand2(primaryModel3, secondaryModel3);
        SynchronousSynchronizer synchronizer3 = new SynchronousSynchronizer((Command)command3);
        primaryModel3.setSynchronizer((Synchronizer)synchronizer3);
        secondaryModel3.setTicks(2L);
        SynchronousSynchronizerTests.assertEquals((int)2, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)5, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)4, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
        Thread syncThread = this.buildTriggerSynchronizeThread(primaryModel3, 1L);
        Thread stopThread = this.buildStopThread((Synchronizer)synchronizer3, 2L);
        SynchronousSynchronizerTests.log("ALL threads start");
        stopThread.start();
        syncThread.start();
        stopThread.join();
        syncThread.join();
        SynchronousSynchronizerTests.assertEquals((int)7, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)14, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
    }

    private Thread buildTriggerSynchronizeThread(PrimaryModel2 primaryModel, long ticks) {
        return this.buildThread(this.buildTriggerSynchronizeRunnable(primaryModel, ticks), "trigger sync");
    }

    private Runnable buildTriggerSynchronizeRunnable(final PrimaryModel2 primaryModel, final long ticks) {
        return new Runnable(){

            public void run() {
                TestTools.sleep(ticks * TICK);
                primaryModel.setCount(7);
            }
        };
    }

    private Thread buildStopThread(Synchronizer synchronizer, long ticks) {
        return this.buildThread(this.buildStopRunnable(synchronizer, ticks), "stop");
    }

    private Runnable buildStopRunnable(final Synchronizer synchronizer, final long ticks) {
        return new Runnable(){

            public void run() {
                TestTools.sleep(ticks * TICK);
                SynchronousSynchronizerTests.log("STOP thread Synchronizer.stop()");
                synchronizer.stop();
                SynchronousSynchronizerTests.log("STOP thread stop");
            }
        };
    }

    public void testInterruptStopThread() throws Exception {
        SynchronousSynchronizerTests.log("=====" + this.getName() + "=====");
        PrimaryModel2 primaryModel3 = new PrimaryModel2();
        SecondaryModel3 secondaryModel3 = new SecondaryModel3(primaryModel3);
        SynchronizeSecondaryModelCommand2 command3 = new SynchronizeSecondaryModelCommand2(primaryModel3, secondaryModel3);
        SynchronousSynchronizer synchronizer3 = new SynchronousSynchronizer((Command)command3);
        primaryModel3.setSynchronizer((Synchronizer)synchronizer3);
        secondaryModel3.setTicks(3L);
        SynchronousSynchronizerTests.assertEquals((int)2, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)5, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)4, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
        Thread syncThread = this.buildTriggerSynchronizeThread(primaryModel3, 1L);
        Thread stopThread = this.buildStopThread((Synchronizer)synchronizer3, 2L);
        Thread interruptThread = this.buildInterruptThread(stopThread, 3L);
        SynchronousSynchronizerTests.log("ALL threads start");
        stopThread.start();
        syncThread.start();
        interruptThread.start();
        stopThread.join();
        syncThread.join();
        interruptThread.join();
        SynchronousSynchronizerTests.assertEquals((int)7, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)14, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
    }

    public void testInterruptSyncThread() throws Exception {
        SynchronousSynchronizerTests.log("=====" + this.getName() + "=====");
        PrimaryModel2 primaryModel3 = new PrimaryModel2();
        SecondaryModel3 secondaryModel3 = new SecondaryModel3(primaryModel3);
        SynchronizeSecondaryModelCommand2 command3 = new SynchronizeSecondaryModelCommand2(primaryModel3, secondaryModel3);
        SynchronousSynchronizer synchronizer3 = new SynchronousSynchronizer((Command)command3);
        primaryModel3.setSynchronizer((Synchronizer)synchronizer3);
        secondaryModel3.setTicks(4L);
        SynchronousSynchronizerTests.assertEquals((int)2, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)5, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)4, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
        Thread syncThread = this.buildTriggerSynchronizeThread(primaryModel3, 1L);
        Thread stopThread = this.buildStopThread((Synchronizer)synchronizer3, 2L);
        Thread interruptThread = this.buildInterruptThread(syncThread, 3L);
        SynchronousSynchronizerTests.log("ALL threads start");
        stopThread.start();
        syncThread.start();
        interruptThread.start();
        stopThread.join();
        syncThread.join();
        interruptThread.join();
        SynchronousSynchronizerTests.assertEquals((int)7, (int)primaryModel3.getCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)primaryModel3.getCountPlus3());
        SynchronousSynchronizerTests.assertEquals((int)4, (int)secondaryModel3.getDoubleCount());
        SynchronousSynchronizerTests.assertEquals((int)10, (int)secondaryModel3.getDoubleCountPlus3());
    }

    private Thread buildInterruptThread(Thread thread, long ticks) {
        return this.buildThread(this.buildInterruptRunnable(thread, ticks), "interrupt");
    }

    private Runnable buildInterruptRunnable(final Thread thread, final long ticks) {
        return new Runnable(){

            public void run() {
                TestTools.sleep(ticks * TICK);
                SynchronousSynchronizerTests.log("INTERRUPT thread Thread.interrupt()");
                thread.interrupt();
            }
        };
    }

    public void testCallStartDuringStop() throws Exception {
        SynchronousSynchronizerTests.log("=====" + this.getName() + "=====");
        DelayCommand command = this.buildDelayCommand(3);
        SynchronousSynchronizer synchronizer = new SynchronousSynchronizer((Command)command);
        synchronizer.start();
        Thread syncThread = this.buildSynchronizeThread((Synchronizer)synchronizer, 1L);
        Thread stopThread = this.buildStopThread((Synchronizer)synchronizer, 2L);
        SynchronizedBoolean exCaught = new SynchronizedBoolean(false);
        Thread startThread = this.buildStartThread((Synchronizer)synchronizer, 3L, exCaught);
        SynchronousSynchronizerTests.log("ALL threads start");
        syncThread.start();
        stopThread.start();
        startThread.start();
        syncThread.join();
        stopThread.join();
        startThread.join();
        SynchronousSynchronizerTests.assertTrue((boolean)exCaught.getValue());
        SynchronousSynchronizerTests.assertEquals((int)2, (int)command.count);
    }

    private DelayCommand buildDelayCommand(int ticks) {
        return new DelayCommand(ticks);
    }

    private Thread buildStartThread(Synchronizer synchronizer, long ticks, SynchronizedBoolean exCaught) {
        return this.buildThread(this.buildStartRunnable(synchronizer, ticks, exCaught), "start");
    }

    private Runnable buildStartRunnable(final Synchronizer synchronizer, final long ticks, final SynchronizedBoolean exCaught) {
        return new Runnable(){

            public void run() {
                TestTools.sleep(ticks * TICK);
                SynchronousSynchronizerTests.log("START thread Synchronizer.start()");
                try {
                    synchronizer.start();
                }
                catch (IllegalStateException illegalStateException) {
                    exCaught.setTrue();
                    SynchronousSynchronizerTests.log("START thread exception");
                }
                SynchronousSynchronizerTests.log("START thread stop");
            }
        };
    }

    private Thread buildSynchronizeThread(Synchronizer synchronizer, long ticks) {
        return this.buildThread(this.buildSynchronizeRunnable(synchronizer, ticks), "synchronize");
    }

    private Runnable buildSynchronizeRunnable(final Synchronizer synchronizer, final long ticks) {
        return new Runnable(){

            public void run() {
                TestTools.sleep(ticks * TICK);
                SynchronousSynchronizerTests.log("SYNC thread Synchronizer.synchronize()");
                synchronizer.synchronize();
                SynchronousSynchronizerTests.log("SYNC thread stop");
            }
        };
    }

    public void testException() throws Exception {
        BogusCommand command = new BogusCommand();
        SynchronousSynchronizer synchronizer = new SynchronousSynchronizer((Command)command);
        synchronizer.start();
        try {
            synchronizer.synchronize();
        }
        catch (NullPointerException nullPointerException) {}
        boolean exCaught = false;
        try {
            synchronizer.stop();
            SynchronousSynchronizerTests.fail();
        }
        catch (CompositeException ex) {
            SynchronousSynchronizerTests.assertEquals((int)1, (int)ex.getExceptions().length);
            exCaught = true;
        }
        SynchronousSynchronizerTests.assertTrue((boolean)exCaught);
        SynchronousSynchronizerTests.assertEquals((int)2, (int)command.count);
    }

    public void testDEBUG() {
        SynchronousSynchronizerTests.assertFalse((boolean)false);
    }

    public static void log(String message) {
    }

    private static void log_(String message) {
        System.out.print(SynchronousSynchronizerTests.timestamp());
        System.out.print(' ');
        System.out.print(message);
        System.out.println();
    }

    public static String timestamp() {
        return String.valueOf((float)(System.currentTimeMillis() % 10000L) / 1000.0f);
    }

    public class BogusCommand
    implements Command {
        int count = 0;

        public void execute() {
            ++this.count;
            if (this.count > 1) {
                throw new NullPointerException();
            }
        }
    }

    class DelayCommand
    implements Command {
        final long ticks;
        boolean first = true;
        int count = 0;

        DelayCommand(int ticks) {
            this.ticks = ticks;
        }

        public void execute() {
            ++this.count;
            if (this.first) {
                SynchronousSynchronizerTests.log("EXEC first");
                this.first = false;
                return;
            }
            SynchronousSynchronizerTests.log("EXEC start " + this.count);
            TestTools.sleep(this.ticks * TICK);
            SynchronousSynchronizerTests.log("EXEC stop " + this.count);
        }
    }

    public static class PrimaryModel1 {
        protected Synchronizer synchronizer;
        protected int count = 2;

        public PrimaryModel1() {
            this.setSynchronizer_(Synchronizer.Null.instance());
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            if (count != this.count) {
                this.count = count;
                this.stateChanged();
            }
        }

        protected void stateChanged() {
            this.synchronizer.synchronize();
        }

        public void setSynchronizer(Synchronizer synchronizer) {
            if (synchronizer == null) {
                throw new NullPointerException();
            }
            this.synchronizer.stop();
            this.setSynchronizer_(synchronizer);
        }

        protected void setSynchronizer_(Synchronizer synchronizer) {
            this.synchronizer = synchronizer;
            this.synchronizer.start();
        }

        public void startSynchronizer() {
            this.synchronizer.start();
        }

        public void dispose() {
            this.synchronizer.stop();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("count=");
            sb.append(this.count);
        }
    }

    public static class PrimaryModel2
    extends PrimaryModel1 {
        private int countPlus3 = this.count + 3;

        public int getCountPlus3() {
            return this.countPlus3;
        }

        protected void setCountPlus3(int countPlus3) {
            if (countPlus3 != this.countPlus3) {
                this.countPlus3 = countPlus3;
                this.stateChanged();
            }
        }

        public void synchronize() {
            this.setCountPlus3(this.count + 3);
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", countPlus3=");
            sb.append(this.countPlus3);
        }
    }

    public static class SecondaryModel1 {
        protected final PrimaryModel1 primaryModel;
        protected int doubleCount = 0;

        public SecondaryModel1(PrimaryModel1 primaryModel) {
            this.primaryModel = primaryModel;
            this.synchronize();
        }

        public void synchronize() {
            this.doubleCount = this.primaryModel.getCount() * 2;
        }

        public int getDoubleCount() {
            return this.doubleCount;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName());
            sb.append('(');
            this.toString(sb);
            sb.append(')');
            return sb.toString();
        }

        public void toString(StringBuilder sb) {
            sb.append("doubleCount=");
            sb.append(this.doubleCount);
        }
    }

    public static class SecondaryModel2
    extends SecondaryModel1 {
        private int doubleCountPlus3 = 0;

        public SecondaryModel2(PrimaryModel2 extendedPrimaryModel) {
            super(extendedPrimaryModel);
        }

        protected PrimaryModel2 getExtendedPrimaryModel() {
            return (PrimaryModel2)this.primaryModel;
        }

        public void synchronize() {
            super.synchronize();
            int temp = this.getExtendedPrimaryModel().getCountPlus3() * 2;
            if (this.doubleCountPlus3 != temp) {
                this.doubleCountPlus3 = temp;
            }
        }

        public int getDoubleCountPlus3() {
            return this.doubleCountPlus3;
        }

        public void toString(StringBuilder sb) {
            super.toString(sb);
            sb.append(", doubleCountPlus3=");
            sb.append(this.doubleCountPlus3);
        }
    }

    public static class SecondaryModel3
    extends SecondaryModel2 {
        private long delay = 0L;

        public SecondaryModel3(PrimaryModel2 primaryModel) {
            super(primaryModel);
        }

        public void setTicks(long ticks) {
            this.delay = ticks * TICK;
        }

        public void synchronize() {
            if (this.delay == 0L) {
                super.synchronize();
            } else {
                SynchronousSynchronizerTests.log("SYNC thread start - sync duration will be: " + this.delay / TICK + " ticks");
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                    SynchronousSynchronizerTests.log("SYNC thread interrupted");
                    TestTools.sleep(TICK);
                    return;
                }
                super.synchronize();
                SynchronousSynchronizerTests.log("SYNC thread stop");
            }
        }
    }

    public static class SynchronizeSecondaryModelCommand1
    implements Command {
        private final SecondaryModel1 secondaryModel;

        public SynchronizeSecondaryModelCommand1(SecondaryModel1 secondaryModel) {
            this.secondaryModel = secondaryModel;
        }

        public void execute() {
            this.secondaryModel.synchronize();
        }
    }

    public static class SynchronizeSecondaryModelCommand2
    extends SynchronizeSecondaryModelCommand1 {
        private final PrimaryModel2 primaryModel;

        public SynchronizeSecondaryModelCommand2(PrimaryModel2 primaryModel, SecondaryModel2 secondaryModel) {
            super(secondaryModel);
            this.primaryModel = primaryModel;
        }

        public void execute() {
            super.execute();
            this.primaryModel.synchronize();
        }
    }
}

