/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.el.IInstancePerProjectResolver;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicExtensionFactory<EXTENSIONTYPE> {
    private final Bundle _bundle;
    private final String _extName;
    private Map<String, ExtensionData<EXTENSIONTYPE>> _registeredResolvers;
    private final String _elementName;
    private final ExtensionDataFactory _extensionDataFactory;
    private final boolean _alwaysPerProject;

    public BasicExtensionFactory(Bundle bundle, String extName, String elementName, boolean alwaysPerProject) {
        this._bundle = bundle;
        this._extName = extName;
        this._elementName = elementName;
        this._extensionDataFactory = new ExtensionDataFactory();
        this._alwaysPerProject = alwaysPerProject;
    }

    public final Map<String, ExtensionData<EXTENSIONTYPE>> getExtensions() {
        if (this._registeredResolvers == null) {
            this._registeredResolvers = this.loadRegisteredExtensions();
        }
        return this._registeredResolvers;
    }

    protected Map<String, ExtensionData<EXTENSIONTYPE>> loadRegisteredExtensions() {
        IExtension[] extensions;
        HashMap<String, ExtensionData<EXTENSIONTYPE>> resolvers = new HashMap<String, ExtensionData<EXTENSIONTYPE>>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this._bundle.getSymbolicName(), this._extName);
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                ExtensionData extData;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (this._elementName.equals(element.getName()) && element.getAttribute("class") != null && element.getAttribute("id") != null && (extData = this.processExtension(element, this._alwaysPerProject)) != null) {
                    resolvers.put(extData.getId(), extData);
                }
                ++n4;
            }
            ++n2;
        }
        return resolvers;
    }

    protected ExtensionData processExtension(IConfigurationElement element, boolean alwaysPerProject) {
        return this._extensionDataFactory.createExtensionData(element, alwaysPerProject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExtensionData<EXTENSIONTYPE> {
        private final IConfigurationElement _element;

        protected ExtensionData(IConfigurationElement element) {
            this._element = element;
        }

        public String getId() {
            return this._element.getAttribute("id");
        }

        public abstract EXTENSIONTYPE getInstance(IProject var1);

        public abstract EXTENSIONTYPE removeInstance(IProject var1);

        protected EXTENSIONTYPE createInstance() throws CoreException {
            return (EXTENSIONTYPE)this._element.createExecutableExtension("class");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ExtensionDataFactory<EXTENSIONTYPE> {
        protected ExtensionDataFactory() {
        }

        ExtensionData createExtensionData(IConfigurationElement element, boolean alwaysPerProject) {
            if (ExtensionDataFactory.isPerProjectExtension(element, alwaysPerProject)) {
                return new PerProjectExtensionData(element);
            }
            return new SingleInstanceExtensionData(element);
        }

        static boolean isPerProjectExtension(IConfigurationElement element, boolean alwaysPerProject) {
            if (alwaysPerProject) {
                return true;
            }
            String flag = element.getAttribute("instancePerProject");
            if (flag != null) {
                return Boolean.valueOf(flag);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class PerProjectExtensionData<EXTENSIONTYPE>
    extends ExtensionData<EXTENSIONTYPE> {
        private Map<IProject, EXTENSIONTYPE> _extensions;

        protected PerProjectExtensionData(IConfigurationElement element) {
            super(element);
        }

        @Override
        public EXTENSIONTYPE getInstance(IProject project) {
            EXTENSIONTYPE instance;
            if (!project.isAccessible()) {
                this._extensions.remove(project);
                return null;
            }
            if (this._extensions == null) {
                this._extensions = new HashMap<IProject, EXTENSIONTYPE>();
            }
            if ((instance = this._extensions.get(project)) == null) {
                try {
                    instance = this.createInstance();
                    if (instance instanceof IInstancePerProjectResolver) {
                        ((IInstancePerProjectResolver)instance).setProject(project);
                    }
                    this._extensions.put(project, instance);
                }
                catch (Exception e) {
                    JSFCorePlugin.log(e, "Instantiating extension class for id: " + this.getId());
                }
            }
            return instance;
        }

        @Override
        public EXTENSIONTYPE removeInstance(IProject project) {
            if (this._extensions != null) {
                return this._extensions.remove(project);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SingleInstanceExtensionData<EXTENSIONTYPE>
    extends ExtensionData<EXTENSIONTYPE> {
        private EXTENSIONTYPE _instance;

        protected SingleInstanceExtensionData(IConfigurationElement element) {
            super(element);
        }

        @Override
        public EXTENSIONTYPE getInstance(IProject project) {
            if (this._instance == null) {
                try {
                    this._instance = this.createInstance();
                }
                catch (CoreException e) {
                    JSFCorePlugin.log((Exception)((Object)e), "Instantiating extension class for id: " + this.getId());
                }
            }
            return this._instance;
        }

        @Override
        public EXTENSIONTYPE removeInstance(IProject project) {
            EXTENSIONTYPE removedItem = this._instance;
            this._instance = null;
            return removedItem;
        }
    }
}

