/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.DTAppManagerUtil;
import org.eclipse.jst.jsf.designtime.internal.view.IDTViewHandler;
import org.eclipse.jst.jsf.designtime.internal.view.XMLViewDefnAdapter;
import org.eclipse.jst.jsf.ui.internal.contentassist.JSFContentAssistProcessor;
import org.eclipse.jst.jsf.ui.internal.contentassist.el.JSFELContentAssistProcessor;

public class CompositeAttributeAssistProcessor
implements IContentAssistProcessor {
    private JSFContentAssistProcessor _nonELProcessor = new JSFContentAssistProcessor();
    private JSFELContentAssistProcessor _elProcessor = new JSFELContentAssistProcessor();
    private char[] _activationChars;

    public CompositeAttributeAssistProcessor() {
        char[] nonELChars = this._nonELProcessor.getCompletionProposalAutoActivationCharacters();
        char[] elChars = this._elProcessor.getCompletionProposalAutoActivationCharacters();
        this._activationChars = new char[nonELChars.length + elChars.length];
        System.arraycopy(nonELChars, 0, this._activationChars, 0, nonELChars.length);
        System.arraycopy(elChars, 0, this._activationChars, nonELChars.length, elChars.length);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.isEL(viewer, offset)) {
            return this._elProcessor.computeCompletionProposals(viewer, offset);
        }
        return this._nonELProcessor.computeCompletionProposals(viewer, offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        if (this.isEL(viewer, offset)) {
            return this._elProcessor.computeContextInformation(viewer, offset);
        }
        return this._nonELProcessor.computeContextInformation(viewer, offset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this._activationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private boolean isEL(ITextViewer viewer, int offset) {
        XMLViewDefnAdapter adapter;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(viewer, offset);
        if (context != null && (adapter = DTAppManagerUtil.getXMLViewDefnAdapter((IStructuredDocumentContext)context)) != null) {
            try {
                XMLViewDefnAdapter.DTELExpression elExpression = adapter.getELExpression((IModelContext)context);
                if (elExpression != null) {
                    return true;
                }
            }
            catch (IDTViewHandler.ViewHandlerException viewHandlerException) {}
        }
        return false;
    }
}

